/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories;

import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.TransactionStatus;

public class ProcessingOnDeviceMeasurement {
    public static final String ALTERNATIVE_CARD = "alternative card";
    public static final String APPROVED = "approved";
    public static final String DECLINED = "declined";
    public static final String FAILED = "failed";
    public static final String ONLINE_AUTHORIZATION = "online auth";
    public static final String CANCELED = "cancel";
    public static final String EVALUATE_CARD = "evaluate card";
    public static final String CARD_NOT_SUPPORTED = "card not supported";
    public static final String BEGIN_MEASUREMENT_INFORMATION = "starting tx on device";

    private ProcessingOnDeviceMeasurement() {
    }

    public static String informationFromEmvError(DefaultTransaction transaction, AbstractCardProcessingModule.EmvErrorType emvErrorType, AbstractCardProcessingModule.FallbackStatus fallbackStatus) {
        ProcessingOnDeviceMeasurement.checkTransactionStatus(transaction);
        return String.format("returning emv error with status '%s', '%s', '%s'", new Object[]{transaction.getStatus(), emvErrorType, fallbackStatus});
    }

    public static String constructInformation(String information, BaseTransaction transaction) {
        ProcessingOnDeviceMeasurement.checkTransactionStatus(transaction);
        return ProcessingOnDeviceMeasurement.constructInformation(information, transaction.getStatus());
    }

    public static String constructInformation(String information, TransactionStatus transactionStatus) {
        return String.format("returning %s, with status '%s'", information, transactionStatus.toString().toLowerCase());
    }

    public static void reportBegin(Profiler profiler, String targetClass) {
        profiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ON_DEVICE, "starting tx on device, starting workflow: " + targetClass);
    }

    public static void reportEnd(Profiler profiler, String information) {
        profiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ON_DEVICE, information);
    }

    public static void reportEnd(Profiler profiler, String information, BaseTransaction transaction) {
        profiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ON_DEVICE, ProcessingOnDeviceMeasurement.constructInformation(information, transaction));
    }

    public static void reportEndWithError(Profiler profiler, String information) {
        profiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING_ON_DEVICE, information);
    }

    public static void reportEndWithError(Profiler profiler, String information, BaseTransaction transaction) {
        profiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING_ON_DEVICE, ProcessingOnDeviceMeasurement.constructInformation(information, transaction));
    }

    private static void checkTransactionStatus(BaseTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null");
        }
        if (transaction.getStatus() == null) {
            throw new IllegalArgumentException("Transaction status cannot be null");
        }
    }
}

