/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories.modules;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.paymentdetails.PinInformation;
import io.mpos.shared.accessories.modules.AbstractModule;
import io.mpos.shared.accessories.modules.DisplayHtmlData;
import io.mpos.shared.accessories.modules.listener.DisplayIdleScreenListener;
import io.mpos.shared.accessories.modules.listener.DisplayPinUpdateListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.accessories.modules.listener.LanguageSwitchListener;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.actionresponse.TransactionActionResponse;
import java.util.Locale;

public abstract class AbstractDisplayModule
extends AbstractModule {
    int mLineWidth;
    private LanguageSwitchListener languageSwitchListener;

    public AbstractDisplayModule(PaymentAccessory accessory) {
        super(accessory);
    }

    public abstract void displayText(String[] var1, GenericOperationSuccessFailureListener<Accessory, String[]> var2);

    public void displayText(DisplayHtmlData text, GenericOperationSuccessFailureListener<Accessory, String[]> listener) {
        this.displayText(text.getText(), listener);
    }

    public abstract void displayIdleScreen(DisplayIdleScreenListener var1);

    public abstract void displayPinUpdate(PinInformation var1, String[] var2, DisplayPinUpdateListener var3);

    public abstract void displayIdleScreenAfterTimeout();

    public abstract void cancelDisplayIdleScreenAfterTimeout();

    public void continueWithAction(TransactionAction action, TransactionActionResponse response) {
    }

    public int getLineWidth() {
        return this.mLineWidth;
    }

    protected void setLineWidth(int lineWidth) {
        this.mLineWidth = lineWidth;
    }

    public void setLanguageSwitchListener(LanguageSwitchListener languageSwitchListener) {
        this.languageSwitchListener = languageSwitchListener;
    }

    public void switchTerminalAndPromptsLanguage(Locale selectedLanguage, LanguageSwitchListener listener) {
        if (this.languageSwitchListener != null) {
            this.languageSwitchListener.onOperationSuccess(this.mAccessory, selectedLanguage);
        }
        listener.onOperationSuccess(this.mAccessory, selectedLanguage);
    }

    public void setTerminalLanguage(Locale selectedLanguage, LanguageSwitchListener listener) {
        listener.onOperationSuccess(this.mAccessory, selectedLanguage);
    }
}

