/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories.mpivipa;

import io.mpos.logger.Log;
import io.mpos.specs.iso7816.IsoBlockFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MpiVipaChainedMessageReader {
    private static final byte PCB_IS_CHAINED = 1;
    private static final String TAG = "MiuraChainedMessageReader";
    private ByteArrayOutputStream queuedData = new ByteArrayOutputStream();

    private boolean hasPreviousParts() {
        return this.queuedData.size() > 0;
    }

    private void queueData(byte[] data) {
        try {
            this.queuedData.write(data);
        }
        catch (IOException iOException) {
            Log.e(TAG, "queueing iso data failed", iOException);
        }
    }

    public IsoBlockFrame process(IsoBlockFrame blockFrame) {
        if ((blockFrame.getPcb() & 1) == 1 && !this.hasPreviousParts()) {
            this.queueData(blockFrame.getInf());
            return null;
        }
        if ((blockFrame.getPcb() & 1) == 1 && this.hasPreviousParts()) {
            this.queueData(blockFrame.getInf());
            return null;
        }
        if (this.hasPreviousParts()) {
            this.queueData(blockFrame.getInf());
            byte[] byArray = this.getQueueAndReset();
            return IsoBlockFrame.createUnsafeIsoBlockFrame(blockFrame.getNad(), blockFrame.getPcb(), byArray);
        }
        return blockFrame;
    }

    private byte[] getQueueAndReset() {
        byte[] byArray = this.queuedData.toByteArray();
        this.queuedData.reset();
        return byArray;
    }
}

