/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories.payment;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryState;
import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.AccessoryUpdateRequirementComponent;
import io.mpos.accessories.events.AccessoryCardEvent;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.accessories.payment.listener.PaymentAccessoryDisplayActionListener;
import io.mpos.errors.MposError;
import io.mpos.shared.accessories.AbstractAccessory;
import io.mpos.shared.accessories.DefaultAccessoryUpdateRequirement;
import io.mpos.shared.accessories.EncryptionDetails;
import io.mpos.shared.accessories.EncryptionKeyInjectionStrategy;
import io.mpos.shared.accessories.PaymentAccessoryRequirement;
import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.accessories.modules.AbstractDisplayModule;
import io.mpos.shared.accessories.modules.AbstractInteractionModule;
import io.mpos.shared.accessories.modules.AbstractLogModule;
import io.mpos.shared.accessories.modules.AbstractSecurityModule;
import io.mpos.shared.accessories.modules.AbstractStatusModule;
import io.mpos.shared.accessories.modules.AbstractSystemModule;
import io.mpos.shared.accessories.modules.DisplayHtmlData;
import io.mpos.shared.accessories.modules.listener.DisplayIdleScreenListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.providercomponent.AccessoryStateChangedBusEvent;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.localization.LocalizationPromptParameters;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.workflows.WorkflowInteraction;
import io.mpos.shared.workflows.accessory.ConfigurationItem;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractPaymentAccessory
extends AbstractAccessory
implements PaymentAccessory {
    private static final String TAG = "AbstractPaymentAccessory";
    protected EnumSet<PaymentAccessoryFeatures> mPaymentAccessoryFeatures = EnumSet.of(PaymentAccessoryFeatures.NONE);
    protected EnumSet<PaymentAccessoryRequirement> mPaymentAccessoryRequirements = EnumSet.of(PaymentAccessoryRequirement.NONE);
    protected EncryptionKeyInjectionStrategy mEncryptionKeyInjectionStrategy = EncryptionKeyInjectionStrategy.NOT_SUPPORTED;
    protected AccessoryState mState = AccessoryState.UNKNOWN;
    protected AccessoryCardEvent lastCardEvent;
    protected EncryptionDetails mEncryptionDetails = new EncryptionDetails();
    protected AbstractCardProcessingModule cardProcessingModule;
    protected AbstractDisplayModule displayModule;
    protected AbstractInteractionModule interactionModule;
    protected AbstractLogModule logModule;
    protected AbstractSecurityModule securityModule;
    protected AbstractStatusModule statusModule;
    protected AbstractSystemModule systemModule;
    protected DefaultAccessoryUpdateRequirement mUpdateRequirement;
    private WorkflowInteraction mWorkflowInteraction;
    protected boolean mCardPresent = false;
    protected boolean mTypeProvidedByAccessory = false;
    protected boolean mShowIdleScreenTimerAfterCardRemoval;
    protected Set<ConfigurationItem> mCurrentConfiguration;
    protected String[] mIdleScreenText;
    protected WhitelistAccessory mWhitelistAccessory;

    protected AbstractPaymentAccessory(CommunicationModule communicationModule, Locale locale) {
        super(communicationModule, locale);
    }

    protected AbstractPaymentAccessory(CommunicationModule communicationModule) {
        super(communicationModule);
    }

    @Override
    public EnumSet<PaymentAccessoryFeatures> getPaymentAccessoryFeatures() {
        return this.mPaymentAccessoryFeatures;
    }

    public EnumSet<PaymentAccessoryRequirement> getPaymentAccessoryRequirements() {
        return this.mPaymentAccessoryRequirements;
    }

    public EncryptionKeyInjectionStrategy getEncryptionKeyInjectionStrategy() {
        return this.mEncryptionKeyInjectionStrategy;
    }

    @Override
    public AccessoryState getState() {
        return this.mState;
    }

    @Override
    public void displayText(String[] text, GenericOperationSuccessFailureListener<Accessory, String[]> listener) {
        this.displayModule.displayText(text, listener);
    }

    @Override
    public void displayText(DisplayHtmlData text, GenericOperationSuccessFailureListener<Accessory, String[]> listener) {
        this.displayModule.displayText(text.getText(), listener);
    }

    @Override
    public void displayIdleScreen(final PaymentAccessoryDisplayActionListener listener) {
        this.displayModule.displayIdleScreen(new DisplayIdleScreenListener(){

            @Override
            public void success(Accessory accessory) {
                listener.success();
            }

            @Override
            public void failure(Accessory accessory, MposError error) {
                listener.failure(error);
            }
        });
    }

    @Override
    public AbstractSystemModule getSystemModule() {
        return this.systemModule;
    }

    @Override
    public AbstractStatusModule getStatusModule() {
        return this.statusModule;
    }

    @Override
    public AbstractSecurityModule getSecurityModule() {
        return this.securityModule;
    }

    @Override
    public AbstractLogModule getLogModule() {
        return this.logModule;
    }

    @Override
    public AbstractDisplayModule getDisplayModule() {
        return this.displayModule;
    }

    @Override
    public AbstractCardProcessingModule getCardProcessingModule() {
        return this.cardProcessingModule;
    }

    @Override
    public AbstractInteractionModule getInteractionModule() {
        return this.interactionModule;
    }

    @Override
    public boolean isCardPresent() {
        return this.mCardPresent;
    }

    @Override
    public boolean isTypeProvidedByAccessory() {
        return this.mTypeProvidedByAccessory;
    }

    @Override
    public void showIdleScreenTimerAfterCardRemoval(boolean showIdleScreenTimerAfterCardRemoval) {
        this.mShowIdleScreenTimerAfterCardRemoval = showIdleScreenTimerAfterCardRemoval;
    }

    public void propagateAccessoryState(AccessoryState state) {
        this.setAccessoryState(state);
        BusProvider.getInstance().post((Object)new AccessoryStateChangedBusEvent(this, state));
    }

    public void setAccessoryState(AccessoryState state) {
        this.mState = state;
    }

    public EncryptionDetails getEncryptionDetails() {
        return this.mEncryptionDetails;
    }

    public void setEncryptionDetails(EncryptionDetails details) {
        this.mEncryptionDetails = details;
    }

    public void setLastCardEvent(AccessoryCardEvent cardEvent) {
        this.lastCardEvent = cardEvent;
    }

    public abstract boolean configurationUpdateRequired(WhitelistAccessory var1);

    public abstract boolean softwareUpdateRequired(WhitelistAccessory var1);

    public abstract boolean firmwareUpdateRequired(WhitelistAccessory var1);

    public DefaultAccessoryUpdateRequirement getUpdateRequirement() {
        return this.mUpdateRequirement;
    }

    public EnumSet<AccessoryUpdateRequirementComponent> getComponentsToUpdate() {
        return EnumSet.of(AccessoryUpdateRequirementComponent.FIRMWARE, AccessoryUpdateRequirementComponent.SOFTWARE, AccessoryUpdateRequirementComponent.CONFIGURATION);
    }

    public void setUpdateRequirement(DefaultAccessoryUpdateRequirement updateRequirement) {
        this.mUpdateRequirement = updateRequirement;
    }

    @Override
    public WorkflowInteraction getWorkflowInteraction() {
        return this.mWorkflowInteraction;
    }

    @Override
    public void setWorkflowInteraction(WorkflowInteraction workflowInteraction) {
        this.mWorkflowInteraction = workflowInteraction;
    }

    @Override
    public void setType(AccessoryType type) {
        this.mAccessoryType = type;
    }

    public void setCurrentConfiguration(Set<ConfigurationItem> configuration) {
        this.mCurrentConfiguration = configuration;
    }

    public boolean amountConfirmationRequired() {
        return this.getPaymentAccessoryRequirements().contains((Object)PaymentAccessoryRequirement.AMOUNT_CONFIRMATION);
    }

    public String[] getIdleScreenText() {
        return this.mIdleScreenText;
    }

    public void setIdleScreenText(String[] idleScreenText) {
        this.setIdleScreenText(idleScreenText, false);
    }

    public void setIdleScreenText(String[] idleScreenText, boolean useKeepAliveText) {
        if (idleScreenText != null) {
            this.mIdleScreenText = idleScreenText;
        } else {
            LocalizationPrompt localizationPrompt = useKeepAliveText ? LocalizationPrompt.IDLE_KEEP_ALIVE : LocalizationPrompt.IDLE;
            LocalizationPromptParameters localizationPromptParameters = new LocalizationPromptParameters.Builder(localizationPrompt).locale(this.getLocale()).lineWidth(this.getDisplayModule().getLineWidth()).build();
            this.mIdleScreenText = LocalizationServer.getInstance().getCenteredLocalizationArray(localizationPromptParameters);
        }
    }

    public AccessoryCardEvent getLastCardEvent() {
        return this.lastCardEvent;
    }

    public AccessoryParameters getAccessoryParameters() {
        return this.mCommunicationModule.getAccessoryParameters();
    }

    @Override
    public WhitelistAccessory getWhitelistAccessory() {
        return this.mWhitelistAccessory;
    }

    @Override
    public void setWhitelistAccessory(WhitelistAccessory whitelistAccessory) {
        this.mWhitelistAccessory = whitelistAccessory;
    }

    public void resetGlobalStateBeforeTransaction() {
    }

    @Override
    public boolean isLanguageSwitchSupported(Locale language) {
        return false;
    }

    @Override
    public List<byte[]> nativelySupportedStrongCustomerAuthenticationARCs() {
        return Collections.emptyList();
    }

    public static interface Builder {
        public AbstractPaymentAccessory build(CommunicationModule var1);
    }
}

