/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.communicationmodules;

import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryConnectionType;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.SuccessFailureListener;

public abstract class CommunicationModule {
    protected CommunicationDelegate mDelegate;
    protected AccessoryConnectionState mConnectionState = AccessoryConnectionState.UNKNOWN;
    protected AccessoryConnectionType mConnectionType = AccessoryConnectionType.UNKNOWN;
    protected AccessoryParameters mAccessoryParameters;

    public CommunicationModule(AccessoryParameters accessoryOptions) {
        this.mAccessoryParameters = accessoryOptions;
    }

    public abstract void sendData(byte[] var1);

    public void sendData(byte[] data, boolean applyTimeout) {
        this.sendData(data);
    }

    public abstract void connect(CommunicationDelegate var1, SuccessFailureListener var2);

    public abstract void disconnect(SuccessFailureListener var1);

    public AccessoryConnectionState getConnectionState() {
        return this.mConnectionState;
    }

    public AccessoryConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    protected void setConnectionState(AccessoryConnectionState newState) {
        this.mConnectionState = newState;
        if (this.mDelegate != null) {
            this.mDelegate.connectionStateChanged(newState);
        }
    }

    public AccessoryParameters getAccessoryParameters() {
        return this.mAccessoryParameters;
    }

    protected void setCommunicationDelegate(CommunicationDelegate delegate) {
        this.mDelegate = delegate;
    }

    public void accessorySetupCompleted() {
    }
}

