/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.errors;

import io.mpos.errors.ErrorSource;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.shared.localization.LocalizationPromptParameters;
import io.mpos.shared.localization.LocalizationServer;

public final class DefaultMposError
implements MposError {
    private final ErrorType mErrorType;
    private ErrorSource mErrorSource;
    private String mInfo = null;
    private String mDeveloperInfo = null;
    private Exception mException;

    public DefaultMposError(ErrorType errorType) {
        this.mErrorType = errorType;
        this.mErrorSource = errorType.getErrorSource();
        try {
            String[] stringArray = LocalizationServer.getInstance().getLocalizationError(new LocalizationPromptParameters.Builder(this.mErrorType.getKey()).build());
            if (stringArray != null && stringArray.length > 0) {
                this.mInfo = stringArray[0].trim();
            }
        }
        catch (Exception exception) {
            Log.w("MposError", "No suitable localization found for key: " + this.mErrorType.getKey());
        }
    }

    public DefaultMposError(ErrorType errorType, String developerInfo) {
        this(errorType);
        this.mDeveloperInfo = developerInfo;
    }

    public DefaultMposError(Exception e2) {
        this(ErrorType.INTERNAL_INCONSISTENCY, e2.getLocalizedMessage());
        this.mException = e2;
    }

    public DefaultMposError add(Exception e2) {
        this.mException = e2;
        return this;
    }

    public ErrorSource getErrorSource() {
        return this.mErrorSource;
    }

    public ErrorType getErrorType() {
        return this.mErrorType;
    }

    public String getInfo() {
        return this.mInfo;
    }

    public void setInfo(String info) {
        this.mInfo = info != null ? info.trim() : null;
    }

    public String getDeveloperInfo() {
        return this.mDeveloperInfo;
    }

    public Exception getException() {
        return this.mException;
    }

    public boolean isSdkError() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mErrorType);
        stringBuilder.append("(");
        stringBuilder.append(this.mErrorSource);
        stringBuilder.append(")");
        if (this.mInfo != null) {
            stringBuilder.append(", info='").append(this.mInfo).append('\'');
        }
        if (this.mDeveloperInfo != null) {
            stringBuilder.append(", developerInfo='").append(this.mDeveloperInfo).append('\'');
        }
        if (this.mException != null) {
            stringBuilder.append(", exception='").append(this.mException.getLocalizedMessage()).append('\'');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof DefaultMposError)) {
            return false;
        }
        DefaultMposError defaultMposError = (DefaultMposError)o2;
        if (this.mErrorType != defaultMposError.mErrorType) {
            return false;
        }
        if (this.mErrorSource != defaultMposError.mErrorSource) {
            return false;
        }
        if (this.mInfo != null ? !this.mInfo.equals(defaultMposError.mInfo) : defaultMposError.mInfo != null) {
            return false;
        }
        if (this.mDeveloperInfo != null ? !this.mDeveloperInfo.equals(defaultMposError.mDeveloperInfo) : defaultMposError.mDeveloperInfo != null) {
            return false;
        }
        return this.mException != null ? this.mException.equals(defaultMposError.mException) : defaultMposError.mException == null;
    }

    public int hashCode() {
        int n2 = this.mErrorType != null ? this.mErrorType.hashCode() : 0;
        n2 = 31 * n2 + (this.mErrorSource != null ? this.mErrorSource.hashCode() : 0);
        n2 = 31 * n2 + (this.mInfo != null ? this.mInfo.hashCode() : 0);
        n2 = 31 * n2 + (this.mDeveloperInfo != null ? this.mDeveloperInfo.hashCode() : 0);
        n2 = 31 * n2 + (this.mException != null ? this.mException.hashCode() : 0);
        return n2;
    }
}

