/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.events;

import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;
import io.mpos.logger.Log;

public final class BusProvider {
    private static final String TAG = "BusProvider";
    public static Bus BUS = new LoggingBus(ThreadEnforcer.ANY, "InternalBus");

    public static Bus getInstance() {
        return BUS;
    }

    public void post(Object event) {
        BUS.post(event);
    }

    private BusProvider() {
    }

    public static class LoggingBus
    extends Bus {
        public LoggingBus(ThreadEnforcer enforcer, String identifier) {
            super(enforcer, identifier);
        }

        public void register(Object object) {
            String cfr_ignored_0 = "register: " + object.getClass();
            super.register(object);
        }

        public void unregister(Object object) {
            String cfr_ignored_0 = "unregister: " + object.getClass();
            try {
                super.unregister(object);
            }
            catch (Exception exception) {
                Log.e(BusProvider.TAG, "exception thrown=", exception);
            }
        }

        public void post(Object event) {
            String cfr_ignored_0 = "post: " + event.getClass();
            super.post(event);
        }
    }
}

