/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.core.common.obfuscated.eq;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.Log;
import io.mpos.platform.AssetsLoader;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.processors.payworks.services.response.BackendObjectMapperKt;
import io.mpos.specs.helper.ByteHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import kotlinx.serialization.json.Json;

public final class AssetsHandler {
    private static final String TAG = "AssetsHandler";
    private final AssetsLoader mAssetsLoader;
    private MessageDigest mMessageDigest;
    private final Map<String, String> mChecksums = new HashMap<String, String>();
    private final Set<String> mChecked = new HashSet<String>();
    private final Json mapper = BackendObjectMapperKt.getBackendObjectMapper();
    static AssetsHandler INSTANCE;

    public static synchronized AssetsHandler getInstance() {
        return INSTANCE;
    }

    public static synchronized void init(AssetsLoader assetsLoader) {
        if (INSTANCE == null) {
            INSTANCE = new AssetsHandler(assetsLoader);
        }
    }

    private AssetsHandler(AssetsLoader assetsLoader) {
        this.mAssetsLoader = assetsLoader;
        try {
            this.mMessageDigest = MessageDigest.getInstance("SHA-256");
            this.initChecksums();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
    }

    protected synchronized void checkIntegrity(String name, InputStream is) throws MposRuntimeException {
        if (is == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_NOT_FOUND, "resource not found=" + name));
        }
        if (!this.mChecksums.containsKey(name)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_NOT_FOUND, "can't check resource integrity, because resource checksum is unavailable. Asset=" + name));
        }
        if (this.mChecked.contains(name)) {
            return;
        }
        try {
            String string;
            int n2;
            byte[] byArray = new byte[1024];
            while ((n2 = is.read(byArray)) != -1) {
                this.mMessageDigest.update(byArray, 0, n2);
            }
            String string2 = this.mChecksums.get(name);
            boolean bl2 = string2.equals(string = ByteHelper.toHexShortString(this.mMessageDigest.digest()).toLowerCase());
            if (!bl2) {
                Log.e(TAG, "checksum mismatch. asset=" + name + " expected=" + string2 + " actual=" + string);
                throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_MODIFIED, "checksum mismatch resource=" + name));
            }
            this.mChecked.add(name);
            is.close();
        }
        catch (IOException iOException) {
            Log.e(TAG, "can't open/read given asset=" + name, iOException);
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_NOT_FOUND, "missing or malformed resource=" + name));
        }
    }

    private void initChecksums() {
        this.mChecksums.put("checksums.json", "77d34efdd0a9976e39f251e2a1859dc78d4a9c1b5f417f1d5675463f6676e1f6");
        Map<String, String> map = this.mapJSONAsset("checksums.json", String.class);
        this.mChecksums.putAll(map);
    }

    public BufferedInputStream resolveAndCheckAsset(String asset) throws MposRuntimeException {
        BufferedInputStream bufferedInputStream = this.resolveAsset(asset);
        this.checkIntegrity(asset, bufferedInputStream);
        return this.resolveAsset(asset);
    }

    private BufferedInputStream resolveAsset(String asset) {
        if (asset == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.mAssetsLoader.getResourceAsInputStream(asset);
        }
        catch (IOException iOException) {
            Log.e(TAG, "Resource not found: " + asset);
        }
        if (inputStream != null) {
            return new BufferedInputStream(inputStream);
        }
        return null;
    }

    public boolean isAssetPresent(String asset) {
        BufferedInputStream bufferedInputStream = this.resolveAsset(asset);
        if (bufferedInputStream != null) {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
            return true;
        }
        return false;
    }

    private String readStreamIntoString(InputStream is) {
        Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public String readAssetIntoString(String asset) {
        BufferedInputStream bufferedInputStream = this.resolveAndCheckAsset(asset);
        if (bufferedInputStream == null) {
            return null;
        }
        return this.readStreamIntoString(bufferedInputStream);
    }

    private String getStringFromInputStream(BufferedInputStream stream) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
        StringWriter stringWriter = new StringWriter();
        while (-1 != (n2 = inputStreamReader.read(cArray))) {
            stringWriter.write(cArray, 0, n2);
        }
        return stringWriter.toString();
    }

    public <S, T> Map<S, T> mapJSONAssetGeneric(String asset, Class<S> mappedKey, Class<T> mappedValue) {
        BufferedInputStream bufferedInputStream = this.resolveAndCheckAsset(asset);
        String string = null;
        try {
            string = this.getStringFromInputStream(bufferedInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            return eq.a(this.mapper, string, mappedKey, mappedValue);
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "failed to read map JSON from resource=" + asset, runtimeException);
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "failed to read payment schemes resource. reason=" + runtimeException.getLocalizedMessage()));
        }
    }

    public <T> Map<String, T> mapJSONAsset(String asset, Class<T> mappedType) {
        return this.mapJSONAssetGeneric(asset, String.class, mappedType);
    }
}

