/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private int index = 0;
    private byte[] input_buffer = new byte[65536];
    private int input_pos = 0;
    private int input_len = 0;
    private boolean ignoreErrors = false;
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;

    public BASE64DecoderStream(InputStream in) {
        super(in);
        try {
            String string = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = string != null && !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {}
    }

    public BASE64DecoderStream(InputStream in, boolean ignoreErrors) {
        super(in);
        this.ignoreErrors = ignoreErrors;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.bufsize = this.decode(this.buffer, 0, this.buffer.length);
            if (this.bufsize <= 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int n2;
        int n3;
        int n4 = off;
        while (this.index < this.bufsize && len > 0) {
            buf[off++] = this.buffer[this.index++];
            --len;
        }
        if (this.index >= this.bufsize) {
            this.index = 0;
            this.bufsize = 0;
        }
        if ((n3 = len / 3 * 3) > 0) {
            n2 = this.decode(buf, off, n3);
            off += n2;
            len -= n2;
            if (n2 != n3) {
                if (off == n4) {
                    return -1;
                }
                return off - n4;
            }
        }
        while (len > 0 && (n2 = this.read()) != -1) {
            buf[off++] = (byte)n2;
            --len;
        }
        if (off == n4) {
            return -1;
        }
        return off - n4;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private int decode(byte[] outbuf, int pos, int len) throws IOException {
        int n2 = pos;
        while (len >= 3) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < 4) {
                int n5 = this.getByte();
                if (n5 == -1 || n5 == -2) {
                    boolean bl2;
                    if (n5 == -1) {
                        if (n3 == 0) {
                            return pos - n2;
                        }
                        if (!this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed 4 valid base64 characters but only got " + n3 + " before EOF" + this.recentChars());
                        }
                        bl2 = true;
                    } else {
                        if (n3 < 2 && !this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed at least 2 valid base64 characters, but only got " + n3 + " before padding character (=)" + this.recentChars());
                        }
                        if (n3 == 0) {
                            return pos - n2;
                        }
                        bl2 = false;
                    }
                    int n6 = n3 - 1;
                    if (n6 == 0) {
                        n6 = 1;
                    }
                    ++n3;
                    n4 <<= 6;
                    while (n3 < 4) {
                        if (!bl2) {
                            n5 = this.getByte();
                            if (n5 == -1) {
                                if (!this.ignoreErrors) {
                                    throw new IOException("Error in encoded stream: hit EOF while looking for padding characters (=)" + this.recentChars());
                                }
                            } else if (n5 != -2 && !this.ignoreErrors) {
                                throw new IOException("Error in encoded stream: found valid base64 character after a padding character (=)" + this.recentChars());
                            }
                        }
                        n4 <<= 6;
                        ++n3;
                    }
                    n4 >>= 8;
                    if (n6 == 2) {
                        outbuf[pos + 1] = (byte)(n4 & 0xFF);
                    }
                    outbuf[pos] = (byte)((n4 >>= 8) & 0xFF);
                    return (pos += n6) - n2;
                }
                n4 <<= 6;
                ++n3;
                n4 |= n5;
            }
            outbuf[pos + 2] = (byte)(n4 & 0xFF);
            outbuf[pos + 1] = (byte)((n4 >>= 8) & 0xFF);
            outbuf[pos] = (byte)((n4 >>= 8) & 0xFF);
            len -= 3;
            pos += 3;
        }
        return pos - n2;
    }

    private int getByte() throws IOException {
        int n2;
        do {
            if (this.input_pos >= this.input_len) {
                try {
                    this.input_len = this.in.read(this.input_buffer);
                }
                catch (EOFException eOFException) {
                    return -1;
                }
                if (this.input_len <= 0) {
                    return -1;
                }
                this.input_pos = 0;
            }
            if ((n2 = this.input_buffer[this.input_pos++] & 0xFF) != 61) continue;
            return -2;
        } while ((n2 = pem_convert_array[n2]) == -1);
        return n2;
    }

    private String recentChars() {
        int n2;
        Object object = "";
        int n3 = n2 = this.input_pos > 10 ? 10 : this.input_pos;
        if (n2 > 0) {
            object = (String)object + ", the " + n2 + " most recent characters were: \"";
            block5: for (int i2 = this.input_pos - n2; i2 < this.input_pos; ++i2) {
                char c2 = (char)(this.input_buffer[i2] & 0xFF);
                switch (c2) {
                    case '\r': {
                        object = (String)object + "\\r";
                        continue block5;
                    }
                    case '\n': {
                        object = (String)object + "\\n";
                        continue block5;
                    }
                    case '\t': {
                        object = (String)object + "\\t";
                        continue block5;
                    }
                    default: {
                        object = c2 >= ' ' && c2 < '\u007f' ? (String)object + c2 : (String)object + "\\" + c2;
                    }
                }
            }
            object = (String)object + "\"";
        }
        return object;
    }

    public static byte[] decode(byte[] inbuf) {
        int n2 = inbuf.length / 4 * 3;
        if (n2 == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 61) {
            --n2;
            if (inbuf[inbuf.length - 2] == 61) {
                --n2;
            }
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        for (n2 = inbuf.length; n2 > 0; n2 -= 4) {
            int n5 = 3;
            int n6 = pem_convert_array[inbuf[n3++] & 0xFF];
            n6 <<= 6;
            n6 |= pem_convert_array[inbuf[n3++] & 0xFF];
            n6 <<= 6;
            if (inbuf[n3] != 61) {
                n6 |= pem_convert_array[inbuf[n3++] & 0xFF];
            } else {
                --n5;
            }
            n6 <<= 6;
            if (inbuf[n3] != 61) {
                n6 |= pem_convert_array[inbuf[n3++] & 0xFF];
            } else {
                --n5;
            }
            if (n5 > 2) {
                byArray[n4 + 2] = (byte)(n6 & 0xFF);
            }
            n6 >>= 8;
            if (n5 > 1) {
                byArray[n4 + 1] = (byte)(n6 & 0xFF);
            }
            byArray[n4] = (byte)((n6 >>= 8) & 0xFF);
            n4 += n5;
        }
        return byArray;
    }

    static {
        int n2;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (n2 = 0; n2 < 255; ++n2) {
            BASE64DecoderStream.pem_convert_array[n2] = -1;
        }
        for (n2 = 0; n2 < pem_array.length; ++n2) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[n2]] = (byte)n2;
        }
    }
}

