/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagCardholderVerificationMethodResults;
import java.util.List;

public final class EmvHelper {
    public static PaymentDetailsCustomerVerificationDetailed getCustomerVerificationDetailedFromArqc(List<TlvObject> dataArqc) {
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagCardholderVerificationMethodResults.TAG_BYTES, dataArqc);
        if (primitiveTlv != null) {
            TagCardholderVerificationMethodResults tagCardholderVerificationMethodResults = TagCardholderVerificationMethodResults.wrap(primitiveTlv);
            return EmvHelper.getCustomerVerificationDetailedFromTag(tagCardholderVerificationMethodResults);
        }
        return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
    }

    public static PaymentDetailsCustomerVerificationDetailed getCustomerVerificationDetailedFromTag(TagCardholderVerificationMethodResults cvmTag) {
        byte by2 = (byte)(cvmTag.getValue()[0] & 0xFFFFFFBF);
        switch (by2) {
            case 0: 
            case 31: 
            case 63: {
                return PaymentDetailsCustomerVerificationDetailed.NONE;
            }
            case 30: {
                return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
            }
            case 3: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_PLAINTEXT_AND_SIGNATURE;
            }
            case 5: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED_AND_SIGNATURE;
            }
            case 1: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_PLAINTEXT;
            }
            case 4: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED;
            }
            case 2: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_ONLINE;
            }
        }
        return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
    }
}

