/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.shared.accessories.AbstractAccessory;
import io.mpos.shared.accessories.modules.listener.CardProcessingAbortTransactionListener;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.provider.ResourceHandler;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import java.util.Set;

public final class HardResetter {
    private static final String TAG = "HardResetter";

    public static void cancelConnectingToAccessories(Set<Accessory> connectingToAccessories) {
        Log.w(TAG, "Triggering method cancelConnectingToAccessories");
        for (Accessory accessory : connectingToAccessories) {
            if (!(accessory instanceof AbstractAccessory)) continue;
            HardResetter.safelyDisconnectAccessory((AbstractAccessory)accessory);
        }
    }

    public static void resetAndDisconnectAccessories(ResourceHandler resourceHandler, Set<Accessory> accessories) {
        Log.w(TAG, "Triggering method resetAndDisconnectAccessories");
        if (resourceHandler.isAnyTransactionOngoing()) {
            for (Accessory accessory : accessories) {
                DefaultTransaction defaultTransaction;
                if (!(accessory instanceof PaymentAccessory) || (defaultTransaction = (DefaultTransaction)resourceHandler.getTransactionRunningOnAccessory(accessory)) == null) continue;
                HardResetter.safelyAbortTransaction((PaymentAccessory)accessory, defaultTransaction);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                Log.w(TAG, "Exception while hard resetting: resetAndDisconnectAccessories - sleep thread", exception);
            }
        }
        for (Accessory accessory : accessories) {
            HardResetter.safelyDisconnectAccessory((AbstractAccessory)accessory);
        }
    }

    private static void safelyDisconnectAccessory(AbstractAccessory accessory) {
        try {
            accessory.disconnect(new SuccessFailureListener(){

                @Override
                public void onSuccess(Object extraInfo) {
                }

                @Override
                public void onFailure(MposError mposError) {
                }
            });
        }
        catch (Exception exception) {
            Log.w(TAG, "Exception while safely disconnecting terminal", exception);
        }
    }

    private static void safelyAbortTransaction(PaymentAccessory accessory, DefaultTransaction transaction) {
        try {
            accessory.getCardProcessingModule().abortTransaction(transaction, new CardProcessingAbortTransactionListener(){

                @Override
                public void success(PaymentAccessory accessory, BaseTransaction transaction) {
                }

                @Override
                public void failure(PaymentAccessory accessory, BaseTransaction transaction, MposError error) {
                }
            });
        }
        catch (Exception exception) {
            Log.w(TAG, "Exception while safely aborting transaction", exception);
        }
    }
}

