/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import bolts.Task;
import com.visa.utils.Base64;
import io.mpos.logger.Log;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Helper {
    private static final String TAG = "Helper";
    private static boolean ENFORCE_SYNCHRONOUS_EXECUTION_ON_SAME_THREAD = false;
    private static ExecutorService mExecutor = Executors.newFixedThreadPool(5);
    public static long MILLISECONDS_PER_MINUTE = 60000L;

    public static String createRandomUUID() {
        return UUID.randomUUID().toString();
    }

    public static <T> Future<T> runAsync(Callable<T> callable) {
        return Task.BACKGROUND_EXECUTOR.submit(callable);
    }

    public static String decodeBase64(String base64) {
        if (base64 == null) {
            return null;
        }
        byte[] byArray = Base64.decode((String)base64, (int)0);
        try {
            return new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "wtf utf-8 isn't supported???");
            return null;
        }
    }

    public static byte[] decodeBase64AsBytes(String base64) {
        if (base64 == null || base64.length() == 0) {
            return null;
        }
        return Base64.decode((String)base64, (int)0);
    }

    public static String encodeBase64(String msg) {
        if (msg == null) {
            return null;
        }
        try {
            return Base64.encodeToString((byte[])msg.getBytes("utf-8"), (int)0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "wtf utf-8 isn't supported???");
            return null;
        }
    }

    public static String encodeBase64(byte[] msg) {
        if (msg == null) {
            return null;
        }
        return Base64.encodeToString((byte[])msg, (int)0);
    }

    public static String fillStringWithCharacter(int length, String character) {
        if (length < 0 || character == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }

    public static String[] ensureStringArrayWithSize(String[] array, int size) {
        if (null == array) {
            array = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                array[i2] = "";
            }
            return array;
        }
        if (array.length > size) {
            throw new RuntimeException("The array size is greater than the required size.required:" + size + "given:" + array.length);
        }
        if (array.length == size) {
            return array;
        }
        String[] stringArray = new String[size];
        int n2 = array.length;
        for (int i3 = 0; i3 < size; ++i3) {
            stringArray[i3] = i3 < n2 ? array[i3] : "";
        }
        return stringArray;
    }

    public static void setEnforceSynchronousExecutionOnSameThread(boolean enforce) {
        ENFORCE_SYNCHRONOUS_EXECUTION_ON_SAME_THREAD = enforce;
    }

    public static <T> boolean isInEnum(T enumItem, T ... enums) {
        for (T t2 : enums) {
            if (enumItem != t2) continue;
            return true;
        }
        return false;
    }
}

