/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import java.util.Iterator;
import java.util.List;

public final class ParameterValidator {
    public static void checkNull(List<Object> parameters, List<String> names) {
        Iterator<Object> iterator = parameters.iterator();
        Iterator<String> iterator2 = names.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object object = iterator.next();
            String string = iterator2.next();
            if (object != null) continue;
            ParameterValidator.throwException(ErrorType.PARAMETER_MISSING, string + " is null");
        }
    }

    public static void checkEmpty(List<String> parameters, List<String> names) {
        Iterator<String> iterator = parameters.iterator();
        Iterator<String> iterator2 = names.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string = iterator.next();
            String string2 = iterator2.next();
            if (!string.isEmpty()) continue;
            ParameterValidator.throwException(ErrorType.PARAMETER_INVALID, string2 + " is empty");
        }
    }

    public static void checkNullOrEmpty(List<String> parameters, List<String> names) {
        ParameterValidator.checkNull(parameters, names);
        ParameterValidator.checkEmpty(parameters, names);
    }

    private static void throwException(ErrorType type, String text) {
        throw new MposRuntimeException((MposError)new DefaultMposError(type, text));
    }
}

