/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.accessories.Accessory;
import io.mpos.core.common.obfuscated.en;
import io.mpos.errors.MposError;
import io.mpos.featuretoggles.SdkFeatureToggle;
import io.mpos.platform.DeviceInformation;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.helper.TimeHelper;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactions.TransactionMode;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;

public class Profiler {
    private static final char STATUS_DETAILS_DELIMITER = '|';
    private TriggerSource triggerSource;
    private List<ProfilerItem> profileItems;
    private String referenceTimestamp;
    private String accessoryIdentifier;
    private String phoneInfo;
    private WeakReference<Accessory> accessory;
    private WeakReference<DefaultProvider> provider;
    private WeakReference<BaseTransaction> transaction;
    private TransactionMode mode = TransactionMode.ONLINE;
    private Status status = Status.OK;
    private String statusDetails;
    private static IntegrationType integrationType = IntegrationType.ANDROID_CUSTOM;
    private en memoryUsageUtil = en.INSTANCE;

    public Profiler() {
        this.profileItems = new CopyOnWriteArrayList<ProfilerItem>();
        this.triggerSource = TriggerSource.PROVIDER;
        this.resetFromTriggerSource(TriggerSource.PROVIDER);
        this.referenceTimestamp = Profiler.getCurrentUtcString();
    }

    public String getUsedMemory() {
        return this.memoryUsageUtil.a();
    }

    public String getFreeMemory() {
        return this.memoryUsageUtil.b();
    }

    public TriggerSource getTriggerSource() {
        return this.triggerSource;
    }

    public void setTriggerSource(TriggerSource triggerSource) {
        this.triggerSource = triggerSource;
    }

    public String getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public void beginMeasurement(Category category, String info) {
        String cfr_ignored_0 = "beginMeasurement: " + category + "; info: " + info;
        ProfilerItem profilerItem = new ProfilerItem(category, Action.BEGIN, Profiler.getCurrentUtcString(), info);
        this.addToProfilerItems(profilerItem);
    }

    public void event(Category category, String info) {
        String cfr_ignored_0 = "event: " + category + "; info: " + info;
        ProfilerItem profilerItem = new ProfilerItem(category, Action.EVENT, Profiler.getCurrentUtcString(), info);
        this.addToProfilerItems(profilerItem);
    }

    public void endMeasurement(Category category, String info) {
        String cfr_ignored_0 = "endMeasurement: " + category + "; info: " + info;
        ProfilerItem profilerItem = new ProfilerItem(category, Action.END, Profiler.getCurrentUtcString(), info);
        this.addToProfilerItems(profilerItem);
    }

    public void endMeasurementWithError(Category category, String error) {
        String cfr_ignored_0 = "endMeasurementWithError: " + category + "; error: " + error;
        ProfilerItem profilerItem = new ProfilerItem(category, Action.ERROR, Profiler.getCurrentUtcString());
        profilerItem.error = error;
        this.addToProfilerItems(profilerItem);
    }

    public void endMeasurementWithError(Category category, String error, String info) {
        String cfr_ignored_0 = "endMeasurementWithError: " + category + "; error: " + error + "; info: " + info;
        ProfilerItem profilerItem = new ProfilerItem(category, Action.ERROR, Profiler.getCurrentUtcString(), info);
        profilerItem.error = error;
        this.addToProfilerItems(profilerItem);
    }

    private void updateStatusDetails(String newError) {
        if (newError == null || newError.isEmpty()) {
            return;
        }
        int n2 = this.statusDetails == null ? 0 : this.statusDetails.length();
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(this.statusDetails);
            stringBuilder.append('|');
        }
        stringBuilder.append(newError);
        this.statusDetails = stringBuilder.toString();
        this.status = Status.ERROR;
    }

    private void addToProfilerItems(ProfilerItem profileItem) {
        this.checkAndDeleteAccessoryConnectErrorRepetition(profileItem);
        this.updateStatusDetails(profileItem.getError());
        this.profileItems.add(profileItem);
    }

    private void checkAndDeleteAccessoryConnectErrorRepetition(ProfilerItem profileItem) {
        if (profileItem.getCategory() == Category.ACCESSORY_CONNECT && profileItem.getAction() == Action.BEGIN) {
            int n2 = 0;
            int n3 = -1;
            int n4 = 4;
            for (int i2 = this.profileItems.size() - 1; i2 >= 0 && n4 >= 0; --i2) {
                --n4;
                ProfilerItem profilerItem = this.profileItems.get(i2);
                if (profilerItem.getCategory() != Category.ACCESSORY_CONNECT || profilerItem.getAction() != Action.BEGIN) continue;
                if (++n2 == 1) {
                    n3 = i2;
                    continue;
                }
                if (n2 != 2) continue;
                this.profileItems.subList(n3, this.profileItems.size()).clear();
            }
        }
    }

    public List<ProfilerItem> getProfileItems() {
        return this.profileItems;
    }

    public Accessory getAccessory() {
        if (this.accessory == null) {
            return null;
        }
        return (Accessory)this.accessory.get();
    }

    public void setAccessory(Accessory accessory) {
        this.accessory = new WeakReference<Accessory>(accessory);
    }

    public String getAccessoryIdentifier() {
        return this.accessoryIdentifier;
    }

    public void setAccessoryIdentifier(String accessoryIdentifier) {
        this.accessoryIdentifier = accessoryIdentifier;
    }

    public DefaultProvider getProvider() {
        if (this.provider == null) {
            return null;
        }
        return (DefaultProvider)this.provider.get();
    }

    public void setProvider(DefaultProvider provider) {
        this.provider = new WeakReference<DefaultProvider>(provider);
        this.setPhoneInfo(((DefaultProvider)this.provider.get()).getPlatformToolkit().getDeviceInformation());
    }

    public BaseTransaction getTransaction() {
        if (this.transaction == null) {
            return null;
        }
        return (BaseTransaction)this.transaction.get();
    }

    public void setTransaction(BaseTransaction transaction) {
        this.transaction = new WeakReference<BaseTransaction>(transaction);
    }

    public String getPhoneInfo() {
        return this.phoneInfo;
    }

    public void setPhoneInfo(String phoneInfo) {
        this.phoneInfo = phoneInfo;
    }

    private void setPhoneInfo(DeviceInformation deviceInformation) {
        this.phoneInfo = deviceInformation.getManufacturer() + " " + deviceInformation.getDeviceName();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status mStatus) {
        this.status = mStatus;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public void setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
    }

    static String getCurrentUtcString() {
        SimpleDateFormat simpleDateFormat = TimeHelper.createDateTimeFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date());
    }

    public List<String> getFeatureToggles() {
        DefaultProvider defaultProvider = (DefaultProvider)this.provider.get();
        if (defaultProvider == null) {
            return Collections.emptyList();
        }
        return defaultProvider.getFeatureToggleManager().features();
    }

    public IntegrationType getIntegrationType() {
        return integrationType;
    }

    public static void setIntegrationType(IntegrationType type) {
        integrationType = type;
    }

    public String createTransactionMessage(String message, BaseTransaction transaction) {
        DefaultProvider defaultProvider;
        if (transaction == null) {
            return String.format("%s, without transaction", message);
        }
        DefaultProvider defaultProvider2 = defaultProvider = this.provider != null ? (DefaultProvider)this.provider.get() : null;
        if (defaultProvider != null && defaultProvider.getFeatureToggleManager().isFeatureEnabled(SdkFeatureToggle.MOBILE_SDK_METRICS_DETAILED_MESSAGE)) {
            return String.format("%s with id: '%s', session id: '%s', status: '%s', status code: '%s'. More details: %s", message, transaction.getIdentifier(), transaction.getSessionIdentifier(), transaction.getStatus(), transaction.getStatusDetails().getCode(), transaction.toString());
        }
        return String.format("%s with id: '%s', session id: '%s', status: '%s', status code: '%s'", message, transaction.getIdentifier(), transaction.getSessionIdentifier(), transaction.getStatus(), transaction.getStatusDetails().getCode());
    }

    public String createTransactionMessage(String message, MposError error, BaseTransaction transaction) {
        return String.format("%s with error: '%s', id: '%s', session id: '%s', status: '%s', status code: '%s'", message, error != null ? error.toString() : "", transaction.getIdentifier(), transaction.getSessionIdentifier(), transaction.getStatus(), transaction.getStatusDetails().getCode());
    }

    public void resetFromTriggerSource(TriggerSource triggerSource) {
        this.resetFromTriggerSource(triggerSource, TransactionMode.ONLINE);
    }

    public void resetFromTriggerSource(TriggerSource triggerSource, TransactionMode mode) {
        if (this.triggerSource != triggerSource) {
            return;
        }
        this.mode = mode;
        this.profileItems.clear();
        this.transaction = null;
        this.accessory = null;
        this.accessoryIdentifier = null;
        this.status = Status.OK;
        this.statusDetails = null;
        this.referenceTimestamp = Profiler.getCurrentUtcString();
    }

    public void persistFromTriggerSource(TriggerSource triggerSource) {
        if (this.triggerSource != triggerSource) {
            return;
        }
        DefaultProvider defaultProvider = this.getProvider();
        if (defaultProvider == null) {
            return;
        }
        TransactionProcessor transactionProcessor = this.mode == TransactionMode.ONLINE ? defaultProvider.getTransactionProcessor() : defaultProvider.getOfflineTransactionProcessor();
        transactionProcessor.sendTransactionMetrics(new GenericOperationSuccessFailureListener<TransactionProcessor, Void>(){

            @Override
            public void onOperationFailure(TransactionProcessor operator, MposError error) {
            }

            @Override
            public void onOperationSuccess(TransactionProcessor operator, Void data) {
                Profiler.this.profileItems.clear();
            }
        });
    }

    public static enum Status {
        OK,
        ERROR;

    }

    public static enum TriggerSource {
        PROVIDER,
        TRANSACTION_PROVIDER;

    }

    public static enum Category {
        INTERNAL,
        PROVIDER,
        HTTP,
        ACCESSORY_CONNECT,
        ACCESSORY_DISCONNECT,
        ACCESSORY_UPDATE_CHECK,
        ACCESSORY_UPDATE,
        ACCESSORY_PROVISION,
        ACCESSORY_ERROR,
        TRANSACTION_LOOKUP,
        TRANSACTION_REGISTRATION,
        TRANSACTION_REFUND,
        TRANSACTION_CAPTURE,
        TRANSACTION_TIP_ADJUST,
        TRANSACTION_INCREMENTAL_AUTHORIZATION,
        SYNCHRONIZE_CONFIGURATION,
        TRANSACTION_PROCESSING,
        TRANSACTION_PROCESSING_UPDATE_CHECK,
        TRANSACTION_PROCESSING_DETECTING_CARD,
        TRANSACTION_PROCESSING_PAYMENT_WORKFLOW,
        TRANSACTION_PROCESSING_ON_DEVICE,
        TRANSACTION_PROCESSING_ACTION_REQUIRED,
        TRANSACTION_PROCESSING_EXECUTE,
        TRANSACTION_PROCESSING_FINALIZE,
        TRANSACTION_PROCESSING_ABORT,
        TRANSACTION_PROCESSING_ABORT_HEADLESS,
        TRANSACTION_PROCESSING_VOID,
        TRANSACTION_PROCESSING_ERROR,
        TRANSACTION_PROCESSING_EXECUTE_RECOVERY,
        TRANSACTION_PROCESSING_VOID_RECOVERY,
        TRANSACTION_PROCESSING_FINALIZE_RECOVERY,
        TRANSACTION_PROVIDER_TRANSACTION_PROCESS,
        TRANSACTION_PROVIDER_PRINT_RECEIPT_CUSTOMER,
        TRANSACTION_PROVIDER_PRINT_RECEIPT_MERCHANT,
        TRANSACTION_PROVIDER_PRINT_RECEIPT_CUSTOM,
        TRANSACTION_PROVIDER_CARD_PROCESS,
        TRANSACTION_PROVIDER_SUBMIT_TRANSACTIONS_PROCESS,
        TRANSACTION_PROVIDER_SYNCHRONIZE_CONFIGURATION_PROCESS,
        PRINTING_EVENT,
        TIPPING,
        RECEIPT_QUERY,
        TRANSACTION_QUERY,
        DCC_LOOKUP,
        IMAGE_COMPRESSION;

    }

    public static class ProfilerItem {
        Category category;
        Action action;
        String timepoint;
        String info;
        String error;

        public ProfilerItem(Category category, Action action, String timepoint) {
            this.category = category;
            this.action = action;
            this.timepoint = timepoint;
        }

        public ProfilerItem(Category category, Action action, String timepoint, String info) {
            this.category = category;
            this.action = action;
            this.timepoint = timepoint;
            this.info = info;
        }

        public Category getCategory() {
            return this.category;
        }

        public Action getAction() {
            return this.action;
        }

        public String getTimepoint() {
            return this.timepoint;
        }

        public String getInfo() {
            return this.info;
        }

        public String getError() {
            return this.error;
        }

        public String toString() {
            return "ProfilerData{category=" + this.category + ", action=" + this.action + ", timepoint=" + this.timepoint + ", info='" + this.info + "', error='" + this.error + "'}";
        }
    }

    public static enum Action {
        BEGIN,
        EVENT,
        END,
        ERROR;

    }

    public static enum IntegrationType {
        ANDROID_PAYBUTTON,
        ANDROID_PAYBUTTON2,
        ANDROID_CUSTOM,
        PAYSERVER;

    }
}

