/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.hexstring;

import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringTransformExtensionsKt;
import io.mpos.shared.hexstring.PaddingStyle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.contracts.ExperimentalContracts;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0001\u001a\u001f\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\tH\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0000\u001a$\u0010\u000f\u001a\u00020\t*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a$\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a\u001c\u0010\u001a\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0014\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"TAG", "", "HEX_CHARS", "HEX_CHARS_SET", "", "", "getHEX_CHARS_SET", "()Ljava/util/Set;", "hex", "Lio/mpos/shared/hexstring/HexString;", "string", "bytes", "", "isNullOrEmpty", "", "fitIn", "range", "Lkotlin/ranges/IntRange;", "padding", "", "style", "Lio/mpos/shared/hexstring/PaddingStyle;", "pad", "newLength", "", "byte", "cutPadding", "mpos.core"})
public final class HexStringKt {
    @NotNull
    private static final String TAG = "HexString";
    @NotNull
    public static final String HEX_CHARS = "0123456789ABCDEF";
    @NotNull
    private static final Set<Character> HEX_CHARS_SET = StringsKt.toSet((CharSequence)"0123456789ABCDEF");

    @NotNull
    public static final Set<Character> getHEX_CHARS_SET() {
        return HEX_CHARS_SET;
    }

    @NotNull
    public static final HexString hex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        HexString hexString = HexString.Companion.create(string);
        if (hexString == null) {
            throw new IllegalArgumentException("Unable to create HexString from: '" + string + "'");
        }
        return hexString;
    }

    @NotNull
    public static final byte[] bytes(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return HexStringTransformExtensionsKt.toBytes(HexStringKt.hex(string));
    }

    @ExperimentalContracts
    public static final boolean isNullOrEmpty(@Nullable HexString $this$isNullOrEmpty) {
        return $this$isNullOrEmpty == null || $this$isNullOrEmpty.isEmpty();
    }

    @NotNull
    public static final HexString fitIn(@NotNull HexString $this$fitIn, @NotNull IntRange range, byte padding, @NotNull PaddingStyle style) {
        Intrinsics.checkNotNullParameter((Object)$this$fitIn, (String)"");
        Intrinsics.checkNotNullParameter((Object)range, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"");
        return Intrinsics.areEqual((Object)range, (Object)IntRange.Companion.getEMPTY()) ? $this$fitIn : (range.contains($this$fitIn.getLength()) ? $this$fitIn : ($this$fitIn.getLength() > range.getLast() ? HexStringKt.cutPadding($this$fitIn, range.getLast(), style) : HexStringKt.pad($this$fitIn, range.getFirst(), padding, style)));
    }

    public static /* synthetic */ HexString fitIn$default(HexString hexString, IntRange intRange, byte by2, PaddingStyle paddingStyle, int n2, Object object) {
        if ((n2 & 4) != 0) {
            paddingStyle = PaddingStyle.Front;
        }
        return HexStringKt.fitIn(hexString, intRange, by2, paddingStyle);
    }

    @NotNull
    public static final HexString pad(@NotNull HexString $this$pad, int newLength, byte by2, @NotNull PaddingStyle style) {
        Intrinsics.checkNotNullParameter((Object)$this$pad, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"");
        int n2 = 0;
        int n3 = newLength - $this$pad.getLength();
        byte[] byArray = new byte[n3];
        while (n2 < n3) {
            int n4 = n2++;
            byArray[n4] = by2;
        }
        HexString hexString = ByteArrayTransformExtensionsKt.toHexString(byArray);
        return switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
            case 1 -> hexString.plus($this$pad);
            case 2 -> $this$pad.plus(hexString);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ HexString pad$default(HexString hexString, int n2, byte by2, PaddingStyle paddingStyle, int n3, Object object) {
        if ((n3 & 4) != 0) {
            paddingStyle = PaddingStyle.Front;
        }
        return HexStringKt.pad(hexString, n2, by2, paddingStyle);
    }

    @NotNull
    public static final HexString cutPadding(@NotNull HexString $this$cutPadding, int newLength, @NotNull PaddingStyle style) {
        Intrinsics.checkNotNullParameter((Object)$this$cutPadding, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"");
        return switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
            case 1 -> (HexString)$this$cutPadding.splitFromEnd(newLength).getSecond();
            case 2 -> $this$cutPadding.substringUpTo(newLength);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ HexString cutPadding$default(HexString hexString, int n2, PaddingStyle paddingStyle, int n3, Object object) {
        if ((n3 & 2) != 0) {
            paddingStyle = PaddingStyle.Front;
        }
        return HexStringKt.cutPadding(hexString, n2, paddingStyle);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaddingStyle.values().length];
            try {
                nArray[PaddingStyle.Front.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PaddingStyle.Back.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

