/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.localization;

import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionTypeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionWorkflowTypeSerializer;
import io.mpos.shared.provider.AbstractProvider;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionWorkflowType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class LocalizationPromptParameters {
    private final String mainPrompt;
    private final TransactionType transactionType;
    private final TransactionWorkflowType workflowType;
    private final int lineWidth;
    private final String[] arguments;
    private final Locale locale;

    private LocalizationPromptParameters(String mainPrompt, TransactionType transactionType, TransactionWorkflowType workflowType, int lineWidth, String[] arguments, Locale locale) {
        this.mainPrompt = mainPrompt;
        this.transactionType = transactionType;
        this.workflowType = workflowType;
        this.lineWidth = lineWidth;
        this.arguments = arguments;
        this.locale = locale;
    }

    public static List<String> getPrioritizedFullPrompts(String mainPrompt, TransactionType transactionType, TransactionWorkflowType workflowType) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (mainPrompt == null || mainPrompt.isEmpty()) {
            return linkedList;
        }
        if (transactionType != null) {
            if (workflowType != null) {
                linkedList.add(String.format("%s.%s#%s", mainPrompt, TransactionTypeSerializer.getInstance().serialize(transactionType), TransactionWorkflowTypeSerializer.getInstance().serialize(workflowType)));
            }
            linkedList.add(String.format("%s.%s", mainPrompt, TransactionTypeSerializer.getInstance().serialize(transactionType)));
        }
        if (workflowType != null) {
            linkedList.add(String.format("%s#%s", mainPrompt, TransactionWorkflowTypeSerializer.getInstance().serialize(workflowType)));
        }
        linkedList.add(mainPrompt);
        return linkedList;
    }

    public static Builder create(LocalizationPrompt localizationPrompt) {
        String string = localizationPrompt != null ? localizationPrompt.getKey() : null;
        return new Builder(string);
    }

    public static Builder create(String mainPrompt) {
        return new Builder(mainPrompt);
    }

    public static Builder createFromTransaction(DefaultTransaction transaction, LocalizationPrompt localizationPrompt) {
        String string = localizationPrompt != null ? localizationPrompt.getKey() : null;
        Builder builder = new Builder(string);
        builder.lineWidth = transaction.getAccessory().getDisplayModule().getLineWidth();
        builder.locale = transaction.getAccessory().getLocale();
        return builder;
    }

    public String toString() {
        return "LocalizationPromptParameters{mainPrompt='" + this.mainPrompt + "', transactionType='" + this.transactionType + "', workflowType='" + this.workflowType + "', lineWidth=" + this.lineWidth + ", arguments=" + Arrays.toString(this.arguments) + ", locale=" + this.locale + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LocalizationPromptParameters localizationPromptParameters = (LocalizationPromptParameters)o2;
        if (this.lineWidth != localizationPromptParameters.lineWidth) {
            return false;
        }
        if (this.mainPrompt != null ? !this.mainPrompt.equals(localizationPromptParameters.mainPrompt) : localizationPromptParameters.mainPrompt != null) {
            return false;
        }
        if (this.transactionType != null ? !this.transactionType.equals((Object)localizationPromptParameters.transactionType) : localizationPromptParameters.transactionType != null) {
            return false;
        }
        if (this.workflowType != null ? !this.workflowType.equals((Object)localizationPromptParameters.workflowType) : localizationPromptParameters.workflowType != null) {
            return false;
        }
        if (!Arrays.equals(this.arguments, localizationPromptParameters.arguments)) {
            return false;
        }
        return this.locale != null ? this.locale.equals(localizationPromptParameters.locale) : localizationPromptParameters.locale == null;
    }

    public int hashCode() {
        int n2 = this.mainPrompt != null ? this.mainPrompt.hashCode() : 0;
        n2 = 31 * n2 + (this.transactionType != null ? this.transactionType.hashCode() : 0);
        n2 = 31 * n2 + (this.workflowType != null ? this.workflowType.hashCode() : 0);
        n2 = 31 * n2 + this.lineWidth;
        n2 = 31 * n2 + Arrays.hashCode(this.arguments);
        n2 = 31 * n2 + (this.locale != null ? this.locale.hashCode() : 0);
        return n2;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMainPrompt() {
        return this.mainPrompt;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public TransactionWorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public static class Builder {
        private String mainPrompt;
        private TransactionType transactionType;
        private TransactionWorkflowType workflowType;
        private int lineWidth = 40;
        private String[] arguments;
        private Locale locale = AbstractProvider.sLocale;

        private Builder() {
        }

        public Builder(String mainPrompt) {
            this();
            this.mainPrompt = mainPrompt;
        }

        public Builder(LocalizationPrompt localizationPrompt) {
            this();
            this.mainPrompt = localizationPrompt != null ? localizationPrompt.getKey() : null;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder arguments(String ... arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder lineWidth(int lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public Builder subPromptFromTransactionTypeAndWorkflowType(TransactionType transactionType, TransactionWorkflowType workflowType) {
            this.transactionType = transactionType;
            this.workflowType = workflowType;
            return this;
        }

        public Builder initFromPaymentAccessory(PaymentAccessory accessory) {
            this.locale = accessory.getLocale();
            this.lineWidth = accessory.getDisplayModule().getLineWidth();
            return this;
        }

        public LocalizationPromptParameters build() {
            return new LocalizationPromptParameters(this.mainPrompt, this.transactionType, this.workflowType, this.lineWidth, this.arguments, this.locale);
        }
    }
}

