/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.network.services;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import io.mpos.core.common.obfuscated.aX;
import io.mpos.core.common.obfuscated.aY;
import io.mpos.core.common.obfuscated.aZ;
import io.mpos.core.common.obfuscated.bd;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.platform.DeviceInformation;
import io.mpos.provider.ProviderOptions;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.network.dto.ForceVoidPayloadDTO;
import io.mpos.shared.network.services.ForceVoidTransactionService;
import io.mpos.shared.network.services.ForceVoidTransactionSuccessFailureListener;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionInBodyServicesResponseDTO;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.util.TransactionConverterKt;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\r\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/mpos/shared/network/services/ForceVoidTransactionService;", "", "providerOptions", "Lio/mpos/provider/ProviderOptions;", "deviceInformation", "Lio/mpos/platform/DeviceInformation;", "httpServiceWrapper", "Lio/mpos/internal/processors/payworks/services/IHTTPServiceWrapper;", "<init>", "(Lio/mpos/provider/ProviderOptions;Lio/mpos/platform/DeviceInformation;Lio/mpos/internal/processors/payworks/services/IHTTPServiceWrapper;)V", "dtoConversionHelper", "Lio/mpos/shared/processors/payworks/services/response/DTOConversionHelper;", "internalService", "io/mpos/shared/network/services/ForceVoidTransactionService$internalService$1", "Lio/mpos/shared/network/services/ForceVoidTransactionService$internalService$1;", "start", "", "transactionId", "", "status", "Lio/mpos/transactions/TransactionStatusDetailsCodes;", "listener", "Lio/mpos/shared/network/services/ForceVoidTransactionSuccessFailureListener;", "isTransactionStatusValid", "", "Companion", "mpos.core"})
public final class ForceVoidTransactionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DTOConversionHelper dtoConversionHelper;
    @NotNull
    private final internalService.1 internalService;
    @NotNull
    private static final String ENDPOINT_TEMPLATE = "transactions/%s/void";
    @NotNull
    private static final List<TransactionStatusDetailsCodes> validStatusCodes;

    @AssistedInject
    public ForceVoidTransactionService(@Assisted @NotNull ProviderOptions providerOptions, @NotNull DeviceInformation deviceInformation, @NotNull bd httpServiceWrapper) {
        Intrinsics.checkNotNullParameter((Object)providerOptions, (String)"");
        Intrinsics.checkNotNullParameter((Object)deviceInformation, (String)"");
        Intrinsics.checkNotNullParameter((Object)httpServiceWrapper, (String)"");
        this.dtoConversionHelper = new DTOConversionHelper();
        this.internalService = new aX(deviceInformation, providerOptions, httpServiceWrapper){

            public final <T, Q> void postRequest(Q payload, Class<T> response) {
                Intrinsics.checkNotNullParameter(response, (String)"");
                this.postJson(this.createServiceUrl(), payload, response);
            }

            public final <T> void setHttpServiceListener(aZ<T> listener) {
                Intrinsics.checkNotNullParameter(listener, (String)"");
                this.httpServiceListener = listener;
            }
        };
    }

    public final void start(@NotNull String transactionId, @NotNull TransactionStatusDetailsCodes status, @NotNull ForceVoidTransactionSuccessFailureListener listener) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"");
        Intrinsics.checkNotNullParameter((Object)status, (String)"");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"");
        if (!this.isTransactionStatusValid(status)) {
            listener.onFailure(new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "Transaction has an invalid status for void! Expected any of " + validStatusCodes + " but got " + status));
            return;
        }
        aZ<BackendTransactionInBodyServicesResponseDTO> aZ2 = new aZ<BackendTransactionInBodyServicesResponseDTO>(this, listener){
            final /* synthetic */ ForceVoidTransactionService this$0;
            final /* synthetic */ ForceVoidTransactionSuccessFailureListener $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void onHTTPServiceSuccess(aY service, BackendTransactionInBodyServicesResponseDTO response) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"");
                Intrinsics.checkNotNullParameter((Object)response, (String)"");
                BaseTransaction baseTransaction = ForceVoidTransactionService.access$getDtoConversionHelper$p(this.this$0).createTransactionFromBackendTransactionDTO(response.getData());
                Intrinsics.checkNotNull((Object)baseTransaction);
                this.$listener.onSuccess(TransactionConverterKt.toTransaction(baseTransaction));
            }

            public void onHTTPServiceFailure(aY service, MposError error) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"");
                Intrinsics.checkNotNullParameter((Object)error, (String)"");
                this.$listener.onFailure(error);
            }
        };
        this.internalService.setHttpServiceListener(aZ2);
        String string = ENDPOINT_TEMPLATE;
        Object[] objectArray = new Object[]{transactionId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        this.internalService.setEndPoint(string3);
        ForceVoidPayloadDTO forceVoidPayloadDTO = new ForceVoidPayloadDTO(status);
        this.internalService.postRequest(forceVoidPayloadDTO, BackendTransactionInBodyServicesResponseDTO.class);
    }

    private final boolean isTransactionStatusValid(TransactionStatusDetailsCodes status) {
        return validStatusCodes.contains(status);
    }

    public static final /* synthetic */ DTOConversionHelper access$getDtoConversionHelper$p(ForceVoidTransactionService $this) {
        return $this.dtoConversionHelper;
    }

    static {
        Object[] objectArray = new TransactionStatusDetailsCodes[]{TransactionStatusDetailsCodes.ERROR_AUTOREVERSAL_LOGOUT, TransactionStatusDetailsCodes.ERROR_AUTOREVERSAL_INCONCLUSIVE, TransactionStatusDetailsCodes.ERROR_AUTOREVERSAL_ERROR, TransactionStatusDetailsCodes.ABORTED_MERCHANT_MANUALLY_REVERTED};
        validStatusCodes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/mpos/shared/network/services/ForceVoidTransactionService$Companion;", "", "<init>", "()V", "ENDPOINT_TEMPLATE", "", "validStatusCodes", "", "Lio/mpos/transactions/TransactionStatusDetailsCodes;", "mpos.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

