/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.offline;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.offline.dto.LocalConfigurationDto;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendConfigurationMerchantDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSchemeSerializer;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.provider.configuration.MerchantDetails;
import io.mpos.shared.provider.configuration.OfflineConfiguration;
import io.mpos.transactions.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationDtoToConfigurationConverter {
    private final DTOConversionHelper dtoConversionHelper;

    public ConfigurationDtoToConfigurationConverter(DTOConversionHelper dtoConversionHelper) {
        this.dtoConversionHelper = dtoConversionHelper;
    }

    public Configuration createConfiguration(LocalConfigurationDto dto) {
        OfflineConfiguration offlineConfiguration = new OfflineConfiguration();
        offlineConfiguration.setWhitelistAccessories(this.dtoConversionHelper.createWhitelistAccessoriesFromBackendWhitelistReadersDTO(dto.getWhitelistReaders()));
        offlineConfiguration.setProcessingOptionsContainer(this.dtoConversionHelper.createProcessingOptionsFromProcessingOptionsDTO(dto.getProcessingOptions()));
        offlineConfiguration.setMerchantDetails(this.createMerchantDetailsFromDto(dto.getMerchantDetails()));
        return offlineConfiguration;
    }

    public MerchantDetails createMerchantDetailsFromDto(BackendConfigurationMerchantDetailsDTO dto) {
        if (dto == null) {
            return null;
        }
        MerchantDetails merchantDetails = new MerchantDetails();
        merchantDetails.setPublicName(dto.getPublicName());
        merchantDetails.setAddress(dto.getAddress());
        merchantDetails.setZip(dto.getZip());
        merchantDetails.setCity(dto.getCity());
        merchantDetails.setCountry(dto.getCountry());
        merchantDetails.setContact(dto.getContact());
        merchantDetails.setAdditionalInformation(dto.getAdditionalInformation());
        merchantDetails.setAcquirerIdentifiers(this.createAcquirerIdentifiers(dto.getAcquirerIds()));
        merchantDetails.setAcceptedCurrencies(this.createAcceptedCurrencies(dto.getAcceptedCurrencies()));
        return merchantDetails;
    }

    private Map<PaymentDetailsScheme, String> createAcquirerIdentifiers(Map<String, String> merchantAcquirerIdentifiers) {
        if (merchantAcquirerIdentifiers == null) {
            return null;
        }
        HashMap<PaymentDetailsScheme, String> hashMap = new HashMap<PaymentDetailsScheme, String>();
        for (Map.Entry<String, String> entry : merchantAcquirerIdentifiers.entrySet()) {
            PaymentDetailsScheme paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(entry.getKey());
            String string = entry.getValue();
            if (paymentDetailsScheme == null) continue;
            hashMap.put(paymentDetailsScheme, string);
        }
        return hashMap;
    }

    private Map<PaymentDetailsScheme, Set<Currency>> createAcceptedCurrencies(Map<String, Set<String>> acceptedCurrenciesDto) {
        if (Objects.isNull(acceptedCurrenciesDto)) {
            return null;
        }
        return acceptedCurrenciesDto.entrySet().stream().map(entry -> {
            PaymentDetailsScheme paymentDetailsScheme = ConfigurationDtoToConfigurationConverter.parseEnum(PaymentDetailsScheme.class, (String)entry.getKey());
            if (Objects.isNull(paymentDetailsScheme)) {
                return null;
            }
            Set set = ((Set)entry.getValue()).stream().map(code -> ConfigurationDtoToConfigurationConverter.parseEnum(Currency.class, code)).filter(Objects::nonNull).collect(Collectors.toSet());
            return set.isEmpty() ? null : Map.entry(paymentDetailsScheme, set);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <E extends Enum<E>> E parseEnum(Class<E> enumClass, String value) {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return null;
        }
    }
}

