/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.offline;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.offline.dto.LocalConfigurationDto;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendConfigurationMerchantDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendAccessoryFileDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendProcessingOptionsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendWhitelistReaderDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendWhitelistReaderDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendWhitelistReaderRequiredEntitiesDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.AccessoryTypeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSourceSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.ProcessingOptionsSerializers;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.WhitelistAccessorySerializers;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProcessingOptionsContainer;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.WhitelistAccessoryRequirement;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.provider.configuration.MerchantDetails;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.transactions.Currency;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationToConfigurationDtoConverter {
    private final DTOConversionHelper dtoConversionHelper;

    public ConfigurationToConfigurationDtoConverter(DTOConversionHelper dtoConversionHelper) {
        this.dtoConversionHelper = dtoConversionHelper;
    }

    public LocalConfigurationDto createConfigurationDto(Configuration configuration) {
        Optional<BackendConfigurationMerchantDetailsDTO> optional = Optional.of(configuration.getMerchantDetails()).map(this::createMerchantDetailsDto);
        Optional<BackendProcessingOptionsDTO> optional2 = Optional.of(configuration.getProcessingOptionsContainer()).map(this::createProcessingOptionsDto);
        List<BackendWhitelistReaderDTO> list = Optional.of(configuration.getWhitelistAccessories()).orElse(Collections.emptySet()).stream().map(this::createWhitelistReaderDto).collect(Collectors.toList());
        return new LocalConfigurationDto(optional.orElse(null), optional2.orElse(null), list.isEmpty() ? null : list);
    }

    private BackendProcessingOptionsDTO createProcessingOptionsDto(ProcessingOptionsContainer processingOptionsContainer) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList;
        Cloneable cloneable;
        Map<PaymentDetailsScheme, Map<PaymentDetailsSource, ProcessingOptions>> map;
        BackendProcessingOptionsDTO backendProcessingOptionsDTO = new BackendProcessingOptionsDTO();
        Map<PaymentDetailsSource, ProcessingOptions> map2 = processingOptionsContainer.getSourceSpecificOptions();
        if (map2 != null) {
            backendProcessingOptionsDTO.setDefaults(this.createBackendProcessingOptionsMapDto(map2));
        }
        if ((map = processingOptionsContainer.getSourceAndSchemeSpecificOptions()) != null) {
            cloneable = new HashMap();
            arrayList = map.entrySet().iterator();
            while (arrayList.hasNext()) {
                object3 = (Map.Entry)arrayList.next();
                object2 = this.dtoConversionHelper.createPaymentDetailsSchemeString((PaymentDetailsScheme)object3.getKey());
                if (object2 == null) continue;
                object = this.createBackendProcessingOptionsMapDto((Map)object3.getValue());
                cloneable.put(object2, object);
            }
            backendProcessingOptionsDTO.setSchemes((Map)((Object)cloneable));
        }
        if ((cloneable = processingOptionsContainer.getFeatures()) != null) {
            arrayList = new ArrayList<String>();
            object3 = ((AbstractCollection)((Object)cloneable)).iterator();
            while (object3.hasNext()) {
                object2 = (ProcessingOptions.Feature)((Object)object3.next());
                object = ProcessingOptionsSerializers.getFeatureSerializer().serialize(object2);
                if (object2 == null) continue;
                arrayList.add((String)object);
            }
            backendProcessingOptionsDTO.setFeatures(arrayList);
        }
        if ((arrayList = processingOptionsContainer.getAccessoryBehaviors()) != null) {
            object3 = new ArrayList();
            backendProcessingOptionsDTO.setBehavior((List)object3);
        }
        return backendProcessingOptionsDTO;
    }

    private Map<String, BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO> createBackendProcessingOptionsMapDto(Map<PaymentDetailsSource, ProcessingOptions> options) {
        HashMap<String, BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO> hashMap = new HashMap<String, BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO>();
        for (Map.Entry<PaymentDetailsSource, ProcessingOptions> entry : options.entrySet()) {
            String string = PaymentDetailsSourceSerializer.getInstance().serialize(entry.getKey());
            if (string == null) continue;
            BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO backendProcessingOptionsSchemeDTO = this.createBackendProcessingOptionsSchemeDto(entry.getValue());
            hashMap.put(string, backendProcessingOptionsSchemeDTO);
        }
        return hashMap;
    }

    private BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO createBackendProcessingOptionsSchemeDto(ProcessingOptions processingOptions) {
        BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO backendProcessingOptionsSchemeDTO = new BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO();
        backendProcessingOptionsSchemeDTO.setStatus(ProcessingOptionsSerializers.getStatusSerializer().serialize(processingOptions.getStatus()));
        backendProcessingOptionsSchemeDTO.setCvm(ProcessingOptionsSerializers.getCVMSerializer().serialize(processingOptions.getCvm()));
        backendProcessingOptionsSchemeDTO.setNoCvmLimit(processingOptions.getNoCvmLimit());
        backendProcessingOptionsSchemeDTO.setCoBrandingSupported(Boolean.valueOf(processingOptions.isCoBrandingSupported()));
        BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeFallbackDTO backendProcessingOptionsSchemeFallbackDTO = new BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeFallbackDTO();
        backendProcessingOptionsSchemeFallbackDTO.setStatus(ProcessingOptionsSerializers.getStatusSerializer().serialize(processingOptions.getFallbackStatus()));
        backendProcessingOptionsSchemeFallbackDTO.setRequiredRetries(processingOptions.getFallbackRequiredRetries());
        backendProcessingOptionsSchemeDTO.setFallback(backendProcessingOptionsSchemeFallbackDTO);
        return backendProcessingOptionsSchemeDTO;
    }

    private BackendWhitelistReaderDTO createWhitelistReaderDto(WhitelistAccessory accessory) {
        BackendWhitelistReaderDTO backendWhitelistReaderDTO = new BackendWhitelistReaderDTO();
        backendWhitelistReaderDTO.setIdentifier(accessory.getIdentifier());
        backendWhitelistReaderDTO.setModel(AccessoryTypeSerializer.getInstance().serialize(accessory.getType()));
        backendWhitelistReaderDTO.setStatus(accessory.getStatus());
        BackendWhitelistReaderDetailsDTO backendWhitelistReaderDetailsDTO = new BackendWhitelistReaderDetailsDTO();
        backendWhitelistReaderDetailsDTO.setSerialNo(accessory.getSerialNumber());
        if (accessory.getTransactionCounter() != null) {
            backendWhitelistReaderDetailsDTO.setTransactionCounter(accessory.getTransactionCounter().toString());
        }
        if (accessory.getRequiredSoftware() != null && accessory.getSoftwareVersion() != null) {
            backendWhitelistReaderDetailsDTO.setRequiredSoftware(this.createWhitelistReaderRequirementEntitiesDto(accessory.getSoftwareVersion(), accessory.getRequiredSoftware()));
        }
        if (accessory.getRequiredFirmware() != null && accessory.getFirmwareVersion() != null) {
            backendWhitelistReaderDetailsDTO.setRequiredFirmware(this.createWhitelistReaderRequirementEntitiesDto(accessory.getFirmwareVersion(), accessory.getRequiredFirmware()));
        }
        if (accessory.getRequiredConfiguration() != null && accessory.getConfigurationVersion() != null) {
            backendWhitelistReaderDetailsDTO.setRequiredConfiguration(this.createWhitelistReaderRequirementEntitiesDto(accessory.getConfigurationVersion(), accessory.getRequiredConfiguration()));
        }
        if (accessory.getEncryptionStatus() != null) {
            backendWhitelistReaderDetailsDTO.setEncryptionStatus(WhitelistAccessorySerializers.getEncryptionStatusSerializer().serialize(accessory.getEncryptionStatus()));
        }
        if (accessory.getRequiredEncryption() != null) {
            backendWhitelistReaderDetailsDTO.setRequiredEncryption(this.createRequiredEncryptions(accessory.getRequiredEncryption()));
        }
        if (accessory.getTerminalIds() != null) {
            backendWhitelistReaderDetailsDTO.setTerminalIds(this.createTerminalIds(accessory.getTerminalIds()));
        }
        backendWhitelistReaderDTO.setDetails(backendWhitelistReaderDetailsDTO);
        return backendWhitelistReaderDTO;
    }

    private Map<String, String> createTerminalIds(Map<PaymentDetailsScheme, String> terminalIds) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<PaymentDetailsScheme, String> entry : terminalIds.entrySet()) {
            String string = this.dtoConversionHelper.createPaymentDetailsSchemeString(entry.getKey());
            String string2 = entry.getValue();
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private List<String> createRequiredEncryptions(EnumSet<WhitelistAccessory.RequiredEncryption> requiredEncryptions) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WhitelistAccessory.RequiredEncryption requiredEncryption : requiredEncryptions) {
            arrayList.add(requiredEncryption.name());
        }
        return arrayList;
    }

    private BackendWhitelistReaderRequiredEntitiesDTO createWhitelistReaderRequirementEntitiesDto(String version, List<WhitelistAccessoryRequirement> requirements) {
        BackendWhitelistReaderRequiredEntitiesDTO backendWhitelistReaderRequiredEntitiesDTO = new BackendWhitelistReaderRequiredEntitiesDTO();
        backendWhitelistReaderRequiredEntitiesDTO.setVersion(version);
        HashMap<String, BackendAccessoryFileDTO> hashMap = new HashMap<String, BackendAccessoryFileDTO>();
        for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : requirements) {
            String string;
            byte[] byArray;
            String string2 = whitelistAccessoryRequirement.getName();
            BackendAccessoryFileDTO backendAccessoryFileDTO = new BackendAccessoryFileDTO();
            backendAccessoryFileDTO.setVersion(whitelistAccessoryRequirement.getVersion());
            if (whitelistAccessoryRequirement.getMd5() != null) {
                byArray = ByteHelper.fromHexString(whitelistAccessoryRequirement.getMd5());
                string = Helper.encodeBase64(byArray);
                backendAccessoryFileDTO.setMd5(string);
            }
            if (whitelistAccessoryRequirement.getSha256() != null) {
                byArray = ByteHelper.fromHexString(whitelistAccessoryRequirement.getSha256());
                string = Helper.encodeBase64(byArray);
                backendAccessoryFileDTO.setSha256(string);
            }
            if (whitelistAccessoryRequirement.getData() != null) {
                backendAccessoryFileDTO.setData(whitelistAccessoryRequirement.getData());
            }
            if (whitelistAccessoryRequirement.getSignature() != null) {
                backendAccessoryFileDTO.setSignature(Helper.encodeBase64(whitelistAccessoryRequirement.getSignature()));
            }
            hashMap.put(string2, backendAccessoryFileDTO);
        }
        backendWhitelistReaderRequiredEntitiesDTO.setFiles(hashMap);
        return backendWhitelistReaderRequiredEntitiesDTO;
    }

    private BackendConfigurationMerchantDetailsDTO createMerchantDetailsDto(MerchantDetails merchantDetails) {
        if (merchantDetails == null) {
            return null;
        }
        return new BackendConfigurationMerchantDetailsDTO(merchantDetails.getPublicName(), merchantDetails.getAddress(), merchantDetails.getZip(), merchantDetails.getCity(), merchantDetails.getCountry(), merchantDetails.getContact(), merchantDetails.getAdditionalInformation(), this.createMerchantAcquirerIds(merchantDetails.getAcquirerIdentifiers()), this.createAcceptedCurrenciesDto(merchantDetails.getAcceptedCurrencies()));
    }

    private Map<String, String> createMerchantAcquirerIds(Map<PaymentDetailsScheme, String> merchantAcquirerIdentifiers) {
        if (merchantAcquirerIdentifiers == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<PaymentDetailsScheme, String> entry : merchantAcquirerIdentifiers.entrySet()) {
            String string = this.dtoConversionHelper.createPaymentDetailsSchemeString(entry.getKey());
            String string2 = entry.getValue();
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private Map<String, Set<String>> createAcceptedCurrenciesDto(Map<PaymentDetailsScheme, Set<Currency>> acceptedCurrencies) {
        if (Objects.isNull(acceptedCurrencies)) {
            return null;
        }
        return acceptedCurrencies.entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(entry -> ((PaymentDetailsScheme)entry.getKey()).name(), entry -> ((Set)entry.getValue()).stream().filter(Objects::nonNull).map(Enum::name).collect(Collectors.toSet())));
    }
}

