/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.offline;

import com.visa.utils.Base64;
import io.mpos.accessories.AccessoryType;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.offline.dto.LocalOfflineTransactionDTO;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsSignatureWrapper;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineAttachmentsDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineRefundTransactionDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineSignatureDTO;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionCardPresentDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionReaderDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendStatusDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionParametersDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.AccessoryTypeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSchemeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSourceSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionStatusDetailsCodesSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionTypeSerializer;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultCardDetails;
import io.mpos.shared.transactions.DefaultRefundDetails;
import io.mpos.shared.transactions.DefaultRefundTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DefaultTransactionDetails;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.RefundTransaction;
import io.mpos.transactions.TipAdjustStatus;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionTypeDetailsCode;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OfflineTransactionDtoToTransactionConverter {
    private static final String TAG = "DtoToTxConverter";
    private final DTOConversionHelper dtoConversionHelper;
    private final DateFormat iso8601DateFormat;

    public OfflineTransactionDtoToTransactionConverter(DTOConversionHelper dtoConversionHelper, DateFormat iso8601DateFormat) {
        this.dtoConversionHelper = dtoConversionHelper;
        this.iso8601DateFormat = iso8601DateFormat;
    }

    public BaseTransaction createTransaction(LocalOfflineTransactionDTO dto, boolean deepLoading) {
        BigDecimal bigDecimal = dto.getParameters().getAmount();
        Currency currency = Currency.valueOf((String)dto.getParameters().getCurrency());
        TransactionType transactionType = (TransactionType)TransactionTypeSerializer.getInstance().deserialize(dto.getParameters().getType());
        DefaultTransaction defaultTransaction = new DefaultTransaction(bigDecimal, currency, transactionType);
        defaultTransaction.setConfigurationToken(dto.getConfiguration());
        defaultTransaction.setIdentifier(dto.getIdentifier());
        defaultTransaction.setCreatedTimestamp(this.createTimestampFromIso8601DateFormat(dto.getCreated()));
        this.populateTransactionParametersData(defaultTransaction, dto.getParameters());
        this.populateStatusDetailsData(defaultTransaction, dto.getStatusDetails());
        this.populateCardPresentData(defaultTransaction, dto.getCardPresent(), deepLoading);
        this.populateAttachmentData(defaultTransaction, dto.getAttachments(), deepLoading);
        this.populateRefundData(defaultTransaction, dto.getRefundTransactions());
        defaultTransaction.setError(this.createErrorForStatusDetailsCode(defaultTransaction.getStatusDetails().getCode()));
        defaultTransaction.setAutoCapture(true);
        defaultTransaction.setMode(TransactionMode.OFFLINE);
        defaultTransaction.setState(TransactionState.ENDED);
        defaultTransaction.setReceiptDetails(this.dtoConversionHelper.createReceiptDetailsFromDTO(dto.getReceiptDetails()));
        DefaultCardDetails defaultCardDetails = new DefaultCardDetails();
        defaultCardDetails.setMaskedCardNumber(dto.getCardPresent().getMaskedAccountNumber());
        defaultCardDetails.setScheme((PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(dto.getCardPresent().getPaymentScheme()));
        defaultTransaction.setCardDetails(defaultCardDetails);
        return defaultTransaction;
    }

    private void populateRefundData(DefaultTransaction transaction, List<BackendOfflineRefundTransactionDTO> dtos) {
        DefaultRefundDetails defaultRefundDetails = (DefaultRefundDetails)transaction.getRefundDetails();
        if (dtos == null || dtos.isEmpty()) {
            defaultRefundDetails.setRefundDetailsStatus(RefundDetailsStatus.REFUNDABLE_FULL_ONLY);
        } else {
            defaultRefundDetails.setRefundDetailsStatus(RefundDetailsStatus.REFUNDED);
            ArrayList<RefundTransaction> arrayList = new ArrayList<RefundTransaction>();
            for (BackendOfflineRefundTransactionDTO backendOfflineRefundTransactionDTO : dtos) {
                arrayList.add(this.refundTransactionFromOfflineRefundTransaction(backendOfflineRefundTransactionDTO));
            }
            defaultRefundDetails.setRefundTransactions(arrayList);
        }
    }

    private RefundTransaction refundTransactionFromOfflineRefundTransaction(BackendOfflineRefundTransactionDTO dto) {
        DefaultRefundTransaction defaultRefundTransaction = new DefaultRefundTransaction();
        defaultRefundTransaction.setAmount(dto.getAmount());
        defaultRefundTransaction.setCurrency(Currency.valueOf((String)dto.getCurrency()));
        defaultRefundTransaction.setIdentifier(dto.getIdentifier());
        defaultRefundTransaction.setType(TransactionType.REFUND);
        defaultRefundTransaction.setStatusDetails(this.createStatusDetailsFromDto(dto.getStatusDetails()));
        defaultRefundTransaction.setCreatedTimestamp(this.createTimestampFromIso8601DateFormat(dto.getCreated()));
        defaultRefundTransaction.setStatus(this.createStatusForStatusDetailsCode(defaultRefundTransaction.getStatusDetails().getCode()));
        defaultRefundTransaction.setCode(TransactionTypeDetailsCode.REFUND_BEFORE_CLEARING);
        return defaultRefundTransaction;
    }

    private void populateAttachmentData(DefaultTransaction transaction, BackendOfflineAttachmentsDTO attachments, boolean deepLoading) {
        if (!deepLoading) {
            return;
        }
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        if (defaultPaymentDetails.requiresSignature()) {
            PaymentDetailsSignatureWrapper paymentDetailsSignatureWrapper = new PaymentDetailsSignatureWrapper(defaultPaymentDetails);
            BackendOfflineSignatureDTO backendOfflineSignatureDTO = attachments.getSignature();
            if (backendOfflineSignatureDTO != null) {
                if (backendOfflineSignatureDTO.getType() != null) {
                    paymentDetailsSignatureWrapper.setType(PaymentDetailsSignatureWrapper.SignatureType.valueOf(backendOfflineSignatureDTO.getType()));
                }
                if (backendOfflineSignatureDTO.getData() != null) {
                    byte[] byArray = Base64.decode((String)backendOfflineSignatureDTO.getData(), (int)2);
                    paymentDetailsSignatureWrapper.setSignature(byArray);
                }
            }
        }
    }

    private void populateCardPresentData(DefaultTransaction transaction, BackendExecuteTransactionCardPresentDTO dto, boolean deepLoading) {
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        this.populateReaderData(transaction, dto.getReader());
        this.populatePaymentDetailsData(defaultPaymentDetails, dto, deepLoading);
    }

    private PaymentDetails populatePaymentDetailsData(DefaultPaymentDetails paymentDetails, BackendExecuteTransactionCardPresentDTO dto, boolean deepLoading) {
        PaymentDetailsCustomerVerificationDetailed paymentDetailsCustomerVerificationDetailed = this.dtoConversionHelper.createCustomerVerificationDetailedFromDTOString(dto.getVerificationMethod());
        paymentDetails.setCustomerVerificationDetailed(paymentDetailsCustomerVerificationDetailed);
        PaymentDetailsScheme paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(dto.getPaymentScheme());
        paymentDetails.setScheme(paymentDetailsScheme);
        PaymentDetailsSource paymentDetailsSource = (PaymentDetailsSource)PaymentDetailsSourceSerializer.getInstance().deserialize(dto.getMode());
        paymentDetails.setSource(paymentDetailsSource);
        if (!deepLoading) {
            return paymentDetails;
        }
        if (paymentDetails.getSource() != null) {
            switch (paymentDetails.getSource()) {
                case ICC: 
                case NFC_ICC: 
                case NFC_MAGSTRIPE: {
                    this.populateIccInformation(paymentDetails, dto);
                    break;
                }
                case MAGNETIC_STRIPE: 
                case MAGNETIC_STRIPE_FALLBACK: {
                    this.populateMagstripeInformation(paymentDetails, dto);
                }
            }
        }
        return paymentDetails;
    }

    private void populateIccInformation(DefaultPaymentDetails paymentDetails, BackendExecuteTransactionCardPresentDTO cardPresent) {
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(paymentDetails);
        IccInformation iccInformation = new IccInformation();
        iccInformation.setMaskedAccountNumber(cardPresent.getMaskedAccountNumber());
        iccInformation.setMaskedTrack2(cardPresent.getMaskedTrack2());
        if (cardPresent.getPin() != null) {
            iccInformation.setPinData(cardPresent.getPin().getData());
            iccInformation.setPinKSN(cardPresent.getPin().getKsn());
        }
        if (cardPresent.getSred() != null) {
            iccInformation.setSredData(cardPresent.getSred().getData());
            iccInformation.setSredKSN(cardPresent.getSred().getKsn());
        }
        paymentDetailsIccWrapper.setIccInformation(iccInformation);
        if (cardPresent.getIccData() == null) {
            return;
        }
        if (cardPresent.getIccData().getArqc() != null) {
            paymentDetailsIccWrapper.setDataArqc(this.tlvObjectsFromHexString(cardPresent.getIccData().getArqc()));
        }
        if (cardPresent.getIccData().getTc() != null) {
            paymentDetailsIccWrapper.setDataTc(this.tlvObjectsFromHexString(cardPresent.getIccData().getTc()));
        }
        if (cardPresent.getIccData().getAac() != null) {
            paymentDetailsIccWrapper.setDataAac(this.tlvObjectsFromHexString(cardPresent.getIccData().getAac()));
        }
    }

    private TlvObject[] tlvObjectsFromHexString(String dataString) {
        byte[] byArray = ByteHelper.fromHexString(dataString);
        return TLVHelper.deserializeFlatTlvObjects(byArray);
    }

    private void populateMagstripeInformation(DefaultPaymentDetails paymentDetails, BackendExecuteTransactionCardPresentDTO cardPresent) {
        PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(paymentDetails);
        PaymentDetailsScheme paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(cardPresent.getPaymentScheme());
        paymentDetailsMagstripeWrapper.setSchemeName(paymentDetailsScheme.name());
        MagstripeInformation magstripeInformation = new MagstripeInformation();
        magstripeInformation.setMaskedAccountNumber(cardPresent.getMaskedAccountNumber());
        magstripeInformation.setMaskedTrack2(cardPresent.getMaskedTrack2());
        if (cardPresent.getPin() != null) {
            magstripeInformation.setPinData(cardPresent.getPin().getData());
            magstripeInformation.setPinKSN(cardPresent.getPin().getKsn());
        }
        if (cardPresent.getSred() != null) {
            magstripeInformation.setSredData(cardPresent.getSred().getData());
            magstripeInformation.setSredKSN(cardPresent.getSred().getKsn());
        }
        paymentDetailsMagstripeWrapper.setMagstripeInformation(magstripeInformation);
    }

    private void populateReaderData(DefaultTransaction transaction, BackendExecuteTransactionReaderDataDTO dto) {
        DefaultAccessoryDetails defaultAccessoryDetails = (DefaultAccessoryDetails)transaction.getAccessoryDetails();
        defaultAccessoryDetails.setAccessoryType((AccessoryType)AccessoryTypeSerializer.getInstance().deserialize(dto.getType()));
        defaultAccessoryDetails.setSerialNumber(dto.getSerialNumber());
    }

    private void populateTransactionParametersData(DefaultTransaction transaction, BackendTransactionParametersDTO dto) {
        transaction.setSubject(dto.getSubject());
        transaction.setCustomIdentifier(dto.getCustomIdentifier());
        DefaultTransactionDetails defaultTransactionDetails = (DefaultTransactionDetails)transaction.getDetails();
        defaultTransactionDetails.setMetadata(dto.getDetails().getMetadata());
        defaultTransactionDetails.setIncludedTipAmount(dto.getDetails().getIncludedTipAmount());
        defaultTransactionDetails.setTipAdjustStatus(TipAdjustStatus.NOT_ADJUSTABLE);
    }

    private void populateStatusDetailsData(DefaultTransaction transaction, BackendStatusDetailsDTO dto) {
        transaction.setStatusDetails(this.createStatusDetailsFromDto(dto));
        transaction.setStatus(this.createStatusForStatusDetailsCode(transaction.getStatusDetails().getCode()));
    }

    private DefaultTransactionStatusDetails createStatusDetailsFromDto(BackendStatusDetailsDTO dto) {
        DefaultTransactionStatusDetails defaultTransactionStatusDetails = new DefaultTransactionStatusDetails();
        defaultTransactionStatusDetails.setCode(this.createStatusDetailsCodeFromString(dto.getCode()));
        defaultTransactionStatusDetails.setDescription(dto.getDescription());
        defaultTransactionStatusDetails.setDeveloperDescription(dto.getDeveloperDescription());
        return defaultTransactionStatusDetails;
    }

    private TransactionStatusDetailsCodes createStatusDetailsCodeFromString(String codeString) {
        TransactionStatusDetailsCodes transactionStatusDetailsCodes = (TransactionStatusDetailsCodes)TransactionStatusDetailsCodesSerializer.getInstance().deserialize(codeString);
        switch (transactionStatusDetailsCodes) {
            case APPROVED: 
            case PENDING_WAITING_FOR_EXECUTION: 
            case ACCEPTED_WAITING_FOR_SUBMISSION: {
                transactionStatusDetailsCodes = TransactionStatusDetailsCodes.ACCEPTED_WAITING_FOR_SUBMISSION;
                return transactionStatusDetailsCodes;
            }
        }
        return transactionStatusDetailsCodes;
    }

    private long createTimestampFromIso8601DateFormat(String createdString) {
        try {
            Date date = this.iso8601DateFormat.parse(createdString);
            return date.getTime();
        }
        catch (ParseException parseException) {
            Log.e(TAG, "Cannot convert iso8601 formatted date to timestamp");
            return 0L;
        }
    }

    private MposError createErrorForStatusDetailsCode(TransactionStatusDetailsCodes code) {
        switch (code) {
            case APPROVED: 
            case PENDING_WAITING_FOR_EXECUTION: 
            case ACCEPTED_WAITING_FOR_SUBMISSION: 
            case INITIALIZED_LOCALLY: 
            case INITIALIZED_AT_SERVER: 
            case INITIALIZED_AT_PROCESSOR: 
            case INITIALIZED_WITH_REPLACEMENT: 
            case INITIALIZED_TRANSACTION_REQUEST_PIN: 
            case INITIALIZED_TRANSACTION_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO: 
            case PENDING_WAITING_FOR_PROCESSOR: 
            case PENDING_AWAITING_FINALIZATION: 
            case APPROVED_PARTIALLY: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED: 
            case DECLINED_PROCESSOR: 
            case DECLINED_INVALID_TERMINAL_SOFTWARE: 
            case DECLINED_INVALID_TERMINAL_CONFIGURATION: 
            case DECLINED_INVALID_TERMINAL: 
            case DECLINED_INVALID_SESSION_EXPIRED: 
            case DECLINED_PIN_WRONG: 
            case DECLINED_PIN_WRONG_TOO_OFTEN: 
            case DECLINED_CARD_EXPIRED: 
            case DECLINED_CARD_INVALID_SCHEME: 
            case DECLINED_CARD_INVALID_PAN: 
            case DECLINED_CARD_STOLEN: 
            case DECLINED_CARD_USE_ORIGINAL: 
            case DECLINED_PROCESSOR_EXCEEDS_WITHDRAWAL_COUNT_LIMIT: 
            case DECLINED_PROCESSOR_PIN_ENTRY_NECESSARY: 
            case DECLINED_PROCESSOR_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO: 
            case DECLINED_PROCESSOR_INCONSISTENT_STATE: 
            case DECLINED_PROCESSOR_UNCAPTURED_CHARGES_NOT_SUPPORTED: 
            case DECLINED_MALFORMED_REQUEST: 
            case DECLINED_MANIPULATION_SUSPECTED: 
            case DECLINED_CARD_BLOCKED: 
            case DECLINED_INSUFFICIENT_FUNDS: 
            case DECLINED_TRANSACTION_FREQUENCY_EXCEEDED: 
            case DECLINED_CARD_LOST: 
            case DECLINED_INVALID_SCHEME: 
            case DECLINED_INVALID_AMOUNT: 
            case DECLINED_INVALID_CURRENCY: 
            case DECLINED_INVALID_CONFIGURATION: 
            case DECLINED_DUPLICATE_TRANSACTION: 
            case DECLINED_INVALID_PAYMENT_CODE: 
            case DECLINED_INVALID_WORKFLOW: 
            case DECLINED_PROCESSOR_CARD_EXPIRED: 
            case DECLINED_PROCESSOR_REFUND_NOT_POSSIBLE: 
            case DECLINED_PROCESSOR_TEMPORARILY_BLACKLISTED: 
            case DECLINED_AMOUNT_EXCEEDS_LIMIT: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_1ST_GEN_AC: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_2ND_GEN_AC: 
            case DECLINED_FORBIDDEN_CARD_CAPTURE_CARD: 
            case DECLINED_AUTHORIZATION_PROCESSOR_MALFUNCTION: 
            case DECLINED_CARD_MAGSTRIPE_SERVICE_CODE_RISK_CHECK_FAILED: 
            case DECLINED_CARD_INVALID_START_DATE_ICC: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_1ST_GEN_AC_EXPIRED_APPLICATION: 
            case DECLINED_CARD_MAGSTRIPE_SERVICE_CODE_RISK_CHECK_FAILED_USE_CHIP: 
            case DECLINED_CARD_INVALID_START_DATE_MAGSTRIPE: 
            case DECLINED_AUTHORIZATION_PROCESSOR_TIMEOUT: 
            case DECLINED_CARD_ALREADY_ACTIVE: 
            case DECLINED_FORBIDDEN_APPLICATION: 
            case DECLINED_FRAUD: 
            case DECLINED_INACTIVE_PROCESSING_PATH: 
            case DECLINED_INVALID_CLERK: 
            case DECLINED_INVALID_CVN: 
            case DECLINED_MERCHANT_REJECTED: 
            case DECLINED_PARTIAL_APPROVAL_OR_VERBAL_AUTHORIZATION_REQUIRED: 
            case DECLINED_RELOAD_LIMIT_EXCEEDED: 
            case DECLINED_VERIFICATION_FAILED: 
            case ABORTED_SHOPPER_REMOVED_CARD: 
            case ABORTED_SHOPPER_ABORTED: 
            case ABORTED_MERCHANT_ABORTED: 
            case ABORTED_PRESENT_CARD_TIMED_OUT: 
            case ABORTED_PIN_ENTRY_TIMED_OUT: 
            case ABORTED_MERCHANT_MANUALLY_REVERTED: {
                return null;
            }
            case ERROR_INVALID_PROCESSOR_FORMAT: 
            case ERROR_INVALID_PROCESSOR_STATUS: 
            case ERROR_MISSING_PROCESSOR_SESSION: 
            case ERROR_INVALID_PROCESSOR_SESSION: 
            case ERROR_INVALID_PROCESSOR_NONCE: 
            case ERROR_PROCESSOR_CONNECTION_ERROR: 
            case ERROR_PROCESSOR_FAILED_INCONSISTENT_STATE_UNRESOLVED: 
            case ERROR_PROCESSOR_FAILED_INCONSISTENT_STATE_RESOLVED: 
            case ERROR_PROCESSOR_PAYMENT_DETAILS_EXTRACTION_FAILED: 
            case ERROR_PROCESSOR_INVALID_PAYMENT_DETAILS: 
            case ERROR_PROCESSOR_INVALID_CONFIGURATION: 
            case ERROR_PROCESSOR_MALFORMED_REQUEST: 
            case ERROR_PROCESSOR_TRANSACTION_ALREADY_IN_PROGRESS: 
            case ERROR_PROCESSOR_CONNECTION_NO_RESPONSE: 
            case ERROR_TERMINAL_ERROR: 
            case ERROR_TERMINAL_TIMEOUT: {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Terminal timed out");
            }
            case ERROR_TERMINAL_BATTERY_LOW: {
                return new DefaultMposError(ErrorType.ACCESSORY_BATTERY_LOW, "Accessory battery is critically low");
            }
            case ERROR_SERVER_INVALID_RESPONSE: {
                return new DefaultMposError(ErrorType.SERVER_INVALID_RESPONSE, "Server returned an invalid response");
            }
            case ERROR_SERVER_UNAVAILABLE: {
                return new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Server unavailable");
            }
            case ERROR_SERVER_MALFORMED_REQUEST: {
                return new DefaultMposError(ErrorType.SERVER_INVALID_RESPONSE, "Server reported a malformed request");
            }
            case ERROR_SERVER_INVALID_TRANSACTION_TYPE: 
            case ERROR_SERVER_INVALID_TRANSACTION_STATUS: 
            case ERROR_SERVER_INVALID_REFUND_AMOUNT: 
            case ERROR_SERVER_INVALID_TRANSACTION: 
            case ERROR_TRANSACTION_PENDING_MANUAL_REVIEW: 
            case ERROR_TRANSACTION_UNABLE_TO_PERSIST: 
            case ERROR_AUTOREVERSAL_INCONCLUSIVE: 
            case ERROR_AUTOREVERSAL_ERROR: 
            case ERROR_AUTOREVERSAL_LOGOUT: {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Transaction error");
            }
            case ERROR_SESSION_TIMEOUT: 
            case ERROR_SERVER_TIMEOUT: {
                return new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Server/Session timed out");
            }
            case ERROR_SERVER_AUTHENTICATION_FAILED: {
                return new DefaultMposError(ErrorType.SERVER_AUTHENTICATION_FAILED, "Server authentication failed");
            }
            case ERROR_SERVER_PINNING_FAILED: {
                return new DefaultMposError(ErrorType.SERVER_PINNING_WITH_REMOTE_FAILED, "Server pinning failed");
            }
            case ERROR_SERVER_ACCESSORY_DEACTIVATED: 
            case ERROR_SERVER_ACCESSORY_NOT_ASSIGNED_TO_MERCHANT: {
                return new DefaultMposError(ErrorType.SERVER_ERROR, "Server indicated accessory error");
            }
            case ERROR_APPROVED_OFFLINE: {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Transaction was incorrectly approved offline");
            }
        }
        return null;
    }

    private TransactionStatus createStatusForStatusDetailsCode(TransactionStatusDetailsCodes code) {
        switch (code) {
            case APPROVED: 
            case PENDING_WAITING_FOR_EXECUTION: 
            case ACCEPTED_WAITING_FOR_SUBMISSION: 
            case PENDING_AWAITING_FINALIZATION: {
                return TransactionStatus.ACCEPTED;
            }
            case DECLINED_CARD_OR_TERMINAL_DECLINED: 
            case DECLINED_PROCESSOR: 
            case DECLINED_INVALID_TERMINAL_SOFTWARE: 
            case DECLINED_INVALID_TERMINAL_CONFIGURATION: 
            case DECLINED_INVALID_TERMINAL: 
            case DECLINED_INVALID_SESSION_EXPIRED: 
            case DECLINED_PIN_WRONG: 
            case DECLINED_PIN_WRONG_TOO_OFTEN: 
            case DECLINED_CARD_EXPIRED: 
            case DECLINED_CARD_INVALID_SCHEME: 
            case DECLINED_CARD_INVALID_PAN: 
            case DECLINED_CARD_STOLEN: 
            case DECLINED_CARD_USE_ORIGINAL: 
            case DECLINED_PROCESSOR_EXCEEDS_WITHDRAWAL_COUNT_LIMIT: 
            case DECLINED_PROCESSOR_PIN_ENTRY_NECESSARY: 
            case DECLINED_PROCESSOR_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO: 
            case DECLINED_PROCESSOR_INCONSISTENT_STATE: 
            case DECLINED_PROCESSOR_UNCAPTURED_CHARGES_NOT_SUPPORTED: 
            case DECLINED_MALFORMED_REQUEST: 
            case DECLINED_MANIPULATION_SUSPECTED: 
            case DECLINED_CARD_BLOCKED: 
            case DECLINED_INSUFFICIENT_FUNDS: 
            case DECLINED_TRANSACTION_FREQUENCY_EXCEEDED: 
            case DECLINED_CARD_LOST: 
            case DECLINED_INVALID_SCHEME: 
            case DECLINED_INVALID_AMOUNT: 
            case DECLINED_INVALID_CURRENCY: 
            case DECLINED_INVALID_CONFIGURATION: 
            case DECLINED_DUPLICATE_TRANSACTION: 
            case DECLINED_INVALID_PAYMENT_CODE: 
            case DECLINED_INVALID_WORKFLOW: 
            case DECLINED_PROCESSOR_CARD_EXPIRED: 
            case DECLINED_PROCESSOR_REFUND_NOT_POSSIBLE: 
            case DECLINED_PROCESSOR_TEMPORARILY_BLACKLISTED: 
            case DECLINED_AMOUNT_EXCEEDS_LIMIT: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_1ST_GEN_AC: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_2ND_GEN_AC: 
            case DECLINED_FORBIDDEN_CARD_CAPTURE_CARD: 
            case DECLINED_AUTHORIZATION_PROCESSOR_MALFUNCTION: 
            case DECLINED_CARD_MAGSTRIPE_SERVICE_CODE_RISK_CHECK_FAILED: 
            case DECLINED_CARD_INVALID_START_DATE_ICC: 
            case DECLINED_CARD_OR_TERMINAL_DECLINED_1ST_GEN_AC_EXPIRED_APPLICATION: 
            case DECLINED_CARD_MAGSTRIPE_SERVICE_CODE_RISK_CHECK_FAILED_USE_CHIP: 
            case DECLINED_CARD_INVALID_START_DATE_MAGSTRIPE: 
            case DECLINED_AUTHORIZATION_PROCESSOR_TIMEOUT: 
            case DECLINED_CARD_ALREADY_ACTIVE: 
            case DECLINED_FORBIDDEN_APPLICATION: 
            case DECLINED_FRAUD: 
            case DECLINED_INACTIVE_PROCESSING_PATH: 
            case DECLINED_INVALID_CLERK: 
            case DECLINED_INVALID_CVN: 
            case DECLINED_MERCHANT_REJECTED: 
            case DECLINED_PARTIAL_APPROVAL_OR_VERBAL_AUTHORIZATION_REQUIRED: 
            case DECLINED_RELOAD_LIMIT_EXCEEDED: 
            case DECLINED_VERIFICATION_FAILED: {
                return TransactionStatus.DECLINED;
            }
            case ABORTED_SHOPPER_REMOVED_CARD: 
            case ABORTED_SHOPPER_ABORTED: 
            case ABORTED_MERCHANT_ABORTED: 
            case ABORTED_PRESENT_CARD_TIMED_OUT: 
            case ABORTED_PIN_ENTRY_TIMED_OUT: 
            case ABORTED_MERCHANT_MANUALLY_REVERTED: {
                return TransactionStatus.ABORTED;
            }
            case INITIALIZED_LOCALLY: 
            case INITIALIZED_AT_SERVER: 
            case INITIALIZED_AT_PROCESSOR: 
            case INITIALIZED_WITH_REPLACEMENT: 
            case INITIALIZED_TRANSACTION_REQUEST_PIN: 
            case INITIALIZED_TRANSACTION_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO: 
            case PENDING_WAITING_FOR_PROCESSOR: 
            case ERROR_INVALID_PROCESSOR_FORMAT: 
            case ERROR_INVALID_PROCESSOR_STATUS: 
            case ERROR_MISSING_PROCESSOR_SESSION: 
            case ERROR_INVALID_PROCESSOR_SESSION: 
            case ERROR_INVALID_PROCESSOR_NONCE: 
            case ERROR_PROCESSOR_CONNECTION_ERROR: 
            case ERROR_PROCESSOR_FAILED_INCONSISTENT_STATE_UNRESOLVED: 
            case ERROR_PROCESSOR_FAILED_INCONSISTENT_STATE_RESOLVED: 
            case ERROR_PROCESSOR_PAYMENT_DETAILS_EXTRACTION_FAILED: 
            case ERROR_PROCESSOR_INVALID_PAYMENT_DETAILS: 
            case ERROR_PROCESSOR_INVALID_CONFIGURATION: 
            case ERROR_PROCESSOR_MALFORMED_REQUEST: 
            case ERROR_PROCESSOR_TRANSACTION_ALREADY_IN_PROGRESS: 
            case ERROR_PROCESSOR_CONNECTION_NO_RESPONSE: 
            case ERROR_TERMINAL_ERROR: 
            case ERROR_TERMINAL_TIMEOUT: 
            case ERROR_TERMINAL_BATTERY_LOW: 
            case ERROR_SERVER_INVALID_RESPONSE: 
            case ERROR_SERVER_UNAVAILABLE: 
            case ERROR_SERVER_MALFORMED_REQUEST: 
            case ERROR_SERVER_INVALID_TRANSACTION_TYPE: 
            case ERROR_SERVER_INVALID_TRANSACTION_STATUS: 
            case ERROR_SERVER_INVALID_REFUND_AMOUNT: 
            case ERROR_SERVER_INVALID_TRANSACTION: 
            case ERROR_TRANSACTION_PENDING_MANUAL_REVIEW: 
            case ERROR_TRANSACTION_UNABLE_TO_PERSIST: 
            case ERROR_AUTOREVERSAL_INCONCLUSIVE: 
            case ERROR_AUTOREVERSAL_ERROR: 
            case ERROR_AUTOREVERSAL_LOGOUT: 
            case ERROR_SESSION_TIMEOUT: 
            case ERROR_SERVER_TIMEOUT: 
            case ERROR_SERVER_AUTHENTICATION_FAILED: 
            case ERROR_SERVER_PINNING_FAILED: 
            case ERROR_SERVER_ACCESSORY_DEACTIVATED: 
            case ERROR_SERVER_ACCESSORY_NOT_ASSIGNED_TO_MERCHANT: 
            case ERROR_APPROVED_OFFLINE: 
            case ERROR_CARD_INVALID_CARD: 
            case ERROR_CARD_UNSUPPORTED_CARD: 
            case ERROR_AVS_UNAVAILABLE: 
            case ERROR_INVALID_CUSTOMER_SIGNATURE: 
            case ERROR_SDK_INTERNAL_ERROR: {
                return TransactionStatus.ERROR;
            }
        }
        return TransactionStatus.UNKNOWN;
    }
}

