/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.offline;

import com.visa.utils.Base64;
import io.mpos.shared.offline.dto.LocalOfflineTransactionDTO;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsSignatureWrapper;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendBatchSubmissionRequestDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineAttachmentsDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineRefundTransactionDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineSignatureDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendOfflineTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionCardPresentDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendStatusDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionParametersDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionStatusDetailsCodesSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionTypeSerializer;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.RefundTransaction;
import io.mpos.transactions.TransactionDetails;
import io.mpos.transactions.TransactionStatusDetails;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TransactionToOfflineTransactionDtoConverter {
    private final DTOConversionHelper dtoConversionHelper;
    private final DateFormat iso8601DateFormat;

    public TransactionToOfflineTransactionDtoConverter(DTOConversionHelper dtoConversionHelper, DateFormat iso8601DateFormat) {
        this.dtoConversionHelper = dtoConversionHelper;
        this.iso8601DateFormat = iso8601DateFormat;
    }

    public BackendBatchSubmissionRequestDTO createBatchSubmissionRequestDTO(String identifier, List<? extends BaseTransaction> transactions) {
        return new BackendBatchSubmissionRequestDTO(identifier, this.createBackendOfflineTransactionsDTO(transactions));
    }

    private List<BackendOfflineTransactionDTO> createBackendOfflineTransactionsDTO(List<? extends BaseTransaction> transactions) {
        if (transactions == null || transactions.isEmpty()) {
            return null;
        }
        ArrayList<BackendOfflineTransactionDTO> arrayList = new ArrayList<BackendOfflineTransactionDTO>();
        for (BaseTransaction baseTransaction : transactions) {
            DefaultTransaction defaultTransaction = (DefaultTransaction)baseTransaction;
            arrayList.add(this.createBackendOfflineTransactionDTO(defaultTransaction));
        }
        return arrayList;
    }

    private BackendOfflineTransactionDTO createBackendOfflineTransactionDTO(DefaultTransaction transaction) {
        boolean bl2 = transaction.getRefundDetails().getStatus() == RefundDetailsStatus.REFUNDED;
        return new BackendOfflineTransactionDTO(transaction.getConfigurationToken(), transaction.getIdentifier(), this.createISO8601FormattedDate(transaction.getCreatedTimestamp()), this.createTransactionParametersDTO(transaction), this.createExecuteTransactionCardPresentDTO(transaction), this.createAttachmentsDTO(transaction), this.createStatusDetailsDTO(transaction.getStatusDetails(), bl2), this.createRefundTransactionsDTO(transaction));
    }

    public LocalOfflineTransactionDTO createLocalOfflineTransactionDTO(DefaultTransaction transaction) {
        boolean bl2 = transaction.getRefundDetails().getStatus() == RefundDetailsStatus.REFUNDED;
        return new LocalOfflineTransactionDTO(this.dtoConversionHelper.createBackendReceiptDetailsDTO(transaction.getReceiptDetails()), transaction.getConfigurationToken(), transaction.getIdentifier(), this.createISO8601FormattedDate(transaction.getCreatedTimestamp()), this.createTransactionParametersDTO(transaction), this.createExecuteTransactionCardPresentDTO(transaction), this.createAttachmentsDTO(transaction), this.createStatusDetailsDTO(transaction.getStatusDetails(), bl2), this.createRefundTransactionsDTO(transaction));
    }

    private BackendExecuteTransactionCardPresentDTO createExecuteTransactionCardPresentDTO(DefaultTransaction transaction) {
        BackendExecuteTransactionCardPresentDTO backendExecuteTransactionCardPresentDTO = this.dtoConversionHelper.createExecuteTransactionCardPresentDTO(transaction);
        backendExecuteTransactionCardPresentDTO.getReader().setConfiguration(transaction.getConfigurationToken());
        return backendExecuteTransactionCardPresentDTO;
    }

    private List<BackendOfflineRefundTransactionDTO> createRefundTransactionsDTO(DefaultTransaction transaction) {
        List list = transaction.getRefundDetails().getRefundTransactions();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<BackendOfflineRefundTransactionDTO> arrayList = new ArrayList<BackendOfflineRefundTransactionDTO>();
        for (RefundTransaction refundTransaction : list) {
            arrayList.add(this.createRefundTransactionDTO(refundTransaction));
        }
        return arrayList;
    }

    private BackendOfflineRefundTransactionDTO createRefundTransactionDTO(RefundTransaction refundTransaction) {
        return new BackendOfflineRefundTransactionDTO(refundTransaction.getAmount(), refundTransaction.getIdentifier(), this.createISO8601FormattedDate(refundTransaction.getCreatedTimestamp()), refundTransaction.getCurrency().name(), this.createStatusDetailsDTO(refundTransaction.getStatusDetails(), true));
    }

    private BackendTransactionParametersDTO createTransactionParametersDTO(DefaultTransaction transaction) {
        return new BackendTransactionParametersDTO(transaction.getAmount(), transaction.getCurrency().name(), TransactionTypeSerializer.getInstance().serialize(transaction.getType()), transaction.getCustomIdentifier(), transaction.getSubject(), this.createTransactionDetailsDTO(transaction.getDetails()));
    }

    private BackendTransactionDetailsDTO createTransactionDetailsDTO(TransactionDetails details) {
        return new BackendTransactionDetailsDTO(details.getIncludedTipAmount(), null, details.getMetadata(), null, false);
    }

    private BackendStatusDetailsDTO createStatusDetailsDTO(TransactionStatusDetails statusDetails, boolean isRefund) {
        BackendStatusDetailsDTO backendStatusDetailsDTO = new BackendStatusDetailsDTO();
        backendStatusDetailsDTO.setCode(this.createTransactionStatusDetailsCodeString(statusDetails.getCode(), isRefund));
        return backendStatusDetailsDTO;
    }

    private String createTransactionStatusDetailsCodeString(TransactionStatusDetailsCodes code, boolean isRefund) {
        switch (code) {
            case ACCEPTED_WAITING_FOR_SUBMISSION: {
                if (isRefund) {
                    return "APPROVED";
                }
                return "PENDING_WAITING_FOR_EXECUTION";
            }
        }
        return TransactionStatusDetailsCodesSerializer.getInstance().serialize(code);
    }

    private BackendOfflineAttachmentsDTO createAttachmentsDTO(DefaultTransaction transaction) {
        String string;
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        if (!defaultPaymentDetails.requiresSignature()) {
            return new BackendOfflineAttachmentsDTO();
        }
        PaymentDetailsSignatureWrapper paymentDetailsSignatureWrapper = new PaymentDetailsSignatureWrapper(defaultPaymentDetails);
        if (paymentDetailsSignatureWrapper.getType() == PaymentDetailsSignatureWrapper.SignatureType.UNKNOWN) {
            return new BackendOfflineAttachmentsDTO();
        }
        String string2 = string = paymentDetailsSignatureWrapper.getSignature() != null ? Base64.encodeToString((byte[])paymentDetailsSignatureWrapper.getSignature(), (int)2) : null;
        if (paymentDetailsSignatureWrapper.getType().name().equals(PaymentDetailsSignatureWrapper.SignatureType.SKIPPED.name())) {
            paymentDetailsSignatureWrapper.setType(PaymentDetailsSignatureWrapper.SignatureType.ON_RECEIPT);
        }
        BackendOfflineSignatureDTO backendOfflineSignatureDTO = new BackendOfflineSignatureDTO(paymentDetailsSignatureWrapper.getType().name(), string);
        return new BackendOfflineAttachmentsDTO(backendOfflineSignatureDTO);
    }

    private String createISO8601FormattedDate(long timestamp) {
        Date date = new Date(timestamp);
        return this.iso8601DateFormat.format(date);
    }
}

