/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.paymentdetails.DccInformation;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DccOptions;
import java.math.BigDecimal;
import java.util.EnumSet;

public class DefaultDccInformation
implements DccInformation {
    private final BigDecimal originalAmount;
    private final Currency originalCurrency;
    private final BigDecimal convertedAmount;
    private final Currency convertedCurrency;
    private final BigDecimal exchangeRate;
    private final BigDecimal margin;
    private final String conversionHint;
    private final EnumSet<DccOptions> options;

    public DefaultDccInformation(BigDecimal originalAmount, Currency originalCurrency, BigDecimal convertedAmount, Currency convertedCurrency, BigDecimal exchangeRate, BigDecimal margin, String conversionHint, EnumSet<DccOptions> options) {
        this.originalAmount = originalAmount;
        this.originalCurrency = originalCurrency;
        this.convertedAmount = convertedAmount;
        this.convertedCurrency = convertedCurrency;
        this.exchangeRate = exchangeRate;
        this.margin = margin;
        this.conversionHint = conversionHint;
        this.options = options;
    }

    public DefaultDccInformation(BaseTransaction transaction) {
        this(transaction.getAmount(), transaction.getCurrency(), transaction.getDccDetails().getConvertedAmount(), transaction.getDccDetails().getConvertedCurrency(), transaction.getDccDetails().getRate(), transaction.getDccDetails().getMarkup(), transaction.getDccDetails().getConversionHint(), transaction.getDccDetails().getOptions());
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public Currency getOriginalCurrency() {
        return this.originalCurrency;
    }

    public BigDecimal getConvertedAmount() {
        return this.convertedAmount;
    }

    public Currency getConvertedCurrency() {
        return this.convertedCurrency;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public BigDecimal getMargin() {
        return this.margin;
    }

    public String getConversionHint() {
        return this.conversionHint;
    }

    public EnumSet<DccOptions> getOptions() {
        return this.options;
    }
}

