/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.paymentdetails.PinInformation;
import io.mpos.paymentdetails.PinInformationStatus;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.localization.LocalizationPromptParameters;
import io.mpos.shared.localization.LocalizationServer;
import java.util.Locale;

public class DefaultPinInformation
implements PinInformation {
    private PinInformationStatus pinInformationStatus;
    private int digits;
    private PinInformation.PinType pinType;

    public DefaultPinInformation(PinInformationStatus pinInformationStatus, PinInformation.PinType pinType, int digits) {
        this.pinInformationStatus = pinInformationStatus;
        this.pinType = pinType;
        this.digits = digits;
    }

    public DefaultPinInformation(PinInformationStatus pinInformationStatus, PinInformation.PinType pinType) {
        this(pinInformationStatus, pinType, 0);
    }

    @Override
    public PinInformationStatus getStatus() {
        return this.pinInformationStatus;
    }

    @Override
    public PinInformation.PinType getType() {
        return this.pinType;
    }

    @Override
    public int getDigits() {
        return this.digits;
    }

    public static String[] constructPINEntryText(PinInformation pinInformation, int lineWidth, Locale locale) {
        String string = "";
        if (pinInformation.getDigits() > 0) {
            string = Helper.fillStringWithCharacter(pinInformation.getDigits(), "*");
        }
        LocalizationPrompt localizationPrompt = null;
        switch (pinInformation.getStatus()) {
            case COMPLETED: {
                localizationPrompt = LocalizationPrompt.PIN_OK;
                break;
            }
            case INCORRECT: {
                localizationPrompt = LocalizationPrompt.PIN_INCORRECT;
                break;
            }
            case UPDATED: 
            case STARTED: {
                localizationPrompt = LocalizationPrompt.PIN_STATUS;
                break;
            }
            case LAST_TRY: {
                localizationPrompt = LocalizationPrompt.PIN_LAST_TRY;
            }
        }
        return LocalizationServer.getInstance().getCenteredLocalizationArray(new LocalizationPromptParameters.Builder(localizationPrompt).locale(locale).lineWidth(lineWidth).arguments(string).build());
    }

    public String toString() {
        return "DefaultPinInformation{pinInformationStatus=" + this.pinInformationStatus + ", digits=" + this.digits + ", pinType=" + this.pinType + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DefaultPinInformation defaultPinInformation = (DefaultPinInformation)o2;
        return this.digits == defaultPinInformation.digits && this.pinInformationStatus == defaultPinInformation.pinInformationStatus && this.pinType == defaultPinInformation.pinType;
    }

    public int hashCode() {
        int n2 = this.pinInformationStatus != null ? this.pinInformationStatus.hashCode() : 0;
        n2 = 31 * n2 + (this.pinType != null ? this.pinType.hashCode() : 0);
        n2 = 31 * n2 + this.digits;
        return n2;
    }
}

