/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagApplicationPrimaryAccountNumberSequenceNumber;
import io.mpos.specs.emv.TagTerminalVerificationResults;
import io.mpos.specs.emv.TagTransactionSequenceCounter;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class PaymentDetailsIccWrapper {
    private static final String KEY_AID = "icc_payment_details_wrapper_aid";
    private static final String KEY_AID_NAME = "icc_payment_details_wrapper_aidname";
    private static final String KEY_ICC_INFORMATION = "icc_payment_details_wrapper_icc_information";
    private static final String KEY_ARQC = "icc_payment_details_wrapper_arqc";
    private static final String KEY_ARPC = "icc_payment_details_wrapper_arpc";
    private static final String KEY_AAC = "icc_payment_details_wrapper_aac";
    private static final String KEY_TC = "icc_payment_details_wrapper_tc";
    DefaultPaymentDetails wrappedDetails;

    public PaymentDetailsIccWrapper(DefaultPaymentDetails wrappedDetails) {
        if (wrappedDetails == null) {
            throw new IllegalArgumentException("wrappedDetails must not be null");
        }
        this.wrappedDetails = wrappedDetails;
    }

    public PaymentDetailsIccWrapper(PaymentDetails paymentDetails) {
        this((DefaultPaymentDetails)paymentDetails);
    }

    public void mergeWithPaymentDetailsICCWrapper(PaymentDetailsIccWrapper other) {
        if (other == null) {
            return;
        }
        if (other.getApplicationIdentifier() != null) {
            this.setApplicationIdentifier(other.getApplicationIdentifier());
        }
        if (other.getApplicationName() != null) {
            this.setApplicationName(other.getApplicationName());
        }
        if (other.getDataAac() != null) {
            this.setDataAac(other.getDataAac());
        }
        if (other.getDataArpc() != null) {
            this.setDataArpc(other.getDataArpc());
        }
        if (other.getDataArqc() != null) {
            this.setDataArqc(other.getDataArqc());
        }
        if (other.getDataTc() != null) {
            this.setDataTc(other.getDataTc());
        }
        if (other.getIccInformation() != null) {
            if (this.getIccInformation() == null) {
                this.setIccInformation(other.getIccInformation());
            } else {
                this.getIccInformation().mergeWithIccInformation(other.getIccInformation());
            }
        }
    }

    public byte[] getApplicationIdentifier() {
        return (byte[])this.wrappedDetails.getData().get(KEY_AID);
    }

    public void setApplicationIdentifier(byte[] applicationIdentifier) {
        this.wrappedDetails.getData().put(KEY_AID, applicationIdentifier);
    }

    @Nullable
    public String getApplicationName() {
        return (String)this.wrappedDetails.getData().get(KEY_AID_NAME);
    }

    public void setApplicationName(String applicationName) {
        this.wrappedDetails.getData().put(KEY_AID_NAME, applicationName);
    }

    @Nullable
    public IccInformation getIccInformation() {
        return (IccInformation)this.wrappedDetails.getData().get(KEY_ICC_INFORMATION);
    }

    public void setIccInformation(IccInformation iccInformation) {
        this.wrappedDetails.getData().put(KEY_ICC_INFORMATION, iccInformation);
    }

    @Nullable
    public TlvObject[] getDataArqc() {
        return (TlvObject[])this.wrappedDetails.getData().get(KEY_ARQC);
    }

    public void setDataArqc(TlvObject[] dataArqc) {
        this.wrappedDetails.getData().put(KEY_ARQC, dataArqc);
    }

    @Nullable
    public TlvObject[] getDataArpc() {
        return (TlvObject[])this.wrappedDetails.getData().get(KEY_ARPC);
    }

    public void setDataArpc(TlvObject[] dataArpc) {
        this.wrappedDetails.getData().put(KEY_ARPC, dataArpc);
    }

    @Nullable
    public TlvObject[] getDataAac() {
        return (TlvObject[])this.wrappedDetails.getData().get(KEY_AAC);
    }

    public void setDataAac(TlvObject[] dataAac) {
        this.wrappedDetails.getData().put(KEY_AAC, dataAac);
    }

    @Nullable
    public TlvObject[] getDataTc() {
        return (TlvObject[])this.wrappedDetails.getData().get(KEY_TC);
    }

    public void setDataTc(TlvObject[] dataTc) {
        this.wrappedDetails.getData().put(KEY_TC, dataTc);
    }

    public String getApplicationExpiryDateYear() {
        if (this.getIccInformation() != null && this.getIccInformation().getExpirationDate() != null && this.getIccInformation().getExpirationDate().length() >= 4) {
            return "20" + this.getIccInformation().getExpirationDate().substring(0, 2);
        }
        return null;
    }

    public String getApplicationExpiryDateMonth() {
        if (this.getIccInformation() != null && this.getIccInformation().getExpirationDate() != null && this.getIccInformation().getExpirationDate().length() >= 4) {
            return this.getIccInformation().getExpirationDate().substring(2, 4);
        }
        return null;
    }

    public String getCardSequenceNumber() {
        TlvObject[] tlvObjectArray = this.getDataArqc();
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationPrimaryAccountNumberSequenceNumber.TAG_BYTES, tlvObjectArray);
        if (primitiveTlv == null) {
            return null;
        }
        TagApplicationPrimaryAccountNumberSequenceNumber tagApplicationPrimaryAccountNumberSequenceNumber = TagApplicationPrimaryAccountNumberSequenceNumber.wrap(primitiveTlv);
        return tagApplicationPrimaryAccountNumberSequenceNumber.getValueAsString();
    }

    public String getTransactionSequenceNumber() {
        TlvObject[] tlvObjectArray = this.getDataArqc();
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagTransactionSequenceCounter.TAG_BYTES, tlvObjectArray);
        if (primitiveTlv == null) {
            return null;
        }
        TagTransactionSequenceCounter tagTransactionSequenceCounter = TagTransactionSequenceCounter.wrap(primitiveTlv);
        return tagTransactionSequenceCounter.getValueAsString();
    }

    public boolean isTVRPresentInARQC() {
        TlvObject[] tlvObjectArray = this.getDataArqc();
        if (tlvObjectArray == null) {
            return false;
        }
        for (TlvObject tlvObject : tlvObjectArray) {
            if (!Arrays.equals(tlvObject.getTagBytes(), TagTerminalVerificationResults.TAG_BYTES)) continue;
            return true;
        }
        return false;
    }
}

