/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.accessories.components.interaction.DefaultCardData;
import io.mpos.accessories.components.interaction.moto.MotoType;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.transactions.DefaultAvsDetails;

public class PaymentDetailsManualInputWrapper {
    public static final String KEY_CARD_DATA = "card_data_payment_details_wrapper";
    public static final String KEY_AVS_DATA = "avs_data_details_wrapper_scheme";
    public static final String KEY_EBT_VOUCHER_NUMBER = "ebt_voucher_number_wrapper";
    public static final String KEY_EBT_AUTHORIZATION_CODE = "ebt_authorization_code_wrapper";
    private final DefaultPaymentDetails wrappedDetails;

    public PaymentDetailsManualInputWrapper(DefaultPaymentDetails wrappedDetails) {
        this.wrappedDetails = wrappedDetails;
    }

    public MotoType getOrderType() {
        return this.wrappedDetails.getMotoType();
    }

    public void setOrderType(MotoType orderType) {
        this.wrappedDetails.setMotoType(orderType);
    }

    public DefaultCardData getCardData() {
        return (DefaultCardData)this.wrappedDetails.getData().get(KEY_CARD_DATA);
    }

    public void setCardData(DefaultCardData cardData) {
        this.wrappedDetails.getData().put(KEY_CARD_DATA, cardData);
    }

    public DefaultAvsDetails getAvsDetails() {
        return (DefaultAvsDetails)this.wrappedDetails.getData().get(KEY_AVS_DATA);
    }

    public void setAvsDetails(DefaultAvsDetails avsDetails) {
        this.wrappedDetails.getData().put(KEY_AVS_DATA, avsDetails);
    }

    public String getMaskedAccountNumber() {
        DefaultCardData defaultCardData = this.getCardData();
        if (defaultCardData != null) {
            return defaultCardData.getMaskedPan();
        }
        return null;
    }

    public String getSecurityCode() {
        return (String)this.wrappedDetails.getData().get("security_code_card_data_payment_details_wrapper");
    }

    public void setSecurityCode(String securityCode) {
        this.wrappedDetails.getData().put("security_code_card_data_payment_details_wrapper", securityCode);
    }

    public String getEbtVoucherNumber() {
        return (String)this.wrappedDetails.getData().get(KEY_EBT_VOUCHER_NUMBER);
    }

    public void setEbtVoucherNumber(String ebtVoucherNumber) {
        this.wrappedDetails.getData().put(KEY_EBT_VOUCHER_NUMBER, ebtVoucherNumber);
    }

    public String getEbtAuthorizationCode() {
        return (String)this.wrappedDetails.getData().get(KEY_EBT_AUTHORIZATION_CODE);
    }

    public void setEbtAuthorizationCode(String ebtAuthorizationCode) {
        this.wrappedDetails.getData().put(KEY_EBT_AUTHORIZATION_CODE, ebtAuthorizationCode);
    }

    public void mergeWithPaymentsManualWrapper(PaymentDetailsManualInputWrapper other) {
        if (other == null) {
            return;
        }
        if (other.getCardData() != null) {
            this.setCardData(other.getCardData());
        }
        if (other.getAvsDetails() != null) {
            this.setAvsDetails(other.getAvsDetails());
        }
        if (other.getSecurityCode() != null) {
            this.setSecurityCode(other.getSecurityCode());
        }
        if (other.getEbtVoucherNumber() != null) {
            this.setEbtVoucherNumber(other.getEbtVoucherNumber());
        }
        if (other.getEbtAuthorizationCode() != null) {
            this.setEbtAuthorizationCode(other.getEbtAuthorizationCode());
        }
    }

    public boolean isCardDataValid() {
        DefaultCardData defaultCardData = this.getCardData();
        return defaultCardData != null && defaultCardData.getSred() != null && defaultCardData.getKsn() != null && !defaultCardData.getSred().isEmpty() && !defaultCardData.getKsn().isEmpty();
    }
}

