/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.shared.paymentdetails.DefaultPaymentDetails;

public class PaymentDetailsSignatureWrapper {
    public static final String KEY_SIGNATURE = "signature_payment_details_wrapper_signature";
    public static final String KEY_SIGNATURE_TYPE = "signature_payment_details_wrapper_type";
    DefaultPaymentDetails wrappedDetails;

    public PaymentDetailsSignatureWrapper(DefaultPaymentDetails wrappedDetails) {
        if (wrappedDetails == null) {
            throw new IllegalArgumentException("wrappedDetails must not be null");
        }
        this.wrappedDetails = wrappedDetails;
    }

    public byte[] getSignature() {
        return (byte[])this.wrappedDetails.getData().get(KEY_SIGNATURE);
    }

    public void setSignature(byte[] signature) {
        this.wrappedDetails.getData().put(KEY_SIGNATURE, signature);
    }

    public SignatureType getType() {
        String string = (String)this.wrappedDetails.getData().get(KEY_SIGNATURE_TYPE);
        if (string != null) {
            return SignatureType.valueOf(string);
        }
        return SignatureType.UNKNOWN;
    }

    public void setType(SignatureType type) {
        this.wrappedDetails.getData().put(KEY_SIGNATURE_TYPE, type.toString());
    }

    public void mergeWithPaymentDetailsSignatureWrapper(PaymentDetailsSignatureWrapper other) {
        if (other == null) {
            return;
        }
        if (other.getType() != null && other.getType() != SignatureType.UNKNOWN) {
            this.setType(other.getType());
        }
        if (other.getSignature() != null) {
            this.setSignature(other.getSignature());
        }
    }

    public static enum SignatureType {
        UNKNOWN,
        DIGITAL,
        ON_RECEIPT,
        SKIPPED;

    }
}

