/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.processors.payworks.services.response.dto.mappers;

import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendEbtDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendEbtDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSourceSerializer;
import io.mpos.shared.transactions.DefaultEbtDetails;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.Currency;
import io.mpos.transactions.EbtDetails;
import io.mpos.transactions.parameters.EbtCategory;
import io.mpos.transactions.parameters.EbtWorkflowConfiguration;
import io.mpos.transactions.parameters.WorkflowConfiguration;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lio/mpos/shared/processors/payworks/services/response/dto/mappers/EbtMapper;", "", "<init>", "()V", "createEbtData", "Lio/mpos/shared/processors/payworks/services/response/dto/BackendEbtDataDTO;", "transaction", "Lio/mpos/shared/transactions/DefaultTransaction;", "createEbtDetails", "Lio/mpos/transactions/EbtDetails;", "ebtDetailsDTO", "Lio/mpos/shared/processors/payworks/services/response/dto/BackendEbtDetailsDTO;", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nEbtMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EbtMapper.kt\nio/mpos/shared/processors/payworks/services/response/dto/mappers/EbtMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class EbtMapper {
    @NotNull
    public final BackendEbtDataDTO createEbtData(@NotNull DefaultTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
        PaymentDetails paymentDetails = transaction.getPaymentDetails();
        Intrinsics.checkNotNull((Object)paymentDetails);
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)paymentDetails;
        PaymentDetailsSourceSerializer.getInstance().serialize((Enum)defaultPaymentDetails.getSource());
        PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
        WorkflowConfiguration workflowConfiguration = transaction.getWorkflowConfiguration();
        EbtWorkflowConfiguration ebtWorkflowConfiguration = workflowConfiguration instanceof EbtWorkflowConfiguration ? (EbtWorkflowConfiguration)workflowConfiguration : null;
        if (ebtWorkflowConfiguration == null) {
            throw new IllegalStateException("EbtWorkflowConfiguration required when creating EBT card data".toString());
        }
        EbtWorkflowConfiguration ebtWorkflowConfiguration2 = ebtWorkflowConfiguration;
        return ebtWorkflowConfiguration2.isVoucher() ? new BackendEbtDataDTO(ebtWorkflowConfiguration2.isVoucher(), ebtWorkflowConfiguration2.isBalanceInquiry(), ebtWorkflowConfiguration2.getCategory(), paymentDetailsManualInputWrapper.getEbtVoucherNumber(), paymentDetailsManualInputWrapper.getEbtAuthorizationCode()) : new BackendEbtDataDTO(ebtWorkflowConfiguration2.isVoucher(), ebtWorkflowConfiguration2.isBalanceInquiry(), ebtWorkflowConfiguration2.getCategory(), null, null, 24, null);
    }

    @NotNull
    public final EbtDetails createEbtDetails(@NotNull BackendEbtDetailsDTO ebtDetailsDTO) {
        DefaultEbtDetails defaultEbtDetails;
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)ebtDetailsDTO, (String)"");
            defaultEbtDetails = new DefaultEbtDetails();
            EbtCategory ebtCategory = ebtDetailsDTO.getCategory();
            if (ebtCategory != null) {
                object = ebtCategory;
                defaultEbtDetails.setCategory((EbtCategory)object);
            }
            String string = ebtDetailsDTO.getVoucherNumber();
            if (string != null) {
                object = string;
                defaultEbtDetails.setVoucherNumber((String)object);
            }
            BigDecimal bigDecimal = ebtDetailsDTO.getCurrentBalance();
            if (bigDecimal != null) {
                object = bigDecimal;
                defaultEbtDetails.setCurrentBalance((BigDecimal)object);
            }
            Currency currency = ebtDetailsDTO.getCurrency();
            if (currency == null) break block3;
            object = currency;
            defaultEbtDetails.setCurrency((Currency)object);
        }
        return defaultEbtDetails;
    }
}

