/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.processors.payworks.services.response.dto.mappers;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.mapper.MapperExtensionsKt;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGiftCardDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGiftCardDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.CurrencySerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSourceSerializer;
import io.mpos.shared.transactions.DefaultGiftCardDetails;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.Currency;
import io.mpos.transactions.GiftCardDetails;
import org.jetbrains.annotations.NotNull;

public class GiftCardMapper {
    public BackendGiftCardDataDTO createGiftCardData(DefaultTransaction transaction) {
        BackendGiftCardDataDTO backendGiftCardDataDTO = new BackendGiftCardDataDTO();
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        String string = PaymentDetailsSourceSerializer.getInstance().serialize(defaultPaymentDetails.getSource());
        backendGiftCardDataDTO.setMode(string);
        backendGiftCardDataDTO.setScheme(MapperExtensionsKt.toBackendPaymentDetailsSchemeDTO((PaymentDetailsScheme)defaultPaymentDetails.getScheme()));
        if (defaultPaymentDetails.sourceHasMagstripeData()) {
            PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
            if (paymentDetailsMagstripeWrapper.getMagstripeInformation() != null) {
                backendGiftCardDataDTO.setMaskedAccountNumber(paymentDetailsMagstripeWrapper.getMagstripeInformation().getMaskedAccountNumber());
                backendGiftCardDataDTO.setMaskedTrack2(paymentDetailsMagstripeWrapper.getMagstripeInformation().getMaskedTrack2());
            }
            backendGiftCardDataDTO.setSecurityCode(paymentDetailsMagstripeWrapper.getSecurityCode());
        } else if (defaultPaymentDetails.sourceHasManualData()) {
            PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
            if (paymentDetailsManualInputWrapper.getCardData() != null) {
                backendGiftCardDataDTO.setMaskedAccountNumber(paymentDetailsManualInputWrapper.getCardData().getMaskedPan());
            }
            backendGiftCardDataDTO.setSecurityCode(paymentDetailsManualInputWrapper.getSecurityCode());
        }
        return backendGiftCardDataDTO;
    }

    @NotNull
    public GiftCardDetails createGiftCardDetails(BackendGiftCardDetailsDTO giftCardDetailsDTO) {
        DefaultGiftCardDetails defaultGiftCardDetails = new DefaultGiftCardDetails();
        defaultGiftCardDetails.setCurrentBalance(giftCardDetailsDTO.getCurrentBalance());
        defaultGiftCardDetails.setPreviousBalance(giftCardDetailsDTO.getPreviousBalance());
        defaultGiftCardDetails.setCurrency((Currency)CurrencySerializer.getInstance().deserialize(giftCardDetailsDTO.getCurrency()));
        defaultGiftCardDetails.setExpiryDate(giftCardDetailsDTO.getExpiryDate());
        return defaultGiftCardDetails;
    }
}

