/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.accessories.Accessory;
import io.mpos.core.common.obfuscated.at;
import io.mpos.core.common.obfuscated.av;
import io.mpos.core.common.obfuscated.cA;
import io.mpos.core.common.obfuscated.cB;
import io.mpos.core.common.obfuscated.cc;
import io.mpos.core.common.obfuscated.cz;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.platform.LocalizationToolbox;
import io.mpos.platform.PlatformToolkit;
import io.mpos.platform.SettableLocalizationToolbox;
import io.mpos.provider.ProviderMode;
import io.mpos.provider.ProviderWithServerSubsystem;
import io.mpos.provider.listener.AbortTransactionListener;
import io.mpos.provider.listener.AccessoryComponentListener;
import io.mpos.provider.listener.AccessoryConnectionStateListener;
import io.mpos.provider.listener.AccessoryProvisionListener;
import io.mpos.provider.listener.AccessoryUpdateListener;
import io.mpos.provider.listener.CaptureTransactionListener;
import io.mpos.provider.listener.IncrementalAuthorizationTransactionListener;
import io.mpos.provider.listener.ProviderComponentListener;
import io.mpos.provider.listener.QueryTransactionsListener;
import io.mpos.provider.listener.RefundTransactionListener;
import io.mpos.provider.listener.SendCustomerReceiptListener;
import io.mpos.provider.listener.TipAdjustTransactionListener;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.provider.listener.TransactionLookupWithSessionIdentifierListener;
import io.mpos.provider.listener.TransactionLookupWithTransactionIdentifierListener;
import io.mpos.provider.listener.TransactionRegisterListener;
import io.mpos.shared.accessories.AbstractAccessory;
import io.mpos.shared.cache.WhitelistCache;
import io.mpos.shared.cache.WhitelistMemoryCache;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.processors.OfflineTransactionProcessor;
import io.mpos.shared.processors.OnlineTransactionProcessor;
import io.mpos.shared.provider.configuration.OfflineConfiguration;
import io.mpos.shared.provider.configuration.OnlineConfiguration;
import io.mpos.shared.provider.listener.InternalEventQueue;
import io.mpos.shared.receipt.ReceiptLocalization;
import io.mpos.transactions.TransactionAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProvider
implements ProviderWithServerSubsystem {
    private static final String DEFAULT_LOGGER_KEY = "DEFAULT_LOGGER";
    protected EnumSet<TransactionAction> mSupportedActions = EnumSet.noneOf(TransactionAction.class);
    protected ProviderMode mProviderMode;
    protected final Set<Accessory> mAccessories = Collections.synchronizedSet(new HashSet());
    protected SettableLocalizationToolbox mLocalizationToolbox;
    protected PlatformToolkit mPlatformToolkit;
    protected OnlineTransactionProcessor mTransactionProcessor;
    protected OfflineTransactionProcessor mOfflineTransactionProcessor;
    protected at mAccessoryProcessor;
    protected at mOfflineAccessoryProcessor;
    protected av mTransactionQueryProcessor;
    protected av mOfflineTransactionQueryProcessor;
    protected WhitelistCache mWhitelistCache;
    protected OnlineConfiguration mOnlineConfiguration;
    protected OfflineConfiguration mOfflineConfiguration;
    protected InternalEventQueue mInternalEventQueue;
    protected ReceiptLocalization receiptLocalization;
    protected cB mReceiptFactory;
    protected cc receiptParameters;
    public static Locale sLocale;

    public AbstractProvider(PlatformToolkit platformToolkit) throws MposRuntimeException {
        this.mInternalEventQueue = new InternalEventQueue(platformToolkit.getEventDispatcher());
        sLocale = platformToolkit.getDeviceInformation().getLocale();
        AssetsHandler.init(platformToolkit.getAssetsLoader());
        this.mLocalizationToolbox = platformToolkit.getLocalizationToolbox();
        this.mPlatformToolkit = platformToolkit;
        this.mWhitelistCache = new WhitelistMemoryCache(20L * Helper.MILLISECONDS_PER_MINUTE);
    }

    public abstract void internalReactToAccessoryDisconnect(AbstractAccessory var1);

    @Override
    public EnumSet<TransactionAction> getSupportedActions() {
        return this.mSupportedActions;
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        if (locale == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "locale should not be null"));
        }
        sLocale = locale;
        this.receiptLocalization = new cA(AssetsHandler.getInstance()).a(sLocale);
        this.mReceiptFactory = new cz(sLocale, this.receiptLocalization, this.mOfflineConfiguration);
        this.mLocalizationToolbox.setLocale(locale);
        this.receiptParameters.a(locale);
    }

    @Override
    public ProviderMode getProviderMode() {
        return this.mProviderMode;
    }

    public Set<Accessory> getAccessories() {
        Set<Accessory> set;
        Set<Accessory> set2 = this.mAccessories;
        synchronized (set2) {
            set = this.mAccessories;
        }
        return set;
    }

    @Override
    public LocalizationToolbox getLocalizationToolbox() {
        return this.mLocalizationToolbox;
    }

    public Locale getLocale() {
        return sLocale;
    }

    public ReceiptLocalization getReceiptLocalization() {
        return this.receiptLocalization;
    }

    public PlatformToolkit getPlatformToolkit() {
        return this.mPlatformToolkit;
    }

    public OnlineTransactionProcessor getTransactionProcessor() {
        return this.mTransactionProcessor;
    }

    public OfflineTransactionProcessor getOfflineTransactionProcessor() {
        return this.mOfflineTransactionProcessor;
    }

    public at getAccessoryProcessor() {
        return this.mAccessoryProcessor;
    }

    protected void addAccessory(Accessory accessory) {
        this.mAccessories.add(accessory);
    }

    protected void removeAccessory(Accessory accessory) {
        this.mAccessories.remove(accessory);
    }

    public OnlineConfiguration getOnlineConfiguration() {
        return this.mOnlineConfiguration;
    }

    @Override
    public void addTransactionListener(TransactionListener transactionListener) {
        if (transactionListener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionListener(transactionListener);
    }

    @Override
    public void removeTransactionListener(TransactionListener transactionListener) {
        this.mInternalEventQueue.removeTransactionListener(transactionListener);
    }

    @Override
    public void addTransactionRegisterListener(TransactionRegisterListener transactionRegisterListener) {
        if (transactionRegisterListener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionRegisterListener(transactionRegisterListener);
    }

    @Override
    public void removeTransactionRegisterListener(TransactionRegisterListener transactionRegisterListener) {
        this.mInternalEventQueue.removeTransactionRegisterListener(transactionRegisterListener);
    }

    @Override
    public void addTransactionLookupWithSessionIdentifierListener(TransactionLookupWithSessionIdentifierListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionLookupWithSessionIdentifierListener(listener);
    }

    @Override
    public void removeTransactionLookupWithSessionIdentifierListener(TransactionLookupWithSessionIdentifierListener listener) {
        this.mInternalEventQueue.removeTransactionLookupWithSessionIdentifierListener(listener);
    }

    @Override
    public void addTransactionLookupWithTransactionIdentifierListener(TransactionLookupWithTransactionIdentifierListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionLookupWithTransactionIdentifierListener(listener);
    }

    @Override
    public void removeTransactionLookupWithTransactionIdentifierListener(TransactionLookupWithTransactionIdentifierListener listener) {
        this.mInternalEventQueue.removeTransactionLookupWithTransactionIdentifierListener(listener);
    }

    @Override
    public void addTransactionRefundListener(RefundTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionRefundListener(listener);
    }

    @Override
    public void removeTransactionRefundListener(RefundTransactionListener listener) {
        this.mInternalEventQueue.removeTransactionRefundListener(listener);
    }

    public void addTransactionVoidingListener(AbortTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addTransactionVoidingListener(listener);
    }

    public void removeTransactionVoidingListener(AbortTransactionListener listener) {
        this.mInternalEventQueue.removeTransactionVoidingListener(listener);
    }

    @Override
    public void addCaptureTransactionListener(CaptureTransactionListener listener) {
        this.mInternalEventQueue.addCaptureTransactionListener(listener);
    }

    @Override
    public void removeCaptureTransactionListener(CaptureTransactionListener listener) {
        this.mInternalEventQueue.removeCaptureTransactionListener(listener);
    }

    @Override
    public void addAccessoryConnectionStateListener(AccessoryConnectionStateListener accessoryConnectionStateListener) {
        if (accessoryConnectionStateListener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addAccessoryConnectionStateListener(accessoryConnectionStateListener);
    }

    @Override
    public void removeAccessoryConnectionStateListener(AccessoryConnectionStateListener accessoryConnectionStateListener) {
        this.mInternalEventQueue.removeAccessoryConnectionStateListener(accessoryConnectionStateListener);
    }

    @Override
    public void addAccessoryUpdateListener(AccessoryUpdateListener accessoryUpdateListener) {
        if (accessoryUpdateListener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addAccessoryUpdateListener(accessoryUpdateListener);
    }

    @Override
    public void removeAccessoryUpdateListener(AccessoryUpdateListener accessoryUpdateListener) {
        this.mInternalEventQueue.removeAccessoryUpdateListener(accessoryUpdateListener);
    }

    @Override
    public void addAccessoryProvisionListener(AccessoryProvisionListener accessoryProvisionListener) {
        if (accessoryProvisionListener == null) {
            throw new IllegalArgumentException("The listener must not be null");
        }
        this.mInternalEventQueue.addAccessoryProvisionListener(accessoryProvisionListener);
    }

    @Override
    public void removeAccessoryProvisionListener(AccessoryProvisionListener accessoryProvisionListener) {
        this.mInternalEventQueue.removeAccessoryProvisionListener(accessoryProvisionListener);
    }

    @Override
    public void addAccessoryComponentListener(AccessoryComponentListener accessoryComponentListener) {
        this.mInternalEventQueue.addAccessoryComponentListener(accessoryComponentListener);
    }

    @Override
    public void removeAccessoryComponentListener(AccessoryComponentListener accessoryComponentListener) {
        this.mInternalEventQueue.removeAccessoryComponentListener(accessoryComponentListener);
    }

    @Override
    public void addProviderComponentListener(ProviderComponentListener providerComponentListener) {
        this.mInternalEventQueue.addProviderComponentListener(providerComponentListener);
    }

    @Override
    public void removeProviderComponentListener(ProviderComponentListener providerComponentListener) {
        this.mInternalEventQueue.removeProviderComponentListener(providerComponentListener);
    }

    @Override
    public void addSendCustomerReceiptListener(SendCustomerReceiptListener sendCustomerReceiptListener) {
        this.mInternalEventQueue.addReceiptSendListener(sendCustomerReceiptListener);
    }

    @Override
    public void removeSendCustomerReceiptListener(SendCustomerReceiptListener sendCustomerReceiptListener) {
        this.mInternalEventQueue.removeReceiptSendListener(sendCustomerReceiptListener);
    }

    @Override
    public void addQueryTransactionsListener(QueryTransactionsListener queryTransactionsListener) {
        this.mInternalEventQueue.addQueryTransactionsListener(queryTransactionsListener);
    }

    @Override
    public void removeQueryTransactionsListener(QueryTransactionsListener queryTransactionsListener) {
        this.mInternalEventQueue.removeQueryTransactionsListener(queryTransactionsListener);
    }

    @Override
    public void addTipAdjustTransactionListener(TipAdjustTransactionListener listener) {
        this.mInternalEventQueue.addTipAdjustTransactionListener(listener);
    }

    @Override
    public void removeTipAdjustTransactionListener(TipAdjustTransactionListener listener) {
        this.mInternalEventQueue.removeTipAdjustTransactionListener(listener);
    }

    @Override
    public void addIncrementalAuthorizationTransactionListener(IncrementalAuthorizationTransactionListener listener) {
        this.mInternalEventQueue.addIncrementalAuthorizationTransactionListener(listener);
    }

    @Override
    public void removeIncrementalAuthorizationTransactionListener(IncrementalAuthorizationTransactionListener listener) {
        this.mInternalEventQueue.removeIncrementalAuthorizationTransactionListener(listener);
    }

    public void hardReset() {
        this.mInternalEventQueue.reset();
    }
}

