/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.paymentdetails.PaymentDetailsSchemesContainer;
import io.mpos.specs.helper.ByteHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CardHelper {
    private static final String TAG = "CardHelper";
    private static final Pattern TRACK2_REGEX = Pattern.compile("^;?(([0-9]{6})(.*?)([0-9]{4})?[=D]([0-9]{4}|=)([0-9]{3}|=)(.*?))F?(\\?.?)?$");
    private static final Pattern ACCOUNT_NUMBER_REGEX = Pattern.compile("^([0-9]{6})(.*?)([0-9]{4})?$");
    private static final String ACCOUNT_NUMBER_MASKED_CHAR = "X";

    private static boolean isNumberInRange(int[][] rangeArray, int number) {
        for (int[] nArray : rangeArray) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 > number || number > n3) continue;
            return true;
        }
        return false;
    }

    public static boolean isSchemeCompatibleWithTrack2(PaymentDetailsScheme scheme, String track2) {
        String cfr_ignored_0 = "checking if scheme=" + scheme + " is compatible with track2=" + track2;
        String string = CardHelper.parseAccountNumberFromTrack2(track2);
        return CardHelper.isSchemeCompatibleWithAccountNumber(scheme, string);
    }

    public static boolean isSchemeCoBrandCompatibleWithTrack2(PaymentDetailsScheme scheme, String track2) {
        String cfr_ignored_0 = "checking if scheme=" + scheme + " is co-brand compatible with track2=" + track2;
        String string = CardHelper.parseAccountNumberFromTrack2(track2);
        return CardHelper.isSchemeCoBrandCompatibleWithAccountNumber(scheme, string);
    }

    public static boolean isSchemeCompatibleWithAccountNumber(PaymentDetailsScheme scheme, String accountNumber) {
        int n2 = CardHelper.firstSixDigitsFromAccountNumber(accountNumber);
        PaymentDetailsScheme paymentDetailsScheme = null;
        PaymentDetailsSchemesContainer paymentDetailsSchemesContainer = new PaymentDetailsSchemesContainer(scheme);
        int[][] nArray = paymentDetailsSchemesContainer.getBINNumberRanges();
        int[][] nArray2 = paymentDetailsSchemesContainer.getBINNumberExcludes();
        boolean bl2 = false;
        boolean bl3 = false;
        if (nArray != null) {
            bl2 = CardHelper.isNumberInRange(nArray, n2);
        }
        if (nArray2 != null) {
            bl3 = CardHelper.isNumberInRange(nArray2, n2);
        }
        if (bl2 && !bl3) {
            paymentDetailsScheme = scheme;
        }
        return paymentDetailsScheme != null;
    }

    public static boolean isSchemeCoBrandCompatibleWithAccountNumber(PaymentDetailsScheme scheme, String accountNumber) {
        int n2 = CardHelper.firstSixDigitsFromAccountNumber(accountNumber);
        PaymentDetailsSchemesContainer paymentDetailsSchemesContainer = new PaymentDetailsSchemesContainer(scheme);
        for (int n3 : paymentDetailsSchemesContainer.getMagstripeCoBrandedBins()) {
            int n4 = n2;
            if (n3 < 10000) {
                n4 /= 100;
            } else if (n3 < 100000) {
                n4 /= 10;
            }
            if (n4 != n3) continue;
            return true;
        }
        return false;
    }

    public static PaymentDetailsScheme schemeForAid(byte[] applicationIdentifier, @Nullable String accountNumber, @Nullable String track2) {
        List<PaymentDetailsScheme> list = CardHelper.schemesForAid(applicationIdentifier);
        if (list.isEmpty()) {
            return PaymentDetailsScheme.UNKNOWN;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        for (PaymentDetailsScheme paymentDetailsScheme : list) {
            if (accountNumber != null && CardHelper.isSchemeCompatibleWithAccountNumber(paymentDetailsScheme, accountNumber)) {
                return paymentDetailsScheme;
            }
            if (track2 == null || !CardHelper.isSchemeCompatibleWithTrack2(paymentDetailsScheme, track2)) continue;
            return paymentDetailsScheme;
        }
        return list.get(0);
    }

    public static List<PaymentDetailsScheme> schemesForAid(byte[] applicationIdentifier) {
        return CardHelper.schemesForAid(ByteHelper.toHexShortString(applicationIdentifier));
    }

    public static List<PaymentDetailsScheme> schemesForAid(String applicationIdentifier) {
        ArrayList<PaymentDetailsScheme> arrayList = new ArrayList<PaymentDetailsScheme>();
        for (PaymentDetailsScheme paymentDetailsScheme : PaymentDetailsSchemesContainer.getAllValidSchemes()) {
            PaymentDetailsSchemesContainer paymentDetailsSchemesContainer = new PaymentDetailsSchemesContainer(paymentDetailsScheme);
            for (String string : paymentDetailsSchemesContainer.getAids()) {
                if (string == null || !applicationIdentifier.startsWith(string)) continue;
                arrayList.add(paymentDetailsScheme);
            }
        }
        return arrayList;
    }

    public static PaymentDetailsScheme schemeForAccountNumber(String accountNumber, boolean includeCoBranded) {
        List<PaymentDetailsScheme> list = PaymentDetailsSchemesContainer.getAllValidSchemes();
        PaymentDetailsScheme paymentDetailsScheme = CardHelper.findExactBinMatch(list, accountNumber);
        if (paymentDetailsScheme != null) {
            return paymentDetailsScheme;
        }
        if (includeCoBranded) {
            for (PaymentDetailsScheme paymentDetailsScheme2 : list) {
                if (!CardHelper.isSchemeCoBrandCompatibleWithAccountNumber(paymentDetailsScheme2, accountNumber)) continue;
                return paymentDetailsScheme2;
            }
        }
        for (PaymentDetailsScheme paymentDetailsScheme2 : list) {
            if (!CardHelper.isSchemeCompatibleWithAccountNumber(paymentDetailsScheme2, accountNumber)) continue;
            return paymentDetailsScheme2;
        }
        return PaymentDetailsScheme.UNKNOWN;
    }

    private static PaymentDetailsScheme findExactBinMatch(List<PaymentDetailsScheme> schemes, String accountNumber) {
        int n2 = CardHelper.firstSixDigitsFromAccountNumber(accountNumber);
        for (PaymentDetailsScheme paymentDetailsScheme : schemes) {
            PaymentDetailsSchemesContainer paymentDetailsSchemesContainer = new PaymentDetailsSchemesContainer(paymentDetailsScheme);
            int[][] nArray = paymentDetailsSchemesContainer.getBINNumberRanges();
            if (nArray == null) continue;
            for (int[] nArray2 : nArray) {
                if (nArray2[0] != nArray2[1] || nArray2[0] != n2) continue;
                return paymentDetailsScheme;
            }
        }
        return null;
    }

    public static boolean isMaestroUkCard(String accountNumber) {
        int n2 = CardHelper.firstSixDigitsFromAccountNumber(accountNumber);
        return n2 >= 675900 && n2 <= 675999 || n2 == 676770 || n2 == 676774;
    }

    public static String nameForAID(byte[] aid, String accountNumber, String track2) {
        return CardHelper.schemeForAid(aid, accountNumber, track2).name();
    }

    private static int firstSixDigitsFromAccountNumber(String number) {
        if (number == null || number.length() < 6) {
            return 0;
        }
        Matcher matcher = ACCOUNT_NUMBER_REGEX.matcher(number);
        if (!matcher.matches()) {
            return 0;
        }
        String string = matcher.group(1);
        if (string.length() != 6) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static String parseAccountNumberFromTrack2(String track2) {
        if (track2 == null) {
            return "";
        }
        Matcher matcher = TRACK2_REGEX.matcher(track2);
        if (!matcher.matches()) {
            return "";
        }
        String string = matcher.group(2) + matcher.group(3) + (matcher.group(4) != null ? matcher.group(4) : "");
        String cfr_ignored_0 = "foundNumberFromTrack2=" + track2 + " number=" + string;
        return string;
    }

    public static String parseServiceCodeFromTrack2(String maskedTrack2) {
        if (maskedTrack2 == null) {
            return null;
        }
        Matcher matcher = TRACK2_REGEX.matcher(maskedTrack2);
        if (!matcher.matches()) {
            return null;
        }
        String string = matcher.group(6);
        String cfr_ignored_0 = "found service code=" + string;
        return string;
    }

    public static String parseExpiryDateFromTrack2(String maskedTrack2) {
        if (maskedTrack2 == null) {
            return null;
        }
        Matcher matcher = TRACK2_REGEX.matcher(maskedTrack2);
        if (!matcher.matches()) {
            return null;
        }
        String string = matcher.group(5);
        String cfr_ignored_0 = "found emv date=" + string;
        return string;
    }

    public static String maskAccountNumber(String accountNumber) {
        String cfr_ignored_0 = "generating masked number, basis is " + accountNumber;
        if (accountNumber == null) {
            return null;
        }
        Matcher matcher = ACCOUNT_NUMBER_REGEX.matcher(accountNumber);
        if (!matcher.matches()) {
            return accountNumber;
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = Helper.fillStringWithCharacter(string2.length(), ACCOUNT_NUMBER_MASKED_CHAR);
        String string4 = matcher.group(3) != null ? matcher.group(3) : "";
        String string5 = string + string3 + string4;
        String cfr_ignored_1 = "got converted to: " + string5;
        return string5;
    }

    public static String maskTrack2Data(String track2) {
        String cfr_ignored_0 = "generating masked track2, basis is " + track2;
        if (track2 == null) {
            return null;
        }
        Matcher matcher = TRACK2_REGEX.matcher(track2);
        if (!matcher.matches()) {
            return track2;
        }
        String string = matcher.group(2) + matcher.group(3) + (matcher.group(4) != null ? matcher.group(4) : "");
        String string2 = "D";
        String string3 = matcher.group(5);
        String string4 = matcher.group(6);
        String string5 = matcher.group(7);
        String string6 = Helper.fillStringWithCharacter(string5.length(), ACCOUNT_NUMBER_MASKED_CHAR);
        String string7 = CardHelper.maskAccountNumber(string);
        String string8 = string7 + string2 + string3 + string4 + string6;
        String cfr_ignored_1 = "got converted to: " + string8;
        return string8;
    }

    public static String expiryYearFromExpiryDate(String expiryDate) {
        if (expiryDate == null || expiryDate.length() != 4) {
            return null;
        }
        String string = expiryDate.substring(0, 2);
        String cfr_ignored_0 = "found expiry year :" + string + " from expiryDate" + expiryDate;
        return string;
    }

    public static String expiryMonthFromExpiryDate(String expiryDate) {
        if (expiryDate == null || expiryDate.length() != 4) {
            return null;
        }
        String string = expiryDate.substring(2);
        String cfr_ignored_0 = "found expiry year :" + string + " from expiryDate" + expiryDate;
        return string;
    }
}

