/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import bolts.Task;
import com.visa.auth.AuthJwtBoundary;
import com.visa.logger.Logger;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryUpdateRequirement;
import io.mpos.accessories.AccessoryUpdateRequirementStatus;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.core.common.obfuscated.aB;
import io.mpos.core.common.obfuscated.aF;
import io.mpos.core.common.obfuscated.aG;
import io.mpos.core.common.obfuscated.aH;
import io.mpos.core.common.obfuscated.aI;
import io.mpos.core.common.obfuscated.aL;
import io.mpos.core.common.obfuscated.aM;
import io.mpos.core.common.obfuscated.aN;
import io.mpos.core.common.obfuscated.aO;
import io.mpos.core.common.obfuscated.at;
import io.mpos.core.common.obfuscated.av;
import io.mpos.core.common.obfuscated.aw;
import io.mpos.core.common.obfuscated.bd;
import io.mpos.core.common.obfuscated.cA;
import io.mpos.core.common.obfuscated.cc;
import io.mpos.core.common.obfuscated.cx;
import io.mpos.core.common.obfuscated.cz;
import io.mpos.core.common.obfuscated.dt;
import io.mpos.core.common.obfuscated.eD;
import io.mpos.core.common.obfuscated.eH;
import io.mpos.core.common.obfuscated.eL;
import io.mpos.core.common.obfuscated.eS;
import io.mpos.core.common.obfuscated.ew;
import io.mpos.core.common.obfuscated.ex;
import io.mpos.core.common.obfuscated.ey;
import io.mpos.core.common.obfuscated.ez;
import io.mpos.core.common.obfuscated.fJ;
import io.mpos.core.common.obfuscated.fR;
import io.mpos.core.common.obfuscated.fS;
import io.mpos.core.common.obfuscated.fT;
import io.mpos.core.common.obfuscated.fU;
import io.mpos.core.common.obfuscated.fZ;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.featuretoggles.FeatureToggleManager;
import io.mpos.logger.Log;
import io.mpos.logger.live.MposLoggerUtils;
import io.mpos.logger.live.MposLoggerUtilsKt;
import io.mpos.mock.MockConfiguration;
import io.mpos.mock.MockDelay;
import io.mpos.mock.MockState;
import io.mpos.paymentdetails.PaymentDetailsFactory;
import io.mpos.platform.DeviceInformation;
import io.mpos.platform.PlatformToolkit;
import io.mpos.provider.ProviderOptions;
import io.mpos.provider.listener.AccessoryUpdateListener;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.shared.accessories.AbstractAccessory;
import io.mpos.shared.accessories.AdditionalAccessoryCapabilities;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListenerFactory;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.cache.WhitelistCache;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.accessorycomponent.AccessoryBatteryStateChangedBusEvent;
import io.mpos.shared.events.providercomponent.TransactionStateChangedBusEvent;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.helper.HardResetter;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.ParameterValidator;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.metrics.MetricsSenderBoundary;
import io.mpos.shared.paymentdetails.DefaultPaymentDetailsFactory;
import io.mpos.shared.processors.OnlineTransactionProcessor;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.processors.payworks.VoidQueue;
import io.mpos.shared.provider.AbstractProvider;
import io.mpos.shared.provider.MposDatabaseProvider;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProviderHelper;
import io.mpos.shared.provider.ProviderLocalConfiguration;
import io.mpos.shared.provider.ResourceHandler;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.provider.configuration.OfflineConfiguration;
import io.mpos.shared.provider.configuration.OnlineConfiguration;
import io.mpos.shared.provider.di.Initial;
import io.mpos.shared.provider.di.ProviderScope;
import io.mpos.shared.provider.di.component.TransactionComponent;
import io.mpos.shared.provider.listener.SubmitTransactionsBatchListener;
import io.mpos.shared.provider.listener.SynchronizeConfigurationListener;
import io.mpos.shared.storage.LegacyOfflineStorageManager;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.actionresponse.DefaultTransactionActionResponseDataFactory;
import io.mpos.shared.transactions.actionsupport.DefaultTransactionActionSupportFactory;
import io.mpos.shared.workflows.DefaultTransactionWorkflow;
import io.mpos.shared.workflows.WorkflowInteraction;
import io.mpos.transactionprovider.FilterParameters;
import io.mpos.transactionprovider.offline.OfflineModuleStatus;
import io.mpos.transactions.AbortReason;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetails;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.actionresponse.TransactionActionResponse;
import io.mpos.transactions.actionresponse.TransactionActionResponseFactory;
import io.mpos.transactions.actionsupport.TransactionActionSupport;
import io.mpos.transactions.actionsupport.TransactionActionSupportFactory;
import io.mpos.transactions.parameters.TransactionParameters;
import io.mpos.utils.ProviderModeExtensionsKt;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.functions.Function0;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProviderScope
public class DefaultProvider
extends AbstractProvider {
    private static final Logger liveLogger = MposLoggerUtilsKt.liveLogger(DefaultProvider.class);
    private final String TAG = "DefaultProvider";
    private final MockConfiguration mockConfiguration;
    private final MockDelay mockDelay;
    private final MockState mockState;
    private final DelayConfig delayConfig;
    private final MetricsSenderBoundary metricsSenderBoundary;
    private final MposDatabaseProvider databaseManager;
    private ProviderOptions mProviderOptions;
    private ResourceHandler mResourceHandler;
    protected LegacyOfflineStorageManager mStorageManager;
    private PaymentDetailsFactory mPaymentDetailsFactory;
    private TransactionActionResponseFactory mTransactionActionResponseDataFactory;
    private TransactionActionSupportFactory mTransactionActionSupportFactory;
    private final FeatureToggleManager featureToggleManager;
    private final Profiler mProfiler;
    private final bd httpServiceWrapper;
    private final Executor backgroundWorkExecutor;
    private static ProviderLocalConfiguration providerLocalConfiguration = new ProviderLocalConfiguration();
    private static boolean debugBuild = false;
    private static final int ABORT_DELAY = 100;
    private final Set<Accessory> mConnectingToAccessories = Collections.synchronizedSet(new HashSet());
    private final TransactionComponent.Builder transactionComponentBuilder;
    private final ez workflowFactory;
    private final VoidQueue voidQueue;
    private final AuthJwtBoundary authJwtBoundary;

    public DefaultProvider(MockConfiguration mockConfiguration, MockDelay mockDelay, MockState mockState, DelayConfig delayConfig, PlatformToolkit platformToolkit, @Initial ProviderOptions providerOptions, Profiler profiler, Executor backgroundWorkExecutor, bd httpServiceWrapper, FeatureToggleManager featureToggleManager, TransactionComponent.Builder transactionComponentBuilder, ez workflowFactory, MetricsSenderBoundary metricsSenderBoundary, VoidQueue voidQueue, MposDatabaseProvider databaseManager, OkHttpClient httpClient, AuthJwtBoundary authJwtBoundary) {
        super(platformToolkit);
        this.mockConfiguration = mockConfiguration;
        this.mockDelay = mockDelay;
        this.mockState = mockState;
        this.delayConfig = delayConfig;
        this.transactionComponentBuilder = transactionComponentBuilder;
        this.workflowFactory = workflowFactory;
        this.metricsSenderBoundary = metricsSenderBoundary;
        this.voidQueue = voidQueue;
        this.databaseManager = databaseManager;
        this.authJwtBoundary = authJwtBoundary;
        voidQueue.addProviderOptions(providerOptions);
        Log.i("DefaultProvider", "Created Provider using: " + providerOptions.getProviderMode());
        debugBuild = platformToolkit.isDebugBuild();
        this.mProfiler = profiler;
        this.httpServiceWrapper = httpServiceWrapper;
        this.backgroundWorkExecutor = backgroundWorkExecutor;
        this.mProviderOptions = providerOptions;
        this.mSupportedActions = providerOptions.getSupportedActions();
        this.mProviderMode = providerOptions.getProviderMode();
        DeviceInformation deviceInformation = this.mPlatformToolkit.getDeviceInformation();
        MposLoggerUtils.INSTANCE.setupLiveLogger(featureToggleManager, (Function0<Long>)((Function0)() -> 10000L), (Function0<Long>)((Function0)() -> 0L), (Function0<Integer>)((Function0)() -> 10), authJwtBoundary, (Function0<String>)((Function0)() -> ProviderModeExtensionsKt.getBaseUrl(providerOptions.getProviderMode())), (Function0<? extends OkHttpClient>)((Function0)() -> httpClient));
        this.mPaymentDetailsFactory = new DefaultPaymentDetailsFactory();
        this.mTransactionActionResponseDataFactory = new DefaultTransactionActionResponseDataFactory();
        this.mTransactionActionSupportFactory = new DefaultTransactionActionSupportFactory();
        this.mResourceHandler = new ResourceHandler();
        this.mOnlineConfiguration = new OnlineConfiguration();
        this.mOfflineConfiguration = new OfflineConfiguration();
        this.receiptLocalization = new cA(AssetsHandler.getInstance()).a(sLocale);
        this.mReceiptFactory = new cz(sLocale, this.receiptLocalization, this.mOfflineConfiguration);
        this.receiptParameters = new cc(this.getLocale(), null);
        this.mStorageManager = ProviderHelper.createStorageManager(mockConfiguration, providerOptions, deviceInformation, this, databaseManager);
        this.featureToggleManager = featureToggleManager;
        this.createAccessoryProcessors();
        this.createTransactionProcessors();
        this.createQueryProcessors();
        this.mProfiler.setProvider(this);
        this.mProfiler.setTriggerSource(Profiler.TriggerSource.PROVIDER);
        featureToggleManager.sync(providerOptions.getMerchantIdentifier(), providerOptions.getProviderMode());
    }

    @Override
    public PaymentDetailsFactory getPaymentDetailsFactory() {
        return this.mPaymentDetailsFactory;
    }

    @Override
    public TransactionActionResponseFactory getTransactionActionResponseFactory() {
        return this.mTransactionActionResponseDataFactory;
    }

    @Override
    public TransactionActionSupportFactory getTransactionActionSupportFactory() {
        return this.mTransactionActionSupportFactory;
    }

    @Override
    public void setProviderOptions(ProviderOptions providerOptions) {
        Log.i("DefaultProvider", "Changing provider options");
        this.voidQueue.addProviderOptions(providerOptions);
        this.mProviderOptions = providerOptions;
        this.mSupportedActions = providerOptions.getSupportedActions();
        this.mProviderMode = providerOptions.getProviderMode();
        this.mStorageManager = ProviderHelper.createStorageManager(this.mockConfiguration, providerOptions, this.mPlatformToolkit.getDeviceInformation(), this, this.databaseManager);
        this.mOnlineConfiguration.invalidate();
        this.mOfflineConfiguration.invalidate();
        this.mWhitelistCache.invalidate();
        this.createAccessoryProcessors();
        this.createTransactionProcessors();
        this.createQueryProcessors();
        this.featureToggleManager.sync(providerOptions.getMerchantIdentifier(), providerOptions.getProviderMode());
    }

    private void createAccessoryProcessors() {
        this.mAccessoryProcessor = ProviderHelper.createAccessoryProcessor(this.mockConfiguration, this.mockDelay, this.mOnlineConfiguration, this.mWhitelistCache, this.mPlatformToolkit.getDeviceInformation(), this, this.mProviderOptions, this.httpServiceWrapper);
        this.mOfflineAccessoryProcessor = ProviderHelper.createOfflineAccessoryProcessor(this.mockConfiguration, this.mockDelay, this.mOfflineConfiguration, this, this.mProviderOptions);
    }

    @Override
    public Accessory connectToAccessory(AccessoryParameters accessoryParameters) throws MposRuntimeException {
        String cfr_ignored_0 = "connectToAccessory(...) with accessoryParameters=" + accessoryParameters;
        Accessory accessory = this.mPlatformToolkit.createAccessory(accessoryParameters);
        final AbstractAccessory abstractAccessory = (AbstractAccessory)accessory;
        abstractAccessory.setProvider(this);
        this.mProfiler.resetFromTriggerSource(Profiler.TriggerSource.PROVIDER);
        abstractAccessory.setProfiler(this.mProfiler);
        this.mProfiler.beginMeasurement(Profiler.Category.ACCESSORY_CONNECT, "connecting to accessory '" + accessoryParameters.getAccessoryFamily().name() + "'");
        Task.call(() -> {
            this.mConnectingToAccessories.add(abstractAccessory);
            abstractAccessory.connect(new SuccessFailureListener(){

                @Override
                public void onSuccess(Object extraInfo) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_CONNECT, "connection established to accessory");
                    DefaultProvider.this.mProfiler.setAccessory(abstractAccessory);
                    DefaultProvider.this.mConnectingToAccessories.remove(abstractAccessory);
                    DefaultProvider.this.mResourceHandler.addConnectedAccessory(abstractAccessory);
                    DefaultProvider.this.addAccessory(abstractAccessory);
                    DefaultProvider.this.mInternalEventQueue.onAccessoryConnectSuccess(abstractAccessory);
                }

                @Override
                public void onFailure(MposError mposError) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.ACCESSORY_CONNECT, mposError.toString());
                    DefaultProvider.this.mConnectingToAccessories.remove(abstractAccessory);
                    DefaultProvider.this.mResourceHandler.removeConnectedAccessory(abstractAccessory);
                    DefaultProvider.this.removeAccessory(abstractAccessory);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                    DefaultProvider.this.mInternalEventQueue.onAccessoryConnectFailure(mposError);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.mConnectingToAccessories.remove(abstractAccessory);
                this.mInternalEventQueue.onAccessoryConnectFailure(new DefaultMposError(task.getError()));
            }
            return null;
        });
        return abstractAccessory;
    }

    @Override
    public void disconnectFromAccessory(final Accessory accessory) throws MposRuntimeException {
        if (accessory == null) {
            Log.w("DefaultProvider", "Can't disconnect from given accessory, it's null!");
            return;
        }
        this.mProfiler.beginMeasurement(Profiler.Category.ACCESSORY_DISCONNECT, "disconnecting from accessory '" + accessory.getAccessoryParameters().getAccessoryFamily().name() + "'");
        Task.call(() -> {
            if (this.mResourceHandler.isAccessoryInWorkflow(accessory) || this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
                this.mInternalEventQueue.onAccessoryDisconnectFailure(accessory, new DefaultMposError(ErrorType.ACCESSORY_BUSY, "Provider#cancelConnectToAccessory accessory is busy."));
            }
            ((AbstractAccessory)accessory).disconnect(new SuccessFailureListener(){

                @Override
                public void onSuccess(Object extraInfo) {
                    DefaultProvider.this.mResourceHandler.removeConnectedAccessory(accessory);
                    DefaultProvider.this.removeAccessory(accessory);
                    DefaultProvider.this.mInternalEventQueue.onAccessoryDisconnectSuccess(accessory);
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_DISCONNECT, "disconnecting from accessory was successful");
                }

                @Override
                public void onFailure(MposError mposError) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.ACCESSORY_DISCONNECT, mposError.toString());
                    DefaultProvider.this.mInternalEventQueue.onAccessoryDisconnectFailure(accessory, mposError);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.mInternalEventQueue.onAccessoryDisconnectFailure(accessory, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    @Override
    public void cancelConnectToAccessory(final Accessory accessory) {
        if (accessory == null) {
            this.mInternalEventQueue.onAccessoryCancelConnectFailure(null, new DefaultMposError(ErrorType.PARAMETER_INVALID, "Provider#cancelConnectToAccessory required an accessory"));
            return;
        }
        if (!(accessory instanceof AbstractAccessory)) {
            this.mInternalEventQueue.onAccessoryCancelConnectFailure(accessory, new DefaultMposError(ErrorType.PARAMETER_INVALID, "Provider#cancelConnectToAccessory requires an AbstractAccessory instance"));
            return;
        }
        if (this.mResourceHandler.isAccessoryInWorkflow(accessory) || this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
            this.mInternalEventQueue.onAccessoryCancelConnectFailure(accessory, new DefaultMposError(ErrorType.ACCESSORY_BUSY, "Provider#cancelConnectToAccessory accessory is busy."));
        }
        if (accessory.getConnectionState() == AccessoryConnectionState.CONNECTED) {
            this.mInternalEventQueue.onAccessoryCancelConnectFailure(accessory, new DefaultMposError(ErrorType.ACCESSORY_ERROR, "Provider#cancelConnectToAccessory accessory is already connected."));
            return;
        }
        Task.call(() -> {
            ((AbstractAccessory)accessory).disconnect(new SuccessFailureListener(){

                @Override
                public void onSuccess(Object extraInfo) {
                    DefaultProvider.this.mConnectingToAccessories.remove(accessory);
                    DefaultProvider.this.mInternalEventQueue.onAccessoryCancelConnectSuccess(accessory);
                }

                @Override
                public void onFailure(MposError error) {
                    DefaultProvider.this.mInternalEventQueue.onAccessoryCancelConnectFailure(accessory, error);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.mConnectingToAccessories.remove(accessory);
                this.mInternalEventQueue.onAccessoryCancelConnectFailure(accessory, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    @Override
    public void checkUpdateRequirementForAccessory(Accessory accessory) throws MposRuntimeException {
        this.internalCheckUpdateRequirementForAccessory(this.mAccessoryProcessor, this.mOnlineConfiguration, accessory);
    }

    public void checkUpdateRequirementForAccessoryOffline(final Accessory accessory) throws MposRuntimeException {
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.internalCheckUpdateRequirementForAccessory(DefaultProvider.this.mOfflineAccessoryProcessor, DefaultProvider.this.mOfflineConfiguration, accessory);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mInternalEventQueue.onAccessoryCheckUpdateFailure(accessory, error);
            }
        });
    }

    private void internalCheckUpdateRequirementForAccessory(at accessoryProcessor, Configuration configuration, Accessory accessory) {
        if (this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
            this.mInternalEventQueue.onAccessoryUpdateFailure(accessory, new DefaultMposError(ErrorType.ACCESSORY_BUSY));
            return;
        }
        if (!(accessory instanceof PaymentAccessory)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Only possible to check update requirement of a payment accessory."));
        }
        AbstractPaymentAccessory abstractPaymentAccessory = (AbstractPaymentAccessory)accessory;
        abstractPaymentAccessory.getDisplayModule().cancelDisplayIdleScreenAfterTimeout();
        final eD eD2 = configuration instanceof OnlineConfiguration ? this.workflowFactory.a(accessoryProcessor, abstractPaymentAccessory) : this.workflowFactory.a(abstractPaymentAccessory);
        this.mResourceHandler.attachWorkflow(eD2, accessory);
        this.mProfiler.beginMeasurement(Profiler.Category.ACCESSORY_UPDATE_CHECK, "starting update check for accessory");
        eD2.a(new AccessoryUpdateListener(){

            public void onAccessoryUpdateSuccess(Accessory accessory) {
            }

            public void onAccessoryUpdateFailure(Accessory accessory, MposError error) {
            }

            public void onAccessoryCheckUpdateSuccess(Accessory accessory, AccessoryUpdateRequirement updateRequirement) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_UPDATE_CHECK, "completed check for accessory with status '" + updateRequirement.getUpdateRequirementStatus() + "', components '" + updateRequirement.getUpdateRequirementComponents() + "'");
                DefaultProvider.this.mResourceHandler.detachWorkflow(eD2, accessory);
                DefaultProvider.this.mInternalEventQueue.onAccessoryCheckUpdateSuccess(accessory, updateRequirement);
            }

            public void onAccessoryCheckUpdateFailure(Accessory accessory, MposError error) {
                DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.ACCESSORY_UPDATE_CHECK, error.toString());
                DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                DefaultProvider.this.mResourceHandler.detachWorkflow(eD2, accessory);
                DefaultProvider.this.mInternalEventQueue.onAccessoryCheckUpdateFailure(accessory, error);
            }
        });
    }

    @Override
    public void updateAccessory(Accessory accessory) {
        this.internalUpdateAccessory(this.mAccessoryProcessor, accessory);
    }

    private void internalUpdateAccessory(at accessoryProcessor, Accessory accessory) {
        this.mProfiler.beginMeasurement(Profiler.Category.ACCESSORY_UPDATE, "starting accessory update");
        if (this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
            DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_BUSY);
            this.mProfiler.endMeasurementWithError(Profiler.Category.ACCESSORY_UPDATE, ((Object)defaultMposError).toString());
            this.mInternalEventQueue.onAccessoryUpdateFailure(accessory, defaultMposError);
            return;
        }
        if (!(accessory instanceof PaymentAccessory)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Only possible to update a payment accessory."));
        }
        AbstractPaymentAccessory abstractPaymentAccessory = (AbstractPaymentAccessory)accessory;
        abstractPaymentAccessory.getDisplayModule().cancelDisplayIdleScreenAfterTimeout();
        this.updateAccessoryAfterAuthentication(accessoryProcessor, accessory);
    }

    @Override
    public void provisionAccessory(Accessory accessory) {
        this.internalProvisionAccessory(this.mAccessoryProcessor, accessory);
    }

    private void internalProvisionAccessory(at accessoryProcessor, Accessory accessory) {
        this.mProfiler.beginMeasurement(Profiler.Category.ACCESSORY_PROVISION, "starting accessory provision");
        if (!(accessory instanceof PaymentAccessory)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Only possible to provision a payment accessory."));
        }
        accessoryProcessor.a((PaymentAccessory)accessory, new aw(){

            @Override
            public void success(PaymentAccessory paymentAccessory, Set<WhitelistAccessory> whitelist) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_PROVISION, "completed accessory provision with success");
                DefaultProvider.this.mOnlineConfiguration.setWhitelistAccessories(whitelist);
                DefaultProvider.this.mInternalEventQueue.onAccessoryProvisionSuccess(paymentAccessory);
            }

            @Override
            public void failure(PaymentAccessory paymentAccessory, MposError error) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_PROVISION, error.toString());
                DefaultProvider.this.mInternalEventQueue.onAccessoryProvisionFailure(paymentAccessory, error);
            }
        });
    }

    @Override
    public void updateAccessoryState(Accessory accessory) {
        if (accessory == null) {
            Log.w("DefaultProvider", "Can't update the state of the given accessory, it's null!");
            return;
        }
        if (this.mResourceHandler.isAccessoryInWorkflow(accessory)) {
            Log.w("DefaultProvider", "Can't update the state of the given accessory, it's busy!");
        }
        if (this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
            Log.w("DefaultProvider", "Can't update the state of the given accessory, it's busy!");
        }
        Task.call(() -> {
            eH eH2 = this.workflowFactory.b((AbstractPaymentAccessory)accessory);
            this.mResourceHandler.attachWorkflow(eH2, accessory);
            eH2.a(GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((w2, a2) -> {
                BusProvider.getInstance().post((Object)new AccessoryBatteryStateChangedBusEvent(accessory, accessory.getBatteryState(), accessory.getBatteryLevel()));
                this.mResourceHandler.detachWorkflow((ew)w2, (Accessory)a2);
            }, (w2, error) -> {
                Log.w("DefaultProvider", "Can't update the state of the given accessory error=" + error);
                this.mResourceHandler.detachWorkflow((ew)w2, accessory);
            }));
            return null;
        }, (Executor)this.backgroundWorkExecutor);
    }

    private void updateAccessoryAfterAuthentication(at accessoryProcessor, Accessory accessory) {
        eD eD2 = this.workflowFactory.a(accessoryProcessor, (AbstractPaymentAccessory)accessory);
        final eL eL2 = this.workflowFactory.a(accessoryProcessor, (AbstractPaymentAccessory)accessory, eD2);
        this.mResourceHandler.attachWorkflow(eL2, accessory);
        eL2.a(new AccessoryUpdateListener(){

            public void onAccessoryUpdateSuccess(Accessory accessory) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.ACCESSORY_UPDATE, "accessory updated");
                DefaultProvider.this.mResourceHandler.detachWorkflow(eL2, accessory);
                DefaultProvider.this.mInternalEventQueue.onAccessoryUpdateSuccess(accessory);
            }

            public void onAccessoryUpdateFailure(Accessory accessory, MposError error) {
                DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.ACCESSORY_UPDATE, error.toString());
                DefaultProvider.this.mResourceHandler.detachWorkflow(eL2, accessory);
                DefaultProvider.this.mInternalEventQueue.onAccessoryUpdateFailure(accessory, error);
            }

            public void onAccessoryCheckUpdateSuccess(Accessory accessory, AccessoryUpdateRequirement updateRequirement) {
            }

            public void onAccessoryCheckUpdateFailure(Accessory accessory, MposError error) {
            }
        });
    }

    @Override
    public void registerTransaction(TransactionParameters transactionParameters) throws MposRuntimeException {
        this.internalRegisterTransaction(this.mTransactionProcessor, transactionParameters);
    }

    public void registerTransactionOffline(final TransactionParameters transactionParameters) throws MposRuntimeException {
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.internalRegisterTransaction(DefaultProvider.this.mOfflineTransactionProcessor, transactionParameters);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mInternalEventQueue.onTransactionRegisterFailure(error);
            }
        });
    }

    private void internalRegisterTransaction(TransactionProcessor transactionProcessor, TransactionParameters transactionParameters) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_REGISTRATION, "registering transaction");
            transactionProcessor.registerTransaction(transactionParameters, this.getConnectedAccessory().getAccessoryDetails(), new aI(){

                @Override
                public void success(BaseTransaction transaction, AdditionalAccessoryCapabilities additionalAccessoryCapabilities) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_REGISTRATION, "registered " + transaction.getMode().name() + " transaction with id '" + transaction.getIdentifier());
                    DefaultProvider.this.mProfiler.setTransaction(transaction);
                    DefaultProvider.this.mInternalEventQueue.onTransactionRegisterSuccess(transaction);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REGISTRATION, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onTransactionRegisterFailure(error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REGISTRATION, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onTransactionRegisterFailure(defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void lookupTransactionWithSessionIdentifier(String identifier) throws MposRuntimeException {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(identifier), Arrays.asList("identifier"));
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "staring transaction lookup with session identifier '" + identifier + "'");
            String string = this.getConnectedAccessorySerialNumber();
            this.mTransactionProcessor.lookupTransactionWithSessionIdentifier(identifier, string, new aG(){

                @Override
                public void success(String identifier1, BaseTransaction transaction, AdditionalAccessoryCapabilities additionalAccessoryCapabilities) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "transaction with session identifier found, transaction identifier '" + transaction.getIdentifier() + "'");
                    DefaultProvider.this.mProfiler.setTransaction(transaction);
                    DefaultProvider.this.mInternalEventQueue.onTransactionLookupWithSessionIdentifierSuccess(identifier1, transaction);
                }

                @Override
                public void failure(String identifier1, MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onTransactionLookupWithSessionIdentifierFailure(identifier1, error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onTransactionLookupWithSessionIdentifierFailure(identifier, defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    private String getConnectedAccessorySerialNumber() {
        Accessory accessory = this.getConnectedAccessory();
        if (accessory != null && accessory.getAccessoryDetails() != null) {
            return accessory.getAccessoryDetails().getSerialNumber();
        }
        return "";
    }

    private Accessory getConnectedAccessory() {
        Accessory accessory = null;
        HashSet<Accessory> hashSet = new HashSet<Accessory>();
        for (Accessory accessory2 : this.getAccessories()) {
            if (!this.mResourceHandler.isConnected(accessory2)) continue;
            hashSet.add(accessory2);
            accessory = accessory2;
        }
        if (hashSet.size() != 1) {
            Log.w("DefaultProvider", String.format("Found %d connected accessories, expected 1. Log extraction might not work properly", hashSet.size()));
        }
        return accessory;
    }

    @Override
    public void lookupTransactionWithTransactionIdentifier(String identifier) throws MposRuntimeException {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(identifier), Arrays.asList("identifier"));
        this.internalLookupTransactionWithTransactionIdentifier(this.mTransactionQueryProcessor, identifier);
    }

    public void lookupTransactionWithTransactionIdentifierOffline(final String identifier) throws MposRuntimeException {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(identifier), Arrays.asList("identifier"));
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.internalLookupTransactionWithTransactionIdentifier(DefaultProvider.this.mOfflineTransactionQueryProcessor, identifier);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mInternalEventQueue.onTransactionLookupWithTransactionIdentifierFailure(identifier, error);
            }
        });
    }

    private void internalLookupTransactionWithTransactionIdentifier(av transactionQueryProcessor, String identifier) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "staring transaction lookup with transaction identifier '" + identifier + "'");
            String string = this.getConnectedAccessorySerialNumber();
            transactionQueryProcessor.a(identifier, string, new aG(){

                @Override
                public void success(String identifier1, BaseTransaction transaction, AdditionalAccessoryCapabilities additionalAccessoryCapabilities) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "transaction with transaction identifier found, transaction identifier '" + transaction.getIdentifier() + "'");
                    DefaultProvider.this.mProfiler.setTransaction(transaction);
                    DefaultProvider.this.mInternalEventQueue.onTransactionLookupWithTransactionIdentifierSuccess(identifier1, transaction);
                }

                @Override
                public void failure(String identifier1, MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onTransactionLookupWithTransactionIdentifierFailure(identifier1, error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onTransactionLookupWithTransactionIdentifierFailure(identifier, defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void startTransaction(BaseTransaction transaction, Accessory accessory) throws MposRuntimeException {
        liveLogger.info("Starting transaction", Collections.emptyMap());
        this.featureToggleManager.sync(this.mProviderOptions.getMerchantIdentifier(), this.mProviderOptions.getProviderMode());
        Task.call(() -> {
            this.startTransaction_queued(transaction, accessory);
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.returnTransactionFailure(transaction, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    public void invalidateCache() {
        this.mWhitelistCache.invalidate();
    }

    private void startTransaction_queued(BaseTransaction transaction, Accessory accessory) throws MposRuntimeException {
        Log.i("DefaultProvider", "checking transaction preconditions");
        this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING, "starting processing transaction");
        if (!(accessory instanceof PaymentAccessory)) {
            this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.ACCESSORY_ERROR));
            return;
        }
        if (this.mResourceHandler.isAccessoryInWorkflow(accessory)) {
            this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.ACCESSORY_BUSY));
            return;
        }
        if (this.mResourceHandler.isAccessoryUsedForTransaction(accessory)) {
            this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.ACCESSORY_BUSY));
            return;
        }
        if (!this.mResourceHandler.canTransaction(transaction, accessory)) {
            this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.ACCESSORY_BUSY));
            return;
        }
        DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
        this.mResourceHandler.attachTransaction(transaction, accessory);
        defaultTransaction.setAccessory((AbstractPaymentAccessory)accessory);
        defaultTransaction.setProvider(this);
        defaultTransaction.getAccessory().resetGlobalStateBeforeTransaction();
        defaultTransaction.getAccessory().getDisplayModule().cancelDisplayIdleScreenAfterTimeout();
        if (transaction.getMode() == TransactionMode.OFFLINE) {
            this.startTransactions_checkOfflineProcessingEnabled(defaultTransaction);
        } else {
            TransactionType transactionType = transaction.getType();
            if (((DefaultTransaction)transaction).getWorkflow() == TransactionWorkflowType.GIFT_CARD && Helper.isInEnum(transactionType, TransactionType.ACTIVATION, TransactionType.BALANCE_INQUIRY, TransactionType.CHARGE, TransactionType.CASHOUT)) {
                this.startTransaction_withoutResolveCard(defaultTransaction, this.mOnlineConfiguration);
            } else {
                this.startTransaction_checkUpdateRequirementsAndWhitelist(defaultTransaction, this.mOnlineConfiguration);
            }
        }
    }

    private void startTransactions_checkOfflineProcessingEnabled(final DefaultTransaction transaction) {
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.startTransaction_checkUpdateRequirementsAndWhitelist(transaction, DefaultProvider.this.mOfflineConfiguration);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.returnTransactionFailure(transaction, error);
            }
        });
    }

    private void checkOfflineProcessingEnabled(io.mpos.shared.util.SuccessFailureListener<Configuration> listener) {
        fR fR2 = new fR(this.mOfflineConfiguration, this.mStorageManager.getConfigurationStorage());
        fR2.a(listener);
    }

    private void startTransaction_checkUpdateRequirementsAndWhitelist(final DefaultTransaction transaction, final Configuration configuration) {
        Log.i("DefaultProvider", "checking update requirement");
        at at2 = this.getAccessoryProcessor(transaction);
        AbstractPaymentAccessory abstractPaymentAccessory = transaction.getAccessory();
        final eD eD2 = configuration instanceof OnlineConfiguration ? this.workflowFactory.a(at2, abstractPaymentAccessory) : this.workflowFactory.a(abstractPaymentAccessory);
        this.mResourceHandler.attachWorkflow(eD2, abstractPaymentAccessory);
        eD2.a(new AccessoryUpdateListener(){

            public void onAccessoryUpdateSuccess(Accessory accessory) {
            }

            public void onAccessoryUpdateFailure(Accessory accessory, MposError error) {
            }

            public void onAccessoryCheckUpdateSuccess(Accessory accessory, AccessoryUpdateRequirement updateRequirement) {
                DefaultProvider.this.mResourceHandler.detachWorkflow(eD2, accessory);
                if (updateRequirement == null) {
                    Log.w("DefaultProvider", "accessory update did not produce the desired result: (null) update requirement");
                    DefaultProvider.this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.SERVER_INVALID_RESPONSE));
                    return;
                }
                if (updateRequirement.getUpdateRequirementStatus() == AccessoryUpdateRequirementStatus.UPDATE_AVAILABLE_AND_REQUIRED) {
                    Log.w("DefaultProvider", "accessory did not pass update check");
                    DefaultProvider.this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.ACCESSORY_REQUIRES_UPDATE));
                    return;
                }
                Log.i("DefaultProvider", "accessory passed all update checks");
                DefaultProvider.this.startTransaction_resolveCard(transaction, configuration);
            }

            public void onAccessoryCheckUpdateFailure(Accessory accessory, MposError error) {
                Log.w("DefaultProvider", "accessor update check failed, either not on whitelist or server not reachable");
                DefaultProvider.this.mResourceHandler.detachWorkflow(eD2, accessory);
                DefaultProvider.this.returnTransactionFailure(transaction, error);
            }
        });
    }

    private void startTransaction_resolveCard(DefaultTransaction transaction, Configuration configuration) {
        Log.i("DefaultProvider", "resolving card");
        DefaultTransactionWorkflow defaultTransactionWorkflow = this.transactionComponentBuilder.configuration(configuration).transaction(transaction).build().defaultTransactionWorkflow();
        this.updateTransactionWorkflows(transaction, defaultTransactionWorkflow, defaultTransactionWorkflow);
        defaultTransactionWorkflow.start(transaction, new TransactionListener(){

            @Override
            public void onTransactionApproved(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionSuccess(transaction);
            }

            @Override
            public void onTransactionDeclined(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionFailure(transaction, null);
            }

            @Override
            public void onTransactionAborted(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionFailure(transaction, null);
            }

            @Override
            public void onTransactionFailure(BaseTransaction transaction, MposError error) {
                DefaultProvider.this.returnTransactionFailure(transaction, error);
            }

            @Override
            public void onTransactionActionRequired(BaseTransaction transaction, TransactionAction action, TransactionActionSupport supportData) {
                DefaultProvider.this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ACTION_REQUIRED, "action required for transaction processing '" + action.name() + "'");
                DefaultProvider.this.mInternalEventQueue.onTransactionActionRequired(transaction, action, supportData);
            }

            @Override
            public void onTransactionAbortSuccess(BaseTransaction transaction) {
            }

            @Override
            public void onTransactionAbortFailure(BaseTransaction transaction, MposError error) {
            }
        });
    }

    private void startTransaction_withoutResolveCard(DefaultTransaction transaction, Configuration configuration) {
        Log.i("DefaultProvider", "startTransaction_withoutResolveCard");
        ex ex2 = this.transactionComponentBuilder.configuration(configuration).transaction(transaction).build().paymentWorkflow();
        this.updateTransactionWorkflows(transaction, ex2, ex2);
        ex2.start(new fZ(){

            @Override
            public void onTransactionApproved(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionSuccess(transaction);
            }

            @Override
            public void onTransactionDeclined(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionFailure(transaction, null);
            }

            @Override
            public void onTransactionAborted(BaseTransaction transaction) {
                DefaultProvider.this.returnTransactionFailure(transaction, null);
            }

            @Override
            public void onTransactionFailure(BaseTransaction transaction, MposError error) {
                DefaultProvider.this.returnTransactionFailure(transaction, error);
            }
        });
    }

    @Override
    public void executeTransaction(BaseTransaction transaction, AccountParameters accountParameters) throws MposRuntimeException {
        this.mResourceHandler.attachTransaction(transaction);
        ((DefaultTransaction)transaction).setProvider(this);
        Task.call(() -> {
            eS eS2 = ProviderHelper.createAlternativeMethodTransactionWorkflow((DefaultTransaction)transaction, this.mProfiler, this.mTransactionProcessor, this.mTransactionQueryProcessor, this.delayConfig, this.getLocale(), this.voidQueue, this.getProviderOptions(), this.featureToggleManager, new TransactionListener(){

                @Override
                public void onTransactionApproved(BaseTransaction transaction1) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionApproved(transaction1);
                    DefaultProvider.this.clearTransaction((DefaultTransaction)transaction1);
                }

                @Override
                public void onTransactionDeclined(BaseTransaction transaction1) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionDeclined(transaction1);
                    DefaultProvider.this.clearTransaction((DefaultTransaction)transaction1);
                }

                @Override
                public void onTransactionAborted(BaseTransaction transaction1) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionAborted(transaction1);
                    DefaultProvider.this.clearTransaction((DefaultTransaction)transaction1);
                }

                @Override
                public void onTransactionFailure(BaseTransaction transaction1, MposError error) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionFailure(transaction1, error);
                    DefaultProvider.this.clearTransaction((DefaultTransaction)transaction1);
                }

                @Override
                public void onTransactionActionRequired(BaseTransaction transaction1, TransactionAction action, TransactionActionSupport supportData) {
                }

                @Override
                public void onTransactionAbortSuccess(BaseTransaction transaction1) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionAbortSuccess(transaction1);
                }

                @Override
                public void onTransactionAbortFailure(BaseTransaction transaction1, MposError error) {
                    DefaultProvider.this.mInternalEventQueue.onTransactionAbortFailure(transaction1, error);
                }
            });
            this.updateTransactionWorkflows((DefaultTransaction)transaction, null, eS2);
            ((DefaultTransaction)transaction).setAccessory((AbstractPaymentAccessory)this.getConnectedAccessory());
            eS2.a(accountParameters);
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.mInternalEventQueue.onTransactionFailure(null, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    private void returnTransactionSuccess(BaseTransaction transaction) {
        DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
        this.displayIdleScreen(defaultTransaction.getAccessory());
        this.clearTransaction(defaultTransaction);
        this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING, this.mProfiler.createTransactionMessage("transaction processing finished", transaction));
        DefaultProvider.logTransactionFinished(transaction);
        this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
        this.mInternalEventQueue.onTransactionApproved(transaction);
    }

    private void returnTransactionFailure(BaseTransaction transaction, MposError error) {
        DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
        this.displayIdleScreen(defaultTransaction.getAccessory());
        this.clearTransaction(defaultTransaction);
        this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING, this.mProfiler.createTransactionMessage("transaction processing finished", transaction));
        DefaultProvider.logTransactionFinished(transaction);
        if (transaction.getStatus() == TransactionStatus.DECLINED) {
            this.mInternalEventQueue.onTransactionDeclined(transaction);
        } else if (transaction.getStatus() == TransactionStatus.ABORTED) {
            this.mInternalEventQueue.onTransactionAborted(transaction);
        } else {
            this.mInternalEventQueue.onTransactionFailure(transaction, error);
        }
        this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
    }

    private void returnTransactionAbortSuccess(BaseTransaction transaction) {
        this.mInternalEventQueue.onTransactionAbortSuccess(transaction);
    }

    private void returnTransactionAbortFailure(BaseTransaction transaction, MposError error) {
        this.mInternalEventQueue.onTransactionAbortFailure(transaction, error);
    }

    private void clearTransaction(DefaultTransaction transaction) {
        boolean bl2 = transaction.canBeAborted();
        AbstractPaymentAccessory abstractPaymentAccessory = transaction.getAccessory();
        transaction.setWorkflowInteraction(null);
        transaction.setWorkflowAbort(null);
        transaction.setAccessory(null);
        transaction.setProvider(null);
        this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
        if (abstractPaymentAccessory == null) {
            this.mResourceHandler.detachTransaction(transaction);
        } else {
            this.mResourceHandler.detachTransaction(transaction, abstractPaymentAccessory);
        }
        if (bl2 != transaction.canBeAborted()) {
            BusProvider.getInstance().post((Object)new TransactionStateChangedBusEvent(transaction, transaction.getState(), transaction.canBeAborted()));
        }
    }

    private void updateTransactionWorkflows(DefaultTransaction transaction, WorkflowInteraction workflowInteraction, ey workflowAbort) {
        boolean bl2 = transaction.canBeAborted();
        transaction.setWorkflowInteraction(workflowInteraction);
        transaction.setWorkflowAbort(workflowAbort);
        if (transaction.getAccessory() != null) {
            transaction.getAccessory().setWorkflowInteraction(workflowInteraction);
        }
        if (bl2 != transaction.canBeAborted()) {
            BusProvider.getInstance().post((Object)new TransactionStateChangedBusEvent(transaction, transaction.getState(), transaction.canBeAborted()));
        }
    }

    @Override
    public void continueTransaction(BaseTransaction transaction, TransactionAction action, TransactionActionResponse data) throws MposRuntimeException {
        this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ACTION_REQUIRED, "action required completed");
        if (!this.mResourceHandler.isAnyTransactionOngoing()) {
            this.returnTransactionFailure(transaction, new DefaultMposError(new RuntimeException("there is no active transaction going on")));
            return;
        }
        Task.call(() -> {
            ((DefaultTransaction)transaction).getWorkflowInteraction().continueWithAction(action, data);
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.returnTransactionFailure(transaction, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    @Override
    public void abortTransaction(BaseTransaction transaction) throws MposRuntimeException {
        this.abortTransaction(transaction, AbortReason.MERCHANT_ABORTED);
    }

    @Override
    public void abortTransaction(BaseTransaction transaction, AbortReason abortReason) throws MposRuntimeException {
        CompletableFuture.runAsync(() -> {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException);
            }
        }).thenRun(() -> this.abortTransactionWithReason(transaction, abortReason));
    }

    @Override
    public void abortTransaction(String sessionIdentifier, AbortReason reason) {
        this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "starting merchant abort transaction using session identifier");
        this.mTransactionProcessor.voidTransaction(sessionIdentifier, this.getLocale(), reason, new aM(){

            @Override
            public void success(BaseTransaction transaction) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "merchant abort completed");
                DefaultProvider.this.mInternalEventQueue.onTransactionAbortSuccess();
            }

            @Override
            public void failure(BaseTransaction transaction, MposError error) {
                DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING_ABORT, error.toString());
                DefaultProvider.this.mInternalEventQueue.onTransactionAbortFailure(error);
            }
        });
    }

    private void abortTransactionWithReason(final BaseTransaction transaction, AbortReason abortReason) {
        if (this.isTransactionNotOngoingButInitialized(transaction)) {
            cx.a(abortReason, (DefaultTransaction)transaction);
            this.abortInitializedTransaction(transaction);
            return;
        }
        if (!this.mResourceHandler.isAnyTransactionOngoing()) {
            this.returnTransactionFailure(transaction, new DefaultMposError(new RuntimeException("there is no active transaction going on")));
            return;
        }
        if (abortReason != AbortReason.MERCHANT_ABORTED) {
            this.returnTransactionAbortFailure(transaction, new DefaultMposError(ErrorType.PARAMETER_INVALID, "transaction already started, only AbortReason.MERCHANT_ABORTED allowed at this point"));
            return;
        }
        Task.call(() -> {
            final DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
            ey ey2 = defaultTransaction.getWorkflowAbort();
            if (ey2 == null) {
                this.returnTransactionFailure(transaction, new DefaultMposError(ErrorType.TRANSACTION_INVALID, "transaction has no abort workflow"));
                return null;
            }
            String cfr_ignored_0 = "starting abort: " + defaultTransaction.getWorkflowAbort();
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "starting merchant abort transaction");
            ey2.abort(new fJ(){

                @Override
                public void success() {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "merchant abort completed");
                    DefaultProvider.this.returnTransactionAbortSuccess(defaultTransaction);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING_ABORT, error.toString());
                    DefaultProvider.this.returnTransactionAbortFailure(transaction, error);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.returnTransactionFailure(transaction, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    private boolean isTransactionNotOngoingButInitialized(BaseTransaction transaction) {
        return transaction.getStatus() == TransactionStatus.INITIALIZED && ((DefaultTransaction)transaction).getWorkflowAbort() == null && !this.mResourceHandler.isOngoing(transaction);
    }

    private void abortInitializedTransaction(BaseTransaction transaction) {
        this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "starting merchant abort transaction");
        TransactionProcessor transactionProcessor = this.getTransactionProcessor(transaction);
        transactionProcessor.voidTransaction(transaction, this.getLocale(), new aM(){

            @Override
            public void success(BaseTransaction transaction) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_ABORT, "merchant abort completed");
                DefaultProvider.this.returnTransactionAbortSuccess(transaction);
            }

            @Override
            public void failure(BaseTransaction transaction, MposError error) {
                DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_PROCESSING_ABORT, error.toString());
                DefaultProvider.this.returnTransactionAbortFailure(transaction, error);
            }
        });
    }

    @Override
    public void refundTransactionWithoutCard(final TransactionParameters transactionParameters) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_REFUND, "starting transaction refund without card, referenced transaction identifier '" + transactionParameters.getReferencedTransactionIdentifier() + "'");
            this.mTransactionProcessor.refundTransactionV2(transactionParameters, this.getLocale(), new aH(){

                @Override
                public void success(BaseTransaction transaction) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_REFUND, "transaction refund without card completed, transaction identifier '" + transaction.getIdentifier() + "'");
                    if (transaction.getStatus().equals((Object)TransactionStatus.APPROVED)) {
                        DefaultProvider.this.mInternalEventQueue.onRefundTransactionApproved(transaction);
                    } else if (transaction.getStatus().equals((Object)TransactionStatus.DECLINED)) {
                        DefaultProvider.this.mInternalEventQueue.onRefundTransactionDeclined(transaction);
                    } else {
                        DefaultProvider.this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, null, transaction);
                    }
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REFUND, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, error, null);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REFUND, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, defaultMposError, null);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void refundTransaction(TransactionParameters transactionParameters) throws MposRuntimeException {
        this.internalRefundTransaction(this.mTransactionProcessor, transactionParameters);
    }

    public void refundTransactionOffline(final TransactionParameters transactionParameters) throws MposRuntimeException {
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.internalRefundTransaction(DefaultProvider.this.mOfflineTransactionProcessor, transactionParameters);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, error, null);
            }
        });
    }

    private void internalRefundTransaction(TransactionProcessor transactionProcessor, final TransactionParameters transactionParameters) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_REFUND, "starting transaction refund (v2.1 method), referenced transaction identifier '" + transactionParameters.getReferencedTransactionIdentifier() + "'");
            transactionProcessor.refundTransactionV21(transactionParameters, this.getLocale(), new aH(){

                @Override
                public void success(BaseTransaction transaction) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_REFUND, "transaction refund (v2.1 method), transaction identifier '" + transaction.getIdentifier() + "'");
                    DefaultProvider.this.mInternalEventQueue.onRefundTransactionApproved(transaction);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REFUND, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, error, null);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_REFUND, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onRefundTransactionFailure(transactionParameters, defaultMposError, null);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void captureTransaction(final TransactionParameters transactionParameters) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_CAPTURE, "starting transaction capture, referenced transaction identifier '" + transactionParameters.getReferencedTransactionIdentifier() + "'");
            this.mTransactionProcessor.captureTransaction(transactionParameters, this.getLocale(), new aB(){

                @Override
                public void success(BaseTransaction transaction) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_CAPTURE, "transaction capture, transaction identifier '" + transaction.getIdentifier() + "'");
                    DefaultProvider.this.mInternalEventQueue.onCaptureTransactionApproved(transactionParameters, transaction);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_CAPTURE, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onCaptureTransactionFailure(transactionParameters, error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_CAPTURE, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onCaptureTransactionFailure(transactionParameters, defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void tipAdjustTransaction(final TransactionParameters transactionParameters) throws MposRuntimeException {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_TIP_ADJUST, "starting tip adjust on transaction, referenced transaction identifier '" + transactionParameters.getReferencedTransactionIdentifier() + "'");
            this.mTransactionProcessor.tipAdjustTransaction(transactionParameters, this.getLocale(), new aL(){

                @Override
                public void success(BaseTransaction transaction) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_TIP_ADJUST, "transaction tip adjustment, transaction identifier '" + transaction.getIdentifier() + "'");
                    DefaultProvider.this.mInternalEventQueue.onTipAdjustTransactionApproved(transactionParameters, transaction);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }

                @Override
                public void failure(MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_TIP_ADJUST, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onTipAdjustTransactionFailure(transactionParameters, error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_TIP_ADJUST, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onTipAdjustTransactionFailure(transactionParameters, defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    @Override
    public void incrementalAuthorizationTransaction(TransactionParameters transactionParameters) throws MposRuntimeException {
        this.internalIncrementalAuthorizationTransaction(this.mTransactionProcessor, transactionParameters);
    }

    private void internalIncrementalAuthorizationTransaction(OnlineTransactionProcessor transactionProcessor, TransactionParameters transactionParameters) {
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_INCREMENTAL_AUTHORIZATION, String.format("starting incremental authorization transaction, referenced transaction identifier '%s'", transactionParameters.getReferencedTransactionIdentifier()));
            transactionProcessor.incrementalAuthorizationTransaction(transactionParameters, this.getLocale(), this.createTransactionProcessorIncrementalAuthorizationListener(transactionParameters));
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> this.continueWithIncrementalAuthorizationTransactionTask(transactionParameters, (Task<Object>)task));
    }

    @NotNull
    private aF createTransactionProcessorIncrementalAuthorizationListener(final TransactionParameters transactionParameters) {
        return new aF(){

            @Override
            public void success(BaseTransaction transaction) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_INCREMENTAL_AUTHORIZATION, "Incremental authorization, transaction identifier '" + transaction.getIdentifier() + "'");
                if (transaction.getStatus().equals((Object)TransactionStatus.APPROVED)) {
                    DefaultProvider.this.mInternalEventQueue.onIncrementalAuthorizationTransactionApproved(transactionParameters, transaction);
                } else {
                    DefaultProvider.this.mInternalEventQueue.onIncrementalAuthorizationTransactionFailure(transactionParameters, transaction.getError(), transaction);
                }
                DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }

            @Override
            public void failure(MposError error) {
                DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_INCREMENTAL_AUTHORIZATION, error.toString());
                DefaultProvider.this.mInternalEventQueue.onIncrementalAuthorizationTransactionFailure(transactionParameters, error, null);
                DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
        };
    }

    @Nullable
    private Object continueWithIncrementalAuthorizationTransactionTask(TransactionParameters transactionParameters, Task<Object> task) {
        if (task.isCancelled() || task.isFaulted()) {
            DefaultMposError defaultMposError = new DefaultMposError(task.getError());
            this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_INCREMENTAL_AUTHORIZATION, ((Object)defaultMposError).toString());
            this.mInternalEventQueue.onIncrementalAuthorizationTransactionFailure(transactionParameters, defaultMposError, null);
            this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
        }
        return null;
    }

    @Override
    public void internalReactToAccessoryDisconnect(AbstractAccessory accessory) {
        ey ey2;
        Set<ew> set = this.mResourceHandler.getAttachedWorkflows(accessory);
        for (ew object2 : set) {
            if (!(object2 instanceof ey)) continue;
            ((ey)((Object)object2)).abortAsResultOfAccessoryDisconnect();
        }
        BaseTransaction baseTransaction = this.mResourceHandler.getTransactionRunningOnAccessory(accessory);
        if (!(baseTransaction == null || (ey2 = ((DefaultTransaction)baseTransaction).getWorkflowAbort()) == null || ey2 instanceof ew && set.contains(ey2))) {
            ey2.abortAsResultOfAccessoryDisconnect();
        }
    }

    @Override
    public void sendCustomerReceiptForTransaction(String transactionIdentifier, String emailAddress) {
        Task.call(() -> {
            this.internalSendCustomerReceiptForTransaction(transactionIdentifier, emailAddress);
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.mInternalEventQueue.onCustomerReceiptSendFailure(transactionIdentifier, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    private void internalSendCustomerReceiptForTransaction(String transactionIdentifier, String emailAddress) {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(transactionIdentifier, emailAddress), Arrays.asList("transactionIdentifier", "emailAddress"));
        LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(sLocale);
        this.mTransactionQueryProcessor.a(transactionIdentifier, emailAddress, new aO(){

            @Override
            public void success(String transactionIdentifier) {
                DefaultProvider.this.mInternalEventQueue.onCustomerReceiptSendSuccess(transactionIdentifier);
            }

            @Override
            public void failure(String transactionIdentifier, MposError error) {
                DefaultProvider.this.mInternalEventQueue.onCustomerReceiptSendFailure(transactionIdentifier, error);
            }
        });
    }

    @Override
    public void queryTransactions(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit) throws MposRuntimeException {
        this.internalQueryTransaction(this.mTransactionQueryProcessor, filterParameters, includeReceipts, offset, limit);
    }

    public void queryTransactionsOffline(final FilterParameters filterParameters, final boolean includeReceipts, final int offset, final int limit) throws MposRuntimeException {
        this.checkOfflineProcessingEnabled(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.internalQueryTransaction(DefaultProvider.this.mOfflineTransactionQueryProcessor, filterParameters, includeReceipts, offset, limit);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mInternalEventQueue.onQueryTransactionsFailure(filterParameters, includeReceipts, offset, limit, error);
            }
        });
    }

    private void internalQueryTransaction(av processor, FilterParameters filterParameters, boolean includeReceipts, int offset, int limit) throws MposRuntimeException {
        ParameterValidator.checkNull(Arrays.asList(filterParameters), Arrays.asList("filterParameters"));
        Task.call(() -> {
            this.mProfiler.beginMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "staring transaction query");
            processor.a(filterParameters, includeReceipts, offset, limit, new aN(){

                @Override
                public void success(FilterParameters filterParameters1, boolean includeReceipts1, int offset1, int limit1, List<BaseTransaction> transactions) {
                    DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.TRANSACTION_LOOKUP, "transaction query completed with " + transactions.size() + " returned transactions");
                    DefaultProvider.this.mInternalEventQueue.onQueryTransactionsSuccess(filterParameters1, includeReceipts1, offset1, limit1, transactions);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }

                @Override
                public void failure(FilterParameters filterParameters1, boolean includeReceipts1, int offset1, int limit1, MposError error) {
                    DefaultProvider.this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, error.toString());
                    DefaultProvider.this.mInternalEventQueue.onQueryTransactionsFailure(filterParameters1, includeReceipts1, offset1, limit1, error);
                    DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
                }
            });
            return null;
        }, (Executor)this.backgroundWorkExecutor).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                DefaultMposError defaultMposError = new DefaultMposError(task.getError());
                this.mProfiler.endMeasurementWithError(Profiler.Category.TRANSACTION_LOOKUP, ((Object)defaultMposError).toString());
                this.mInternalEventQueue.onQueryTransactionsFailure(filterParameters, includeReceipts, offset, limit, defaultMposError);
                this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
            return null;
        });
    }

    public void synchronizeConfiguration(final SynchronizeConfigurationListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("listener"));
        this.mProfiler.beginMeasurement(Profiler.Category.SYNCHRONIZE_CONFIGURATION, "synchronizing offline configuration");
        fU fU2 = new fU(this.mOfflineConfiguration, this.mStorageManager, this.getLocale(), this.mTransactionProcessor, this.mAccessoryProcessor);
        fU2.a(new io.mpos.shared.util.SuccessFailureListener<Configuration>(){

            @Override
            public void onSuccess(Configuration configuration) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.SYNCHRONIZE_CONFIGURATION, "synchronizing offline configuration completed");
                DefaultProvider.this.mOfflineConfiguration = (OfflineConfiguration)configuration;
                boolean bl2 = DefaultProvider.this.mOfflineConfiguration.getProcessingOptionsContainer().isFeatureEnabled(ProcessingOptions.Feature.OFFLINE_TRANSACTION_PROCESSING);
                OfflineModuleStatus offlineModuleStatus = bl2 ? OfflineModuleStatus.ENABLED : OfflineModuleStatus.DISABLED;
                dt dt2 = new dt(offlineModuleStatus);
                listener.onSynchronizationConfigurationSuccess(dt2);
                DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }

            @Override
            public void onFailure(MposError error) {
                DefaultProvider.this.mProfiler.endMeasurement(Profiler.Category.SYNCHRONIZE_CONFIGURATION, "synchronizing offline configuration completed");
                listener.onSynchronizationConfigurationFailure(error);
                DefaultProvider.this.mProfiler.persistFromTriggerSource(Profiler.TriggerSource.PROVIDER);
            }
        });
    }

    public void submitTransactionsBatch(SubmitTransactionsBatchListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("listener"));
        fT fT2 = new fT(this.mTransactionProcessor, this.mStorageManager.getTransactionStorage(), (transactions, error) -> {
            this.submitMetricsBatch();
            listener.onSubmitTransactionsBatchCompleted(transactions, error);
        });
        fT2.a();
    }

    private void submitMetricsBatch() {
        if (this.mResourceHandler.isMetricsSubmissionOngoing()) {
            return;
        }
        this.mResourceHandler.setMetricsSubmissionOngoing(true);
        fS fS2 = new fS(this.mTransactionProcessor, this.mStorageManager.getMetricsStorage(), error -> this.mResourceHandler.setMetricsSubmissionOngoing(false));
        fS2.a();
    }

    public void deleteStoredTransactions(final io.mpos.shared.util.SuccessFailureListener<Void> listener) {
        this.mStorageManager.getTransactionStorage().a(new io.mpos.shared.util.SuccessFailureListener<Void>(){

            @Override
            public void onSuccess(Void aVoid) {
                DefaultProvider.this.mStorageManager.reset();
                listener.onSuccess(null);
            }

            @Override
            public void onFailure(MposError error) {
                listener.onFailure(error);
            }
        });
    }

    public void deleteStoredConfigurations(final io.mpos.shared.util.SuccessFailureListener<Void> listener) {
        this.mStorageManager.getConfigurationStorage().b(new io.mpos.shared.util.SuccessFailureListener<Void>(){

            @Override
            public void onSuccess(Void aVoid) {
                DefaultProvider.this.mOfflineConfiguration.invalidate();
                listener.onSuccess(null);
            }

            @Override
            public void onFailure(MposError error) {
                listener.onFailure(error);
            }
        });
    }

    public void onUncaughtExceptionThrown() {
    }

    private void displayIdleScreen(PaymentAccessory accessory) {
        if (accessory == null || !AccessoryConnectionState.CONNECTED.equals((Object)accessory.getConnectionState())) {
            Log.w("DefaultProvider", "Trying to show an idle screen on a disconnected accessory. Ignored.");
            return;
        }
        accessory.getDisplayModule().displayIdleScreenAfterTimeout();
    }

    @Override
    public ProviderOptions getProviderOptions() {
        return this.mProviderOptions;
    }

    public ResourceHandler getResourceHandler() {
        return this.mResourceHandler;
    }

    @Override
    public void hardReset() {
        HashSet<Accessory> hashSet;
        super.hardReset();
        Set set = this.mConnectingToAccessories;
        synchronized (set) {
            hashSet = new HashSet<Accessory>(this.mConnectingToAccessories);
        }
        Set set2 = this.mAccessories;
        synchronized (set2) {
            set = this.mAccessories;
        }
        HardResetter.cancelConnectingToAccessories(hashSet);
        HardResetter.resetAndDisconnectAccessories(this.mResourceHandler, set);
        this.mResourceHandler = new ResourceHandler();
        this.mAccessories.clear();
        this.mConnectingToAccessories.clear();
        this.mOnlineConfiguration.invalidate();
        this.mOfflineConfiguration.invalidate();
        this.mWhitelistCache.invalidate();
    }

    public static void setProviderLocalConfiguration(ProviderLocalConfiguration configuration) {
        if (!debugBuild) {
            return;
        }
        providerLocalConfiguration = configuration;
    }

    public static ProviderLocalConfiguration getProviderLocalConfiguration() {
        return new ProviderLocalConfiguration(providerLocalConfiguration);
    }

    protected TransactionProcessor getTransactionProcessor(BaseTransaction transaction) {
        switch (transaction.getMode()) {
            case ONLINE: {
                return this.mTransactionProcessor;
            }
            case OFFLINE: {
                return this.mOfflineTransactionProcessor;
            }
        }
        return this.mTransactionProcessor;
    }

    private at getAccessoryProcessor(BaseTransaction transaction) {
        switch (transaction.getMode()) {
            case ONLINE: {
                return this.mAccessoryProcessor;
            }
            case OFFLINE: {
                return this.mOfflineAccessoryProcessor;
            }
        }
        return this.mAccessoryProcessor;
    }

    public Configuration getOfflineConfiguration() {
        return this.mOfflineConfiguration;
    }

    public WhitelistCache getWhitelistCache() {
        return this.mWhitelistCache;
    }

    public LegacyOfflineStorageManager getStorageManager() {
        return this.mStorageManager;
    }

    public void changeMaxReceiptLineLength(int maxReceiptLineLength) {
        this.receiptParameters.a(maxReceiptLineLength);
    }

    private void createTransactionProcessors() {
        this.mTransactionProcessor = ProviderHelper.createTransactionProcessor(this.mockConfiguration, this.mockDelay, this.mockState, this.delayConfig, this.mOnlineConfiguration, this.mWhitelistCache, this.mPlatformToolkit.getDeviceInformation(), this, this.mProviderOptions, this.httpServiceWrapper, this.receiptParameters, this.mProfiler, this.metricsSenderBoundary, this.voidQueue, this.featureToggleManager, this.databaseManager);
        this.mOfflineTransactionProcessor = ProviderHelper.createOfflineTransactionProcessor(this.mockConfiguration, this.mockDelay, this.mockState, this.delayConfig, this.mOfflineConfiguration, this, this.mStorageManager, this.mReceiptFactory, this.mProviderOptions, this.mProfiler);
    }

    private void createQueryProcessors() {
        this.mTransactionQueryProcessor = ProviderHelper.createTransactionQueryProcessor(this.mockConfiguration, this.mockDelay, this.mockState, this.mPlatformToolkit.getDeviceInformation(), this, this.mProviderOptions, this.httpServiceWrapper, this.receiptParameters, this.mProfiler);
        this.mOfflineTransactionQueryProcessor = ProviderHelper.createOfflineTransactionQueryProcessor(this.mockConfiguration, this.mockDelay, this.mockState, this, this.mStorageManager, this.mReceiptFactory, this.mProviderOptions);
    }

    @NotNull
    public FeatureToggleManager getFeatureToggleManager() {
        return this.featureToggleManager;
    }

    private static void logTransactionFinished(BaseTransaction transaction) {
        TransactionStatusDetails transactionStatusDetails;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TransactionStatus transactionStatus = transaction.getStatus();
        if (transactionStatus != null) {
            hashMap.put("transactionStatus", transactionStatus.toString());
        }
        if ((transactionStatusDetails = transaction.getStatusDetails()) != null) {
            hashMap.put("transactionStatusDetails", transactionStatusDetails.getCode().toString());
        }
        liveLogger.info("Transaction finished", hashMap);
    }
}

