/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.core.common.obfuscated.cy;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.transactions.TransactionType;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProcessingOptionsContainer {
    private static final String TAG = "ProcessingOptionsContainer";
    private final ProcessingOptions approvedOptions;
    private final ProcessingOptions blockedOptions;
    private final EnumSet<PaymentDetailsScheme> supportedSchemes;
    private final EnumSet<PaymentDetailsScheme> allowedSchemes;
    private final Map<PaymentDetailsSource, ProcessingOptions> sourceSpecificOptions = new HashMap<PaymentDetailsSource, ProcessingOptions>();
    private final Map<PaymentDetailsScheme, Map<PaymentDetailsSource, ProcessingOptions>> sourceAndSchemeSpecificOptions = new HashMap<PaymentDetailsScheme, Map<PaymentDetailsSource, ProcessingOptions>>();
    private final EnumSet<ProcessingOptions.Behavior> accessoryBehaviors = EnumSet.noneOf(ProcessingOptions.Behavior.class);
    private final EnumSet<ProcessingOptions.Feature> features = EnumSet.noneOf(ProcessingOptions.Feature.class);
    private cy aidConstraints;
    private final Map<TransactionType, Set<PaymentDetailsScheme>> blockedTransactionTypes = new HashMap<TransactionType, Set<PaymentDetailsScheme>>();

    public ProcessingOptionsContainer() {
        this.approvedOptions = this.createAllowedProcessingOptions();
        this.blockedOptions = this.createBlockedProcessingOptions();
        this.supportedSchemes = EnumSet.allOf(PaymentDetailsScheme.class);
        this.allowedSchemes = EnumSet.allOf(PaymentDetailsScheme.class);
        this.allowedSchemes.remove(PaymentDetailsScheme.GH_LINK);
        this.allowedSchemes.remove(PaymentDetailsScheme.UNION_PAY);
        this.allowedSchemes.remove(PaymentDetailsScheme.UNION_PAY_COMMON_DEBIT);
        this.aidConstraints = new cy();
    }

    public boolean isTransactionAllowed(PaymentDetailsScheme scheme, PaymentDetailsSource source, TransactionType transactionType) {
        if (!this.supportedSchemes.contains(scheme)) {
            String cfr_ignored_0 = "The SDK currently does not support the respective scheme: " + scheme;
            return false;
        }
        ProcessingOptions processingOptions = this.getProcessingOptions(scheme, source);
        if (processingOptions.getStatus() != ProcessingOptions.Status.ALLOWED) {
            String cfr_ignored_1 = "The server has blocked the usage of scheme " + scheme + " for source " + source;
            return false;
        }
        if (this.shouldBlockTransaction(scheme, transactionType)) {
            String cfr_ignored_2 = "The server has blocked the usage of scheme " + scheme + " for transaction type " + transactionType;
            return false;
        }
        String cfr_ignored_3 = "The scheme " + scheme + " using source " + source + " is supported";
        return true;
    }

    public boolean isTransactionTypeBlockedForScheme(PaymentDetailsScheme scheme, TransactionType transactionType) {
        if (this.shouldBlockTransaction(scheme, transactionType)) {
            String cfr_ignored_0 = "The server has blocked the usage of scheme " + scheme + " for transaction type " + transactionType;
            return true;
        }
        String cfr_ignored_1 = "The scheme " + scheme + " is supported";
        return false;
    }

    private boolean shouldBlockTransaction(PaymentDetailsScheme scheme, TransactionType transactionType) {
        return this.blockedTransactionTypes.containsKey(transactionType) && this.blockedTransactionTypes.get(transactionType).contains(scheme);
    }

    public boolean isSourceAllowed(PaymentDetailsSource source) {
        if (this.sourceSpecificOptions.containsKey(source)) {
            return ProcessingOptions.Status.ALLOWED.equals((Object)this.sourceSpecificOptions.get(source).getStatus());
        }
        return ProcessingOptions.Status.ALLOWED.equals((Object)this.approvedOptions.getStatus());
    }

    public boolean isFeatureEnabled(ProcessingOptions.Feature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean shouldUseDefaultCvm(PaymentDetailsScheme scheme, PaymentDetailsSource source) {
        ProcessingOptions processingOptions = this.getProcessingOptions(scheme, source);
        if (processingOptions.getCvm() != ProcessingOptions.CVM.DEFAULT) {
            String cfr_ignored_0 = "The scheme " + scheme + " using source " + source + " should use non-default CVM";
            return false;
        }
        String cfr_ignored_1 = "The scheme " + scheme + " using source " + source + " should use default CVM";
        return true;
    }

    public ProcessingOptions getProcessingOptions(PaymentDetailsScheme scheme, PaymentDetailsSource source) {
        if (this.sourceAndSchemeSpecificOptions.containsKey(scheme) && this.sourceAndSchemeSpecificOptions.get(scheme).containsKey(source)) {
            return this.sourceAndSchemeSpecificOptions.get(scheme).get(source);
        }
        if (this.sourceSpecificOptions.containsKey(source) && this.allowedSchemes.contains(scheme)) {
            return this.sourceSpecificOptions.get(source);
        }
        if (this.allowedSchemes.contains(scheme)) {
            return this.approvedOptions;
        }
        return this.blockedOptions;
    }

    public void addDefaultProcessingOptions(PaymentDetailsSource source, ProcessingOptions processingOptions) {
        this.sourceSpecificOptions.put(source, processingOptions);
    }

    public void addSchemeProcessingOptions(PaymentDetailsScheme scheme, PaymentDetailsSource source, ProcessingOptions processingOptions) {
        Map<Object, Object> map;
        if (!this.sourceAndSchemeSpecificOptions.containsKey(scheme)) {
            map = new HashMap();
            this.sourceAndSchemeSpecificOptions.put(scheme, map);
        } else {
            map = this.sourceAndSchemeSpecificOptions.get(scheme);
        }
        map.put(source, processingOptions);
    }

    public void setBlockedTransactionTypesPerScheme(Map<TransactionType, Set<PaymentDetailsScheme>> blockedTransactionTypes) {
        this.blockedTransactionTypes.putAll(blockedTransactionTypes);
    }

    private ProcessingOptions createAllowedProcessingOptions() {
        ProcessingOptions processingOptions = new ProcessingOptions();
        processingOptions.setStatus(ProcessingOptions.Status.ALLOWED);
        processingOptions.setFallbackStatus(ProcessingOptions.Status.ALLOWED);
        processingOptions.setFallbackRequiredRetries(0);
        processingOptions.setCvm(ProcessingOptions.CVM.DEFAULT);
        processingOptions.setNoCvmLimit(BigDecimal.ZERO);
        processingOptions.setCoBrandingSupported(true);
        return processingOptions;
    }

    private ProcessingOptions createBlockedProcessingOptions() {
        ProcessingOptions processingOptions = new ProcessingOptions();
        processingOptions.setStatus(ProcessingOptions.Status.BLOCKED);
        processingOptions.setFallbackStatus(ProcessingOptions.Status.BLOCKED);
        processingOptions.setFallbackRequiredRetries(0);
        processingOptions.setCvm(ProcessingOptions.CVM.DEFAULT);
        processingOptions.setNoCvmLimit(BigDecimal.ZERO);
        processingOptions.setCoBrandingSupported(true);
        return processingOptions;
    }

    public void addFeature(ProcessingOptions.Feature feature) {
        this.features.add(feature);
    }

    public EnumSet<ProcessingOptions.Feature> getFeatures() {
        return this.features;
    }

    public int size() {
        return this.sourceAndSchemeSpecificOptions.size();
    }

    public void addAccessoryBehavior(ProcessingOptions.Behavior behavior) {
        this.accessoryBehaviors.add(behavior);
    }

    public void addAccessoryBehaviors(Set<ProcessingOptions.Behavior> behaviors) {
        this.accessoryBehaviors.addAll(behaviors);
    }

    public EnumSet<ProcessingOptions.Behavior> getAccessoryBehaviors() {
        return this.accessoryBehaviors;
    }

    public cy getAidConstraints() {
        return this.aidConstraints;
    }

    public void setAidConstraints(cy aidConstraints) {
        this.aidConstraints = aidConstraints;
    }

    public String toString() {
        return "ProcessingOptionsContainer{, sourceSpecificOptions=" + this.sourceSpecificOptions + ", sourceAndSchemeSpecificOptions=" + this.sourceAndSchemeSpecificOptions + ", accessoryBehaviors=" + this.accessoryBehaviors + ", features=" + this.features + ", blockedTransactionTypesPerScheme=" + this.blockedTransactionTypes + "}";
    }

    public boolean isUSMagstripeEnabled() {
        return this.accessoryBehaviors.contains((Object)ProcessingOptions.Behavior.US_MAGSTRIPE_REQUIRES_CREDIT_DEBIT_SELECTION_BY_MERCHANT) || this.accessoryBehaviors.contains((Object)ProcessingOptions.Behavior.US_MAGSTRIPE_REQUIRES_CREDIT_DEBIT_SELECTION_BY_SHOPPER);
    }

    public boolean isQuickChipRefundEnabled() {
        return this.accessoryBehaviors.contains((Object)ProcessingOptions.Behavior.US_EMV_REFUND_WORKFLOW);
    }

    public boolean isFullEmvRefundEnabled() {
        return this.accessoryBehaviors.contains((Object)ProcessingOptions.Behavior.FULL_EMV_REFUND_WORKFLOW);
    }

    public boolean isUsEmvRefundEnabled() {
        return this.accessoryBehaviors.contains((Object)ProcessingOptions.Behavior.US_EMV_REFUND_WORKFLOW);
    }

    public Map<PaymentDetailsSource, ProcessingOptions> getSourceSpecificOptions() {
        return this.sourceSpecificOptions;
    }

    public Map<PaymentDetailsScheme, Map<PaymentDetailsSource, ProcessingOptions>> getSourceAndSchemeSpecificOptions() {
        return this.sourceAndSchemeSpecificOptions;
    }

    public boolean isCoBrandingSupported(PaymentDetailsScheme scheme, PaymentDetailsSource source) {
        return this.getProcessingOptions(scheme, source).isCoBrandingSupported();
    }
}

