/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.accessories.Accessory;
import io.mpos.core.common.obfuscated.em;
import io.mpos.core.common.obfuscated.ew;
import io.mpos.shared.transactions.BaseTransaction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ResourceHandler {
    private static final String TAG = "ResourceHandler";
    private Set<Accessory> mConnectedAccessories = Collections.synchronizedSet(new HashSet());
    private Set<BaseTransaction> mOngoingTransactions = Collections.synchronizedSet(new HashSet());
    private em<BaseTransaction, Accessory> mTransactionAccessoryBidiMap = new em();
    private Map<Accessory, Set<ew>> mAccessoryToWorkflow = Collections.synchronizedMap(new HashMap());
    private boolean mMetricsSubmissionOngoing;

    public void addConnectedAccessory(Accessory accessory) {
        this.mConnectedAccessories.add(accessory);
    }

    public void removeConnectedAccessory(Accessory accessory) {
        this.mConnectedAccessories.remove(accessory);
    }

    public boolean isConnected(Accessory accessory) {
        return this.mConnectedAccessories.contains(accessory);
    }

    public boolean canTransaction(BaseTransaction transaction, Accessory accessory) {
        if (this.isAnyTransactionOngoing()) {
            return false;
        }
        if (!this.isConnected(accessory)) {
            return false;
        }
        return !this.isAccessoryUsedForTransaction(accessory);
    }

    public boolean isOngoing(BaseTransaction transaction) {
        return this.mOngoingTransactions.contains(transaction);
    }

    public boolean isAnyTransactionOngoing() {
        return this.mOngoingTransactions.size() > 0;
    }

    public void attachWorkflow(ew workflow, Accessory accessory) {
        this.internalInitForWorkflowAndAccessory(accessory);
        this.mAccessoryToWorkflow.get(accessory).add(workflow);
    }

    public void detachWorkflow(ew workflow, Accessory accessory) {
        this.internalInitForWorkflowAndAccessory(accessory);
        this.mAccessoryToWorkflow.get(accessory).remove(workflow);
    }

    public boolean isAccessoryInWorkflow(Accessory accessory) {
        Set<ew> set = this.mAccessoryToWorkflow.get(accessory);
        return set != null && !set.isEmpty();
    }

    public void attachTransaction(BaseTransaction transaction) {
        if (this.isTransactionAttached(transaction)) {
            throw new IllegalArgumentException("This transaction is already attached: " + transaction);
        }
        this.mOngoingTransactions.add(transaction);
    }

    public void attachTransaction(BaseTransaction transaction, Accessory accessory) {
        if (this.isAccessoryUsedForTransaction(accessory)) {
            throw new IllegalArgumentException("This accessory is already attached: " + accessory);
        }
        if (this.isTransactionAttached(transaction)) {
            throw new IllegalArgumentException("This transaction is already attached: " + transaction);
        }
        this.mTransactionAccessoryBidiMap.a(transaction, accessory);
        this.mOngoingTransactions.add(transaction);
    }

    public void detachTransaction(BaseTransaction transaction) {
        this.mOngoingTransactions.remove(transaction);
        String cfr_ignored_0 = "ongoing transactions count: " + this.mOngoingTransactions.size();
    }

    public void detachTransaction(BaseTransaction transaction, Accessory accessory) {
        this.mTransactionAccessoryBidiMap.c(transaction);
        this.mOngoingTransactions.remove(transaction);
        String cfr_ignored_0 = "ongoing transactions count: " + this.mOngoingTransactions.size();
    }

    public boolean isAccessoryUsedForTransaction(Accessory accessory) {
        return this.mTransactionAccessoryBidiMap.e(accessory);
    }

    public BaseTransaction getTransactionRunningOnAccessory(Accessory accessory) {
        return this.mTransactionAccessoryBidiMap.b(accessory);
    }

    public boolean isTransactionAttached(BaseTransaction transaction) {
        return this.mTransactionAccessoryBidiMap.d(transaction);
    }

    private void internalInitForWorkflowAndAccessory(Accessory accessory) {
        if (!this.mAccessoryToWorkflow.containsKey(accessory)) {
            this.mAccessoryToWorkflow.put(accessory, new CopyOnWriteArraySet());
        }
    }

    public boolean isMetricsSubmissionOngoing() {
        return this.mMetricsSubmissionOngoing;
    }

    public void setMetricsSubmissionOngoing(boolean metricsSubmissionOngoing) {
        this.mMetricsSubmissionOngoing = metricsSubmissionOngoing;
    }

    public Set<ew> getAttachedWorkflows(Accessory accessory) {
        this.internalInitForWorkflowAndAccessory(accessory);
        return Collections.unmodifiableSet(this.mAccessoryToWorkflow.get(accessory));
    }
}

