/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.TimeHelper;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.DefaultTransactionDetails;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.parameters.TransactionParameters;

public class TransactionLocalRegistrationService {
    public BaseTransaction createFromTransactionParameters(TransactionParameters transactionParameters) {
        if (transactionParameters.getParametersType() != TransactionParameters.Type.CHARGE && transactionParameters.getParametersType() != TransactionParameters.Type.REFUND) {
            throw new IllegalArgumentException("Only use with charge or refund parameters");
        }
        DefaultTransaction defaultTransaction = new DefaultTransaction(transactionParameters.getAmount(), transactionParameters.getCurrency(), transactionParameters.getType());
        defaultTransaction.setIdentifier(Helper.createRandomUUID().replace("-", ""));
        defaultTransaction.setCreatedTimeZone(TimeHelper.getCurrentTimeZone());
        defaultTransaction.setSubject(transactionParameters.getSubject());
        defaultTransaction.setCustomIdentifier(transactionParameters.getCustomIdentifier());
        defaultTransaction.setAutoCapture(transactionParameters.isAutoCapture());
        defaultTransaction.setReferencedTransactionIdentifier(transactionParameters.getReferencedTransactionIdentifier());
        defaultTransaction.setWorkflow(transactionParameters.getWorkflow());
        defaultTransaction.setWorkflowConfiguration(defaultTransaction.getWorkflowConfiguration());
        DefaultTransactionDetails defaultTransactionDetails = new DefaultTransactionDetails();
        defaultTransactionDetails.setIncludedTipAmount(transactionParameters.getIncludedTipAmount());
        defaultTransactionDetails.setMetadata(transactionParameters.getMetadata());
        defaultTransaction.setDetails(defaultTransactionDetails);
        return defaultTransaction;
    }

    public DefaultTransaction createFromTransactionParametersAndAccountParameters(TransactionParameters transactionParameters, AccountParameters accountParameters) {
        DefaultTransaction defaultTransaction = (DefaultTransaction)this.createFromTransactionParameters(transactionParameters);
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setScheme(accountParameters.getScheme());
        defaultPaymentDetails.setSource(accountParameters.getSource());
        defaultPaymentDetails.setWorkflowType(transactionParameters.getWorkflow());
        defaultTransaction.setPaymentDetails(defaultPaymentDetails);
        return defaultTransaction;
    }
}

