/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider;

import io.mpos.accessories.AccessoryType;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.provider.WhitelistAccessoryRequirement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WhitelistAccessory {
    private String identifier;
    private String status;
    private AccessoryType type;
    private String serialNumber;
    private String terminalIdentifier;
    private String configurationVersion;
    private String softwareVersion;
    private String firmwareVersion;
    private Integer transactionCounter;
    private List<WhitelistAccessoryRequirement> requiredSoftware;
    private List<WhitelistAccessoryRequirement> requiredConfiguration;
    private List<WhitelistAccessoryRequirement> requiredFirmware;
    private EncryptionStatus encryptionStatus = EncryptionStatus.UNKNOWN;
    private UpdateStatus updateStatus = UpdateStatus.UNKNOWN;
    private HashMap<PaymentDetailsScheme, String> terminalIds;
    private EnumSet<RequiredEncryption> requiredEncryption = EnumSet.noneOf(RequiredEncryption.class);

    public WhitelistAccessory(String serialNumber, String status, String identifier, AccessoryType type, String terminalIdentifier, String transactionCounter) {
        this.identifier = identifier;
        this.status = status;
        this.type = type;
        this.serialNumber = serialNumber;
        this.terminalIdentifier = terminalIdentifier;
        if (transactionCounter != null) {
            this.transactionCounter = Integer.valueOf(transactionCounter);
        }
    }

    public void addSoftwareRequirement(WhitelistAccessoryRequirement requirement) {
        if (this.requiredSoftware == null) {
            this.requiredSoftware = new ArrayList<WhitelistAccessoryRequirement>();
        }
        this.requiredSoftware.add(requirement);
    }

    public void addConfigRequirement(WhitelistAccessoryRequirement requirement) {
        if (this.requiredConfiguration == null) {
            this.requiredConfiguration = new ArrayList<WhitelistAccessoryRequirement>();
        }
        this.requiredConfiguration.add(requirement);
    }

    public void addFirmwareRequirement(WhitelistAccessoryRequirement requirement) {
        if (this.requiredFirmware == null) {
            this.requiredFirmware = new ArrayList<WhitelistAccessoryRequirement>();
        }
        this.requiredFirmware.add(requirement);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getStatus() {
        return this.status;
    }

    public AccessoryType getType() {
        return this.type;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier;
    }

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public void setConfigurationVersion(String configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public List<WhitelistAccessoryRequirement> getRequiredSoftware() {
        return this.requiredSoftware;
    }

    public void setRequiredSoftware(List<WhitelistAccessoryRequirement> requiredSoftware) {
        this.requiredSoftware = requiredSoftware;
    }

    public void setRequiredFirmware(List<WhitelistAccessoryRequirement> requiredFirmware) {
        this.requiredFirmware = requiredFirmware;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public List<WhitelistAccessoryRequirement> getRequiredConfiguration() {
        return this.requiredConfiguration;
    }

    public List<WhitelistAccessoryRequirement> getRequiredFirmware() {
        return this.requiredFirmware;
    }

    public void setRequiredConfiguration(List<WhitelistAccessoryRequirement> requiredConfiguration) {
        this.requiredConfiguration = requiredConfiguration;
    }

    public Integer getTransactionCounter() {
        return this.transactionCounter;
    }

    public void setTransactionCounter(Integer transactionCounter) {
        this.transactionCounter = transactionCounter;
    }

    @NotNull
    public EncryptionStatus getEncryptionStatus() {
        return this.encryptionStatus;
    }

    public void setEncryptionStatus(@NotNull EncryptionStatus encryptionStatus) {
        this.encryptionStatus = encryptionStatus;
    }

    @NotNull
    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(@NotNull UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    public void setTerminalIds(HashMap<PaymentDetailsScheme, String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public Map<PaymentDetailsScheme, String> getTerminalIds() {
        return this.terminalIds;
    }

    public String getTerminalId(PaymentDetailsScheme scheme) {
        if (this.terminalIds != null && this.terminalIds.containsKey(scheme)) {
            return this.terminalIds.get(scheme);
        }
        return null;
    }

    public EnumSet<RequiredEncryption> getRequiredEncryption() {
        return this.requiredEncryption;
    }

    public void setRequiredEncryption(EnumSet<RequiredEncryption> requiredEncryption) {
        this.requiredEncryption = requiredEncryption == null ? EnumSet.noneOf(RequiredEncryption.class) : requiredEncryption;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof WhitelistAccessory)) {
            return false;
        }
        WhitelistAccessory whitelistAccessory = (WhitelistAccessory)o2;
        if (this.configurationVersion != null ? !this.configurationVersion.equals(whitelistAccessory.configurationVersion) : whitelistAccessory.configurationVersion != null) {
            return false;
        }
        if (this.firmwareVersion != null ? !this.firmwareVersion.equals(whitelistAccessory.firmwareVersion) : whitelistAccessory.firmwareVersion != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(whitelistAccessory.identifier) : whitelistAccessory.identifier != null) {
            return false;
        }
        if (this.requiredConfiguration != null ? !this.requiredConfiguration.equals(whitelistAccessory.requiredConfiguration) : whitelistAccessory.requiredConfiguration != null) {
            return false;
        }
        if (this.requiredFirmware != null ? !this.requiredFirmware.equals(whitelistAccessory.requiredFirmware) : whitelistAccessory.requiredFirmware != null) {
            return false;
        }
        if (this.requiredSoftware != null ? !this.requiredSoftware.equals(whitelistAccessory.requiredSoftware) : whitelistAccessory.requiredSoftware != null) {
            return false;
        }
        if (this.serialNumber != null ? !this.serialNumber.equals(whitelistAccessory.serialNumber) : whitelistAccessory.serialNumber != null) {
            return false;
        }
        if (this.softwareVersion != null ? !this.softwareVersion.equals(whitelistAccessory.softwareVersion) : whitelistAccessory.softwareVersion != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(whitelistAccessory.status) : whitelistAccessory.status != null) {
            return false;
        }
        if (this.terminalIdentifier != null ? !this.terminalIdentifier.equals(whitelistAccessory.terminalIdentifier) : whitelistAccessory.terminalIdentifier != null) {
            return false;
        }
        if (this.transactionCounter != null ? !this.transactionCounter.equals(whitelistAccessory.transactionCounter) : whitelistAccessory.transactionCounter != null) {
            return false;
        }
        return this.type == whitelistAccessory.type;
    }

    public int hashCode() {
        int n2 = this.identifier != null ? this.identifier.hashCode() : 0;
        n2 = 31 * n2 + (this.status != null ? this.status.hashCode() : 0);
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
        n2 = 31 * n2 + (this.terminalIdentifier != null ? this.terminalIdentifier.hashCode() : 0);
        n2 = 31 * n2 + (this.configurationVersion != null ? this.configurationVersion.hashCode() : 0);
        n2 = 31 * n2 + (this.softwareVersion != null ? this.softwareVersion.hashCode() : 0);
        n2 = 31 * n2 + (this.firmwareVersion != null ? this.firmwareVersion.hashCode() : 0);
        n2 = 31 * n2 + (this.transactionCounter != null ? this.transactionCounter.hashCode() : 0);
        n2 = 31 * n2 + (this.requiredSoftware != null ? this.requiredSoftware.hashCode() : 0);
        n2 = 31 * n2 + (this.requiredConfiguration != null ? this.requiredConfiguration.hashCode() : 0);
        n2 = 31 * n2 + (this.requiredFirmware != null ? this.requiredFirmware.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "WhitelistAccessory{identifier='" + this.identifier + "', status='" + this.status + "', type=" + this.type + ", serialNumber='" + this.serialNumber + "', terminalIdentifier='" + this.terminalIdentifier + "', configurationVersion='" + this.configurationVersion + "', softwareVersion='" + this.softwareVersion + "', firmwareVersion='" + this.firmwareVersion + "', transactionCounter=" + this.transactionCounter + ", requiredSoftware=" + this.requiredSoftware + ", requiredConfiguration=" + this.requiredConfiguration + ", requiredFirmware=" + this.requiredFirmware + ", encryptionStatus=" + this.encryptionStatus + ", updateStatus=" + this.updateStatus + ", terminalIds=" + this.terminalIds + ", requiredEncryption=" + this.requiredEncryption + "}";
    }

    public static enum EncryptionStatus {
        UNKNOWN,
        OK,
        INVALID;

    }

    public static enum UpdateStatus {
        UNKNOWN,
        DEVICE_PERFORMS_CHECK,
        OK,
        INVALID;

    }

    public static enum RequiredEncryption {
        SRED,
        PIN,
        GENERIC,
        UNKNOWN;

    }
}

