/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider.configuration;

import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.configuration.AbstractConfiguration;
import io.mpos.shared.util.Pair;
import java.util.LinkedHashSet;
import java.util.Set;

public class OnlineConfiguration
extends AbstractConfiguration {
    private static final String TAG = "OnlineConfig";

    @Override
    public Pair<Set<WhitelistAccessory>, MposError> getWhitelistAccessoryForAccessory(PaymentAccessory accessory) {
        if (this.getWhitelistAccessories() == null) {
            DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_NOT_WHITELISTED, "The accessory is not whitelisted");
            return Pair.create(null, defaultMposError);
        }
        LinkedHashSet<WhitelistAccessory> linkedHashSet = new LinkedHashSet<WhitelistAccessory>();
        for (WhitelistAccessory whitelistAccessory : this.getWhitelistAccessories()) {
            if (whitelistAccessory.getSerialNumber() == null) continue;
            String cfr_ignored_0 = "comparing serial of item:" + whitelistAccessory.getSerialNumber() + " to accessory:" + accessory.getAccessoryDetails().getSerialNumber();
            if (!whitelistAccessory.getSerialNumber().endsWith(accessory.getAccessoryDetails().getSerialNumber())) continue;
            String cfr_ignored_1 = "pre comparing type of item:" + whitelistAccessory.getType() + " to accessory:" + accessory.getType();
            this.conditionallyUpdateAccessory(accessory, whitelistAccessory);
            String cfr_ignored_2 = "post comparing type of item:" + whitelistAccessory.getType() + " to accessory:" + accessory.getType();
            if (whitelistAccessory.getType() != accessory.getType()) continue;
            if (whitelistAccessory.getStatus().equalsIgnoreCase("DEACTIVATED")) {
                Log.e(TAG, "accessory is deactivated.");
                DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_DEACTIVATED, "The accessory is deactivated");
                return Pair.create(null, defaultMposError);
            }
            linkedHashSet.add(whitelistAccessory);
        }
        if (linkedHashSet.isEmpty()) {
            DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_NOT_WHITELISTED, "The accessory is not whitelisted");
            return Pair.create(null, defaultMposError);
        }
        return Pair.create(linkedHashSet, null);
    }

    private void conditionallyUpdateAccessory(PaymentAccessory accessory, WhitelistAccessory whitelistAccessory) {
        if (accessory.isTypeProvidedByAccessory()) {
            return;
        }
        if (accessory.getType() != whitelistAccessory.getType()) {
            accessory.setType(whitelistAccessory.getType());
            String cfr_ignored_0 = "server indicates different accessory type:" + whitelistAccessory.getType() + " applying this now";
        }
    }

    @Override
    public boolean isConfigured() {
        return this.getWhitelistAccessories() != null && this.getProcessingOptionsContainer() != null;
    }
}

