/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider.listener;

import com.squareup.otto.Subscribe;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryUpdateRequirement;
import io.mpos.accessories.AccessoryUpdateRequirementComponent;
import io.mpos.accessories.AccessoryUpdateRequirementStatus;
import io.mpos.core.common.obfuscated.r;
import io.mpos.errors.MposError;
import io.mpos.platform.EventDispatcher;
import io.mpos.provider.listener.AbortTransactionListener;
import io.mpos.provider.listener.AccessoryComponentListener;
import io.mpos.provider.listener.AccessoryConnectionStateListener;
import io.mpos.provider.listener.AccessoryProvisionListener;
import io.mpos.provider.listener.AccessoryUpdateListener;
import io.mpos.provider.listener.CaptureTransactionListener;
import io.mpos.provider.listener.IncrementalAuthorizationTransactionListener;
import io.mpos.provider.listener.MposListener;
import io.mpos.provider.listener.ProviderComponentListener;
import io.mpos.provider.listener.QueryTransactionsListener;
import io.mpos.provider.listener.RefundTransactionListener;
import io.mpos.provider.listener.SendCustomerReceiptListener;
import io.mpos.provider.listener.TipAdjustTransactionListener;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.provider.listener.TransactionLookupWithSessionIdentifierListener;
import io.mpos.provider.listener.TransactionLookupWithTransactionIdentifierListener;
import io.mpos.provider.listener.TransactionRegisterListener;
import io.mpos.shared.accessories.DefaultAccessoryUpdateRequirement;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.accessorycomponent.AccessoryComponentEvent;
import io.mpos.shared.events.providercomponent.ProviderComponentEvent;
import io.mpos.shared.provider.listener.AbortTransactionInternalEvent;
import io.mpos.shared.provider.listener.AccessoryConnectionStateChangedInternalEvent;
import io.mpos.shared.provider.listener.AccessoryProvisionInternalEvent;
import io.mpos.shared.provider.listener.AccessoryUpdateStateChangedInternalEvent;
import io.mpos.shared.provider.listener.CaptureTransactionInternalEvent;
import io.mpos.shared.provider.listener.IncrementalAuthorizationTransactionInternalEvent;
import io.mpos.shared.provider.listener.QueryTransactionsInternalEvent;
import io.mpos.shared.provider.listener.RefundTransactionInternalEvent;
import io.mpos.shared.provider.listener.SendCustomerReceiptInternalEvent;
import io.mpos.shared.provider.listener.TipAdjustTransactionInternalEvent;
import io.mpos.shared.provider.listener.TransactionInternalEvent;
import io.mpos.shared.provider.listener.TransactionLookupWithSessionIdentifierInternalEvent;
import io.mpos.shared.provider.listener.TransactionLookupWithTransactionIdentifierInternalEvent;
import io.mpos.shared.provider.listener.TransactionRegisterInternalEvent;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactionprovider.FilterParameters;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.actionsupport.TransactionActionSupport;
import io.mpos.transactions.parameters.TransactionParameters;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;

public class InternalEventQueue
implements AbortTransactionListener,
AccessoryConnectionStateListener,
AccessoryProvisionListener,
AccessoryUpdateListener,
CaptureTransactionListener,
IncrementalAuthorizationTransactionListener,
QueryTransactionsListener,
RefundTransactionListener,
SendCustomerReceiptListener,
TipAdjustTransactionListener,
TransactionListener,
TransactionLookupWithSessionIdentifierListener,
TransactionLookupWithTransactionIdentifierListener,
TransactionRegisterListener {
    private static final String TAG = "InternalEventQueueImpl";
    private Set<AccessoryConnectionStateListener> mAccessoryConnectionStateListener = new CopyOnWriteArraySet<AccessoryConnectionStateListener>();
    private Set<AccessoryUpdateListener> mAccessoryUpdateListener = new CopyOnWriteArraySet<AccessoryUpdateListener>();
    private Set<AccessoryProvisionListener> mAccessoryProvisionListener = new CopyOnWriteArraySet<AccessoryProvisionListener>();
    private Set<TransactionListener> mTransactionListener = new CopyOnWriteArraySet<TransactionListener>();
    private Set<TransactionRegisterListener> mTransactionRegisterListener = new CopyOnWriteArraySet<TransactionRegisterListener>();
    private Set<TransactionLookupWithSessionIdentifierListener> mTransactionLookupWithSessionIdentifierListener = new CopyOnWriteArraySet<TransactionLookupWithSessionIdentifierListener>();
    private Set<TransactionLookupWithTransactionIdentifierListener> mTransactionLookupWithTransactionIdentifierListener = new CopyOnWriteArraySet<TransactionLookupWithTransactionIdentifierListener>();
    private Set<RefundTransactionListener> mRefundTransactionListener = new CopyOnWriteArraySet<RefundTransactionListener>();
    private Set<CaptureTransactionListener> mCaptureTransactionListeners = new CopyOnWriteArraySet<CaptureTransactionListener>();
    private Set<TipAdjustTransactionListener> mTipAdjustTransactionListeners = new CopyOnWriteArraySet<TipAdjustTransactionListener>();
    private Set<AccessoryComponentListener> mAccessoryComponentListeners = new CopyOnWriteArraySet<AccessoryComponentListener>();
    private Set<ProviderComponentListener> mProviderComponentListeners = new CopyOnWriteArraySet<ProviderComponentListener>();
    private Set<SendCustomerReceiptListener> mSendCustomerReceiptListeners = new CopyOnWriteArraySet<SendCustomerReceiptListener>();
    private Set<QueryTransactionsListener> mQueryTransactionsListeners = new CopyOnWriteArraySet<QueryTransactionsListener>();
    private Set<AbortTransactionListener> mAbortTransactionListeners = new CopyOnWriteArraySet<AbortTransactionListener>();
    private Set<IncrementalAuthorizationTransactionListener> mIncrementalAuthorizationTransactionListener = new CopyOnWriteArraySet<IncrementalAuthorizationTransactionListener>();
    private Queue<AccessoryConnectionStateChangedInternalEvent> mAccessoryConnectionStateEvents = new LinkedBlockingQueue<AccessoryConnectionStateChangedInternalEvent>();
    private Queue<AccessoryUpdateStateChangedInternalEvent> mAccessoryUpdateEvents = new LinkedBlockingQueue<AccessoryUpdateStateChangedInternalEvent>();
    private Queue<AccessoryProvisionInternalEvent> mAccessoryProvisionEvents = new LinkedBlockingQueue<AccessoryProvisionInternalEvent>();
    private Queue<TransactionInternalEvent> mTransactionEvents = new LinkedBlockingQueue<TransactionInternalEvent>();
    private Queue<RefundTransactionInternalEvent> mRefundTransactionEvents = new LinkedBlockingQueue<RefundTransactionInternalEvent>();
    private Queue<CaptureTransactionInternalEvent> mCaptureTransactionEvents = new LinkedBlockingQueue<CaptureTransactionInternalEvent>();
    private Queue<TipAdjustTransactionInternalEvent> mTipAdjustTransactionEvents = new LinkedBlockingQueue<TipAdjustTransactionInternalEvent>();
    private Queue<TransactionRegisterInternalEvent> mTransactionRegisterEvents = new LinkedBlockingQueue<TransactionRegisterInternalEvent>();
    private Queue<TransactionLookupWithSessionIdentifierInternalEvent> mTransactionLookupWithSessionIdentifierEvents = new LinkedBlockingQueue<TransactionLookupWithSessionIdentifierInternalEvent>();
    private Queue<TransactionLookupWithTransactionIdentifierInternalEvent> mTransactionLookupWithTransactionIdentifierEvents = new LinkedBlockingQueue<TransactionLookupWithTransactionIdentifierInternalEvent>();
    private Queue<SendCustomerReceiptInternalEvent> mSendCustomerReceiptEvents = new LinkedBlockingQueue<SendCustomerReceiptInternalEvent>();
    private Queue<QueryTransactionsInternalEvent> mQueryTransactionsEvents = new LinkedBlockingQueue<QueryTransactionsInternalEvent>();
    private Queue<AbortTransactionInternalEvent> mVoidingTransactionEvents = new LinkedBlockingQueue<AbortTransactionInternalEvent>();
    private Queue<IncrementalAuthorizationTransactionInternalEvent> mIncrementalAuthorizationTransactionEvents = new LinkedBlockingQueue<IncrementalAuthorizationTransactionInternalEvent>();
    private EventDispatcher mEventDispatcher;

    public InternalEventQueue(EventDispatcher eventDispatcher) {
        this.mEventDispatcher = eventDispatcher;
    }

    private <T extends r, L extends MposListener> void fire(T event, Queue<T> cachedEvents, Set<L> listeners) {
        Runnable runnable = () -> this.internalFire(event, cachedEvents, listeners);
        this.mEventDispatcher.fire(runnable);
    }

    public <T extends r, L extends MposListener> void internalFire(T event, Queue<T> cachedEvents, Set<L> listeners) {
        if (listeners.isEmpty() && cachedEvents != null) {
            String cfr_ignored_0 = "Caching event: " + event.getClass().getSimpleName() + " event info: " + event.toString();
            cachedEvents.add(event);
        }
        for (MposListener mposListener : listeners) {
            String cfr_ignored_1 = "Dispatching event: " + event.getClass().getSimpleName() + " to: " + mposListener.getClass().getSimpleName() + " event info: " + event.toString();
            ((r)event).dispatch((MposListener)mposListener);
        }
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.mTransactionListener.add(transactionListener);
        while (!this.mTransactionEvents.isEmpty()) {
            this.fire(this.mTransactionEvents.poll(), this.mTransactionEvents, this.mTransactionListener);
        }
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        this.mTransactionListener.remove(transactionListener);
    }

    public void addTransactionRegisterListener(TransactionRegisterListener transactionRegisterListener) {
        this.mTransactionRegisterListener.add(transactionRegisterListener);
        while (!this.mTransactionRegisterEvents.isEmpty()) {
            this.fire(this.mTransactionRegisterEvents.poll(), this.mTransactionRegisterEvents, this.mTransactionRegisterListener);
        }
    }

    public void removeTransactionRegisterListener(TransactionRegisterListener transactionRegisterListener) {
        this.mTransactionRegisterListener.remove(transactionRegisterListener);
    }

    public void addTransactionLookupWithSessionIdentifierListener(TransactionLookupWithSessionIdentifierListener listener) {
        this.mTransactionLookupWithSessionIdentifierListener.add(listener);
        while (!this.mTransactionLookupWithSessionIdentifierEvents.isEmpty()) {
            this.fire(this.mTransactionLookupWithSessionIdentifierEvents.poll(), this.mTransactionLookupWithSessionIdentifierEvents, this.mTransactionLookupWithSessionIdentifierListener);
        }
    }

    public void removeTransactionLookupWithSessionIdentifierListener(TransactionLookupWithSessionIdentifierListener listener) {
        this.mTransactionLookupWithSessionIdentifierListener.remove(listener);
    }

    public void addTransactionLookupWithTransactionIdentifierListener(TransactionLookupWithTransactionIdentifierListener listener) {
        this.mTransactionLookupWithTransactionIdentifierListener.add(listener);
        while (!this.mTransactionLookupWithTransactionIdentifierEvents.isEmpty()) {
            this.fire(this.mTransactionLookupWithTransactionIdentifierEvents.poll(), this.mTransactionLookupWithTransactionIdentifierEvents, this.mTransactionLookupWithTransactionIdentifierListener);
        }
    }

    public void removeTransactionLookupWithTransactionIdentifierListener(TransactionLookupWithTransactionIdentifierListener listener) {
        this.mTransactionLookupWithTransactionIdentifierListener.remove(listener);
    }

    public void addTransactionRefundListener(RefundTransactionListener listener) {
        this.mRefundTransactionListener.add(listener);
        while (!this.mRefundTransactionEvents.isEmpty()) {
            this.fire(this.mRefundTransactionEvents.poll(), this.mRefundTransactionEvents, this.mRefundTransactionListener);
        }
    }

    public void removeTransactionRefundListener(RefundTransactionListener listener) {
        this.mRefundTransactionListener.remove(listener);
    }

    public void addTransactionVoidingListener(AbortTransactionListener listener) {
        this.mAbortTransactionListeners.add(listener);
        while (!this.mVoidingTransactionEvents.isEmpty()) {
            this.fire(this.mVoidingTransactionEvents.poll(), this.mVoidingTransactionEvents, this.mAbortTransactionListeners);
        }
    }

    public void removeTransactionVoidingListener(AbortTransactionListener listener) {
        this.mAbortTransactionListeners.remove(listener);
    }

    public void addCaptureTransactionListener(CaptureTransactionListener listener) {
        this.mCaptureTransactionListeners.add(listener);
        while (!this.mCaptureTransactionEvents.isEmpty()) {
            this.fire(this.mCaptureTransactionEvents.poll(), this.mCaptureTransactionEvents, this.mCaptureTransactionListeners);
        }
    }

    public void removeCaptureTransactionListener(CaptureTransactionListener listener) {
        this.mCaptureTransactionListeners.remove(listener);
    }

    public void addTipAdjustTransactionListener(TipAdjustTransactionListener listener) {
        this.mTipAdjustTransactionListeners.add(listener);
        while (!this.mTipAdjustTransactionEvents.isEmpty()) {
            this.fire(this.mTipAdjustTransactionEvents.poll(), this.mTipAdjustTransactionEvents, this.mTipAdjustTransactionListeners);
        }
    }

    public void removeTipAdjustTransactionListener(TipAdjustTransactionListener listener) {
        this.mTipAdjustTransactionListeners.remove(listener);
    }

    public void addAccessoryConnectionStateListener(AccessoryConnectionStateListener accessoryConnectionStateListener) {
        this.mAccessoryConnectionStateListener.add(accessoryConnectionStateListener);
        while (!this.mAccessoryConnectionStateEvents.isEmpty()) {
            this.fire(this.mAccessoryConnectionStateEvents.poll(), this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
        }
    }

    public void removeAccessoryConnectionStateListener(AccessoryConnectionStateListener accessoryConnectionStateListener) {
        this.mAccessoryConnectionStateListener.remove(accessoryConnectionStateListener);
    }

    public void addAccessoryUpdateListener(AccessoryUpdateListener accessoryConnectionStateListener) {
        this.mAccessoryUpdateListener.add(accessoryConnectionStateListener);
        while (!this.mAccessoryUpdateEvents.isEmpty()) {
            this.fire(this.mAccessoryUpdateEvents.poll(), this.mAccessoryUpdateEvents, this.mAccessoryUpdateListener);
        }
    }

    public void removeAccessoryUpdateListener(AccessoryUpdateListener accessoryUpdateListener) {
        this.mAccessoryUpdateListener.remove(accessoryUpdateListener);
    }

    public void addAccessoryProvisionListener(AccessoryProvisionListener accessoryProvisionListener) {
        this.mAccessoryProvisionListener.add(accessoryProvisionListener);
        while (!this.mAccessoryProvisionEvents.isEmpty()) {
            this.fire(this.mAccessoryProvisionEvents.poll(), this.mAccessoryProvisionEvents, this.mAccessoryProvisionListener);
        }
    }

    public void removeAccessoryProvisionListener(AccessoryProvisionListener accessoryProvisionListener) {
        this.mAccessoryProvisionListener.remove(accessoryProvisionListener);
    }

    public void addReceiptSendListener(SendCustomerReceiptListener customerReceiptSendListener) {
        this.mSendCustomerReceiptListeners.add(customerReceiptSendListener);
        while (!this.mSendCustomerReceiptEvents.isEmpty()) {
            this.fire(this.mSendCustomerReceiptEvents.poll(), this.mSendCustomerReceiptEvents, this.mSendCustomerReceiptListeners);
        }
    }

    public void removeReceiptSendListener(SendCustomerReceiptListener sendCustomerReceiptListener) {
        this.mSendCustomerReceiptListeners.remove(sendCustomerReceiptListener);
    }

    public void addQueryTransactionsListener(QueryTransactionsListener queryTransactionsListener) {
        this.mQueryTransactionsListeners.add(queryTransactionsListener);
        while (!this.mQueryTransactionsEvents.isEmpty()) {
            this.fire(this.mQueryTransactionsEvents.poll(), this.mQueryTransactionsEvents, this.mQueryTransactionsListeners);
        }
    }

    public void removeQueryTransactionsListener(QueryTransactionsListener queryTransactionsListener) {
        this.mQueryTransactionsListeners.remove(queryTransactionsListener);
    }

    public synchronized void addProviderComponentListener(ProviderComponentListener providerComponentListener) {
        this.registerOnBus();
        this.mProviderComponentListeners.add(providerComponentListener);
    }

    public synchronized void removeProviderComponentListener(ProviderComponentListener providerComponentListener) {
        this.mProviderComponentListeners.remove(providerComponentListener);
        this.unregisterFromBus();
    }

    public synchronized void addAccessoryComponentListener(AccessoryComponentListener accessoryComponentListener) {
        this.registerOnBus();
        this.mAccessoryComponentListeners.add(accessoryComponentListener);
    }

    public synchronized void removeAccessoryComponentListener(AccessoryComponentListener accessoryComponentListener) {
        this.mAccessoryComponentListeners.remove(accessoryComponentListener);
        this.unregisterFromBus();
    }

    public void addIncrementalAuthorizationTransactionListener(IncrementalAuthorizationTransactionListener incrementalAuthorizationTransactionListener) {
        this.mIncrementalAuthorizationTransactionListener.add(incrementalAuthorizationTransactionListener);
        while (!this.mIncrementalAuthorizationTransactionEvents.isEmpty()) {
            this.fire(this.mIncrementalAuthorizationTransactionEvents.poll(), this.mIncrementalAuthorizationTransactionEvents, this.mIncrementalAuthorizationTransactionListener);
        }
    }

    public void removeIncrementalAuthorizationTransactionListener(IncrementalAuthorizationTransactionListener incrementalAuthorizationTransactionListener) {
        this.mIncrementalAuthorizationTransactionListener.remove(incrementalAuthorizationTransactionListener);
    }

    @Override
    public void onAccessoryConnectSuccess(Accessory accessory) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(true, accessory);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    @Override
    public void onAccessoryCancelConnectSuccess(Accessory accessory) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(false, accessory);
        accessoryConnectionStateChangedInternalEvent.setCancelConnect(true);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    @Override
    public void onAccessoryCancelConnectFailure(Accessory accessory, MposError error) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(false, accessory, error);
        accessoryConnectionStateChangedInternalEvent.setCancelConnect(true);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    @Override
    public void onAccessoryConnectFailure(MposError error) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(true, error);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    @Override
    public void onAccessoryDisconnectSuccess(Accessory accessory) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(false, accessory);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    @Override
    public void onAccessoryDisconnectFailure(Accessory accessory, MposError error) {
        AccessoryConnectionStateChangedInternalEvent accessoryConnectionStateChangedInternalEvent = new AccessoryConnectionStateChangedInternalEvent(false, accessory, error);
        this.fire(accessoryConnectionStateChangedInternalEvent, this.mAccessoryConnectionStateEvents, this.mAccessoryConnectionStateListener);
    }

    public void onAccessoryUpdateSuccess(Accessory accessory) {
        AccessoryUpdateStateChangedInternalEvent accessoryUpdateStateChangedInternalEvent = new AccessoryUpdateStateChangedInternalEvent(accessory);
        this.fire(accessoryUpdateStateChangedInternalEvent, this.mAccessoryUpdateEvents, this.mAccessoryUpdateListener);
    }

    public void onAccessoryUpdateFailure(Accessory accessory, MposError error) {
        AccessoryUpdateStateChangedInternalEvent accessoryUpdateStateChangedInternalEvent = new AccessoryUpdateStateChangedInternalEvent(accessory, error);
        this.fire(accessoryUpdateStateChangedInternalEvent, this.mAccessoryUpdateEvents, this.mAccessoryUpdateListener);
    }

    public void onAccessoryCheckUpdateSuccess(Accessory accessory, AccessoryUpdateRequirement updateRequirement) {
        AccessoryUpdateStateChangedInternalEvent accessoryUpdateStateChangedInternalEvent = new AccessoryUpdateStateChangedInternalEvent(updateRequirement, accessory);
        this.fire(accessoryUpdateStateChangedInternalEvent, this.mAccessoryUpdateEvents, this.mAccessoryUpdateListener);
    }

    public void onAccessoryCheckUpdateFailure(Accessory accessory, MposError error) {
        AccessoryUpdateStateChangedInternalEvent accessoryUpdateStateChangedInternalEvent = new AccessoryUpdateStateChangedInternalEvent(new DefaultAccessoryUpdateRequirement(AccessoryUpdateRequirementStatus.NO_UPDATE_AVAILABLE, EnumSet.noneOf(AccessoryUpdateRequirementComponent.class)), accessory, error);
        this.fire(accessoryUpdateStateChangedInternalEvent, this.mAccessoryUpdateEvents, this.mAccessoryUpdateListener);
    }

    @Override
    public void onAccessoryProvisionSuccess(Accessory accessory) {
        AccessoryProvisionInternalEvent accessoryProvisionInternalEvent = new AccessoryProvisionInternalEvent(accessory);
        this.fire(accessoryProvisionInternalEvent, this.mAccessoryProvisionEvents, this.mAccessoryProvisionListener);
    }

    @Override
    public void onAccessoryProvisionFailure(Accessory accessory, MposError error) {
        AccessoryProvisionInternalEvent accessoryProvisionInternalEvent = new AccessoryProvisionInternalEvent(accessory, error);
        this.fire(accessoryProvisionInternalEvent, this.mAccessoryProvisionEvents, this.mAccessoryProvisionListener);
    }

    @Override
    public void onTransactionRegisterSuccess(BaseTransaction transaction) {
        TransactionRegisterInternalEvent transactionRegisterInternalEvent = new TransactionRegisterInternalEvent(transaction);
        this.fire(transactionRegisterInternalEvent, this.mTransactionRegisterEvents, this.mTransactionRegisterListener);
    }

    @Override
    public void onTransactionRegisterFailure(MposError error) {
        TransactionRegisterInternalEvent transactionRegisterInternalEvent = new TransactionRegisterInternalEvent(error);
        this.fire(transactionRegisterInternalEvent, this.mTransactionRegisterEvents, this.mTransactionRegisterListener);
    }

    @Override
    public void onTransactionApproved(BaseTransaction transaction) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.APPROVED, transaction);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionDeclined(BaseTransaction transaction) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.DECLINED, transaction);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionAborted(BaseTransaction transaction) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.ABORTED, transaction);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionFailure(BaseTransaction transaction, MposError error) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(transaction, error);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionActionRequired(BaseTransaction transaction, TransactionAction action, TransactionActionSupport supportData) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.ACTION_REQUIRED, transaction, action, supportData);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionAbortSuccess(BaseTransaction transaction) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.ABORT, transaction);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onTransactionAbortFailure(BaseTransaction transaction, MposError error) {
        TransactionInternalEvent transactionInternalEvent = new TransactionInternalEvent(TransactionInternalEvent.TransactionState.ABORT, transaction, error);
        this.fire(transactionInternalEvent, this.mTransactionEvents, this.mTransactionListener);
    }

    @Override
    public void onRefundTransactionApproved(BaseTransaction transaction) {
        RefundTransactionInternalEvent refundTransactionInternalEvent = new RefundTransactionInternalEvent(RefundTransactionInternalEvent.TransactionState.APPROVED, transaction);
        this.fire(refundTransactionInternalEvent, this.mRefundTransactionEvents, this.mRefundTransactionListener);
    }

    @Override
    public void onRefundTransactionDeclined(BaseTransaction transaction) {
        RefundTransactionInternalEvent refundTransactionInternalEvent = new RefundTransactionInternalEvent(RefundTransactionInternalEvent.TransactionState.DECLINED, transaction);
        this.fire(refundTransactionInternalEvent, this.mRefundTransactionEvents, this.mRefundTransactionListener);
    }

    @Override
    public void onRefundTransactionFailure(TransactionParameters transactionParameters, MposError error, BaseTransaction transaction) {
        RefundTransactionInternalEvent refundTransactionInternalEvent = new RefundTransactionInternalEvent(transactionParameters, error, transaction);
        this.fire(refundTransactionInternalEvent, this.mRefundTransactionEvents, this.mRefundTransactionListener);
    }

    @Override
    public void onCaptureTransactionApproved(TransactionParameters transactionParameters, BaseTransaction transaction) {
        CaptureTransactionInternalEvent captureTransactionInternalEvent = new CaptureTransactionInternalEvent(transactionParameters, transaction);
        this.fire(captureTransactionInternalEvent, this.mCaptureTransactionEvents, this.mCaptureTransactionListeners);
    }

    @Override
    public void onCaptureTransactionFailure(TransactionParameters transactionParameters, MposError error) {
        CaptureTransactionInternalEvent captureTransactionInternalEvent = new CaptureTransactionInternalEvent(transactionParameters, error);
        this.fire(captureTransactionInternalEvent, this.mCaptureTransactionEvents, this.mCaptureTransactionListeners);
    }

    @Override
    public void onTipAdjustTransactionApproved(TransactionParameters transactionParameters, BaseTransaction transaction) {
        TipAdjustTransactionInternalEvent tipAdjustTransactionInternalEvent = new TipAdjustTransactionInternalEvent(transactionParameters, transaction);
        this.fire(tipAdjustTransactionInternalEvent, this.mTipAdjustTransactionEvents, this.mTipAdjustTransactionListeners);
    }

    @Override
    public void onTipAdjustTransactionFailure(TransactionParameters transactionParameters, MposError error) {
        TipAdjustTransactionInternalEvent tipAdjustTransactionInternalEvent = new TipAdjustTransactionInternalEvent(transactionParameters, error);
        this.fire(tipAdjustTransactionInternalEvent, this.mTipAdjustTransactionEvents, this.mTipAdjustTransactionListeners);
    }

    @Override
    public void onTransactionLookupWithSessionIdentifierSuccess(String identifier, BaseTransaction transaction) {
        TransactionLookupWithSessionIdentifierInternalEvent transactionLookupWithSessionIdentifierInternalEvent = new TransactionLookupWithSessionIdentifierInternalEvent(identifier, transaction);
        this.fire(transactionLookupWithSessionIdentifierInternalEvent, this.mTransactionLookupWithSessionIdentifierEvents, this.mTransactionLookupWithSessionIdentifierListener);
    }

    @Override
    public void onTransactionLookupWithSessionIdentifierFailure(String identifier, MposError error) {
        TransactionLookupWithSessionIdentifierInternalEvent transactionLookupWithSessionIdentifierInternalEvent = new TransactionLookupWithSessionIdentifierInternalEvent(identifier, null, error);
        this.fire(transactionLookupWithSessionIdentifierInternalEvent, this.mTransactionLookupWithSessionIdentifierEvents, this.mTransactionLookupWithSessionIdentifierListener);
    }

    @Override
    public void onTransactionLookupWithTransactionIdentifierSuccess(String identifier, BaseTransaction transaction) {
        TransactionLookupWithTransactionIdentifierInternalEvent transactionLookupWithTransactionIdentifierInternalEvent = new TransactionLookupWithTransactionIdentifierInternalEvent(identifier, transaction);
        this.fire(transactionLookupWithTransactionIdentifierInternalEvent, this.mTransactionLookupWithTransactionIdentifierEvents, this.mTransactionLookupWithTransactionIdentifierListener);
    }

    @Override
    public void onTransactionLookupWithTransactionIdentifierFailure(String identifier, MposError error) {
        TransactionLookupWithTransactionIdentifierInternalEvent transactionLookupWithTransactionIdentifierInternalEvent = new TransactionLookupWithTransactionIdentifierInternalEvent(identifier, null, error);
        this.fire(transactionLookupWithTransactionIdentifierInternalEvent, this.mTransactionLookupWithTransactionIdentifierEvents, this.mTransactionLookupWithTransactionIdentifierListener);
    }

    @Override
    public void onCustomerReceiptSendSuccess(String transactionIdentifier) {
        SendCustomerReceiptInternalEvent sendCustomerReceiptInternalEvent = new SendCustomerReceiptInternalEvent(transactionIdentifier, null);
        this.fire(sendCustomerReceiptInternalEvent, this.mSendCustomerReceiptEvents, this.mSendCustomerReceiptListeners);
    }

    @Override
    public void onCustomerReceiptSendFailure(String transactionIdentifier, MposError error) {
        SendCustomerReceiptInternalEvent sendCustomerReceiptInternalEvent = new SendCustomerReceiptInternalEvent(transactionIdentifier, error);
        this.fire(sendCustomerReceiptInternalEvent, this.mSendCustomerReceiptEvents, this.mSendCustomerReceiptListeners);
    }

    @Override
    public void onQueryTransactionsSuccess(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, List<BaseTransaction> transactions) {
        QueryTransactionsInternalEvent queryTransactionsInternalEvent = new QueryTransactionsInternalEvent(filterParameters, includeReceipts, offset, limit, transactions);
        this.fire(queryTransactionsInternalEvent, this.mQueryTransactionsEvents, this.mQueryTransactionsListeners);
    }

    @Override
    public void onQueryTransactionsFailure(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, MposError error) {
        QueryTransactionsInternalEvent queryTransactionsInternalEvent = new QueryTransactionsInternalEvent(filterParameters, includeReceipts, offset, limit, error);
        this.fire(queryTransactionsInternalEvent, this.mQueryTransactionsEvents, this.mQueryTransactionsListeners);
    }

    @Override
    public void onTransactionAbortSuccess() {
        AbortTransactionInternalEvent abortTransactionInternalEvent = new AbortTransactionInternalEvent();
        this.fire(abortTransactionInternalEvent, this.mVoidingTransactionEvents, this.mAbortTransactionListeners);
    }

    @Override
    public void onTransactionAbortFailure(MposError error) {
        AbortTransactionInternalEvent abortTransactionInternalEvent = new AbortTransactionInternalEvent(error);
        this.fire(abortTransactionInternalEvent, this.mVoidingTransactionEvents, this.mAbortTransactionListeners);
    }

    @Override
    public void onIncrementalAuthorizationTransactionApproved(TransactionParameters transactionParameters, BaseTransaction transaction) {
        IncrementalAuthorizationTransactionInternalEvent incrementalAuthorizationTransactionInternalEvent = new IncrementalAuthorizationTransactionInternalEvent(transactionParameters, transaction);
        this.fire(incrementalAuthorizationTransactionInternalEvent, this.mIncrementalAuthorizationTransactionEvents, this.mIncrementalAuthorizationTransactionListener);
    }

    @Override
    public void onIncrementalAuthorizationTransactionFailure(TransactionParameters transactionParameters, MposError error, BaseTransaction transaction) {
        IncrementalAuthorizationTransactionInternalEvent incrementalAuthorizationTransactionInternalEvent = new IncrementalAuthorizationTransactionInternalEvent(transactionParameters, error, transaction);
        this.fire(incrementalAuthorizationTransactionInternalEvent, this.mIncrementalAuthorizationTransactionEvents, this.mIncrementalAuthorizationTransactionListener);
    }

    @Subscribe
    public void onAccessoryComponentEvent(AccessoryComponentEvent event) {
        this.fire(event, null, this.mAccessoryComponentListeners);
    }

    @Subscribe
    public void onProviderComponentEvent(ProviderComponentEvent event) {
        this.fire(event, null, this.mProviderComponentListeners);
    }

    void registerOnBus() {
        if (this.mAccessoryComponentListeners.size() == 0 && this.mProviderComponentListeners.size() == 0) {
            BusProvider.getInstance().register((Object)this);
        }
    }

    void unregisterFromBus() {
        if (this.mAccessoryComponentListeners.size() == 0 && this.mProviderComponentListeners.size() == 0) {
            BusProvider.getInstance().unregister((Object)this);
        }
    }

    public void reset() {
        this.mAccessoryConnectionStateListener.clear();
        this.mAccessoryUpdateListener.clear();
        this.mAccessoryProvisionListener.clear();
        this.mTransactionListener.clear();
        this.mTransactionRegisterListener.clear();
        this.mTransactionLookupWithSessionIdentifierListener.clear();
        this.mTransactionLookupWithTransactionIdentifierListener.clear();
        this.mRefundTransactionListener.clear();
        this.mCaptureTransactionListeners.clear();
        this.mTipAdjustTransactionListeners.clear();
        this.mAccessoryComponentListeners.clear();
        this.mProviderComponentListeners.clear();
        this.mSendCustomerReceiptListeners.clear();
        this.mQueryTransactionsListeners.clear();
        this.mAbortTransactionListeners.clear();
        this.mAccessoryConnectionStateEvents.clear();
        this.mAccessoryUpdateEvents.clear();
        this.mAccessoryProvisionEvents.clear();
        this.mTransactionEvents.clear();
        this.mRefundTransactionEvents.clear();
        this.mCaptureTransactionEvents.clear();
        this.mTipAdjustTransactionEvents.clear();
        this.mTransactionRegisterEvents.clear();
        this.mTransactionLookupWithSessionIdentifierEvents.clear();
        this.mTransactionLookupWithTransactionIdentifierEvents.clear();
        this.mSendCustomerReceiptEvents.clear();
        this.mQueryTransactionsEvents.clear();
        this.mVoidingTransactionEvents.clear();
    }
}

