/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider.listener;

import io.mpos.core.common.obfuscated.r;
import io.mpos.errors.MposError;
import io.mpos.provider.listener.RefundTransactionListener;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactions.parameters.TransactionParameters;

public class RefundTransactionInternalEvent
extends r<RefundTransactionListener> {
    TransactionState mState;
    BaseTransaction mTransaction;
    TransactionParameters mTransactionParameters;
    MposError mError;

    public RefundTransactionInternalEvent(TransactionState state, BaseTransaction transaction) {
        this(state, transaction, null, null);
    }

    public RefundTransactionInternalEvent(TransactionParameters transactionParameters, MposError error, BaseTransaction transaction) {
        this(TransactionState.FAILED, transaction, transactionParameters, error);
    }

    private RefundTransactionInternalEvent(TransactionState state, BaseTransaction transaction, TransactionParameters transactionParameters, MposError error) {
        this.mState = state;
        this.mTransaction = transaction;
        this.mTransactionParameters = transactionParameters;
        this.mError = error;
    }

    @Override
    public void dispatch(RefundTransactionListener listener) {
        switch (this.mState) {
            case APPROVED: {
                listener.onRefundTransactionApproved(this.mTransaction);
                break;
            }
            case DECLINED: {
                listener.onRefundTransactionDeclined(this.mTransaction);
                break;
            }
            case FAILED: {
                listener.onRefundTransactionFailure(this.mTransactionParameters, this.mError, this.mTransaction);
            }
        }
    }

    public static enum TransactionState {
        APPROVED,
        DECLINED,
        FAILED;

    }
}

