/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv;

import io.mpos.shared.PrimitiveTypesTransformExtensionsKt;
import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\r\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/mpos/shared/tlv/ByteBuffer;", "", "bytes", "", "<init>", "([B)V", "position", "", "skipHeadZeros", "", "next", "", "()Ljava/lang/Byte;", "isEmpty", "", "hasMore", "number", "count", "remaining", "remainingLength", "toString", "", "mpos.core"})
public final class ByteBuffer {
    @NotNull
    private final byte[] bytes;
    private int position;

    public ByteBuffer(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"");
        this.bytes = bytes;
    }

    public final void skipHeadZeros() {
        if (this.bytes.length == 0) {
            return;
        }
        while (this.position < this.bytes.length && this.bytes[this.position] == PrimitiveTypesTransformExtensionsKt.b(0)) {
            ++this.position;
        }
    }

    @Nullable
    public final Byte next() {
        Byte by2;
        boolean bl2;
        boolean bl3 = bl2 = !this.isEmpty();
        if (!bl2) {
            by2 = null;
        } else if (bl2) {
            int n2 = this.position;
            this.position = n2 + 1;
            by2 = this.bytes[n2];
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return by2;
    }

    public final boolean isEmpty() {
        return this.position >= this.bytes.length;
    }

    public final boolean hasMore(int number) {
        return this.remainingLength() >= number;
    }

    @Nullable
    public final byte[] next(int count) {
        byte[] byArray;
        boolean bl2 = this.hasMore(count);
        if (!bl2) {
            byArray = null;
        } else if (bl2) {
            int n2;
            this.position = n2 = this.position + count;
            byArray = ArraysKt.sliceArray((byte[])this.bytes, (IntRange)RangesKt.until((int)(this.position - count), (int)n2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }

    @NotNull
    public final byte[] remaining() {
        return ArraysKt.sliceArray((byte[])this.bytes, (IntRange)RangesKt.until((int)this.position, (int)this.bytes.length));
    }

    public final int remainingLength() {
        return this.bytes.length - this.position;
    }

    @NotNull
    public String toString() {
        return super.toString() + "<" + ByteArrayTransformExtensionsKt.toHexString(this.bytes) + ">";
    }
}

