/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv.items;

import io.mpos.shared.CommonResult;
import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringTransformExtensionsKt;
import io.mpos.shared.tlv.ByteBuffer;
import io.mpos.shared.tlv.items.TagType;
import io.mpos.shared.tlv.items.TlvConstructedItem;
import io.mpos.shared.tlv.items.TlvError;
import io.mpos.shared.tlv.items.TlvItem;
import io.mpos.shared.tlv.items.TlvPrimitiveItem;
import io.mpos.shared.tlv.items.TlvTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nJ \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0018"}, d2={"Lio/mpos/shared/tlv/items/TlvParser;", "", "<init>", "()V", "parse", "Lio/mpos/shared/CommonResult;", "", "Lio/mpos/shared/tlv/items/TlvItem;", "Lio/mpos/shared/tlv/items/TlvError;", "hexString", "Lio/mpos/shared/hexstring/HexString;", "bytes", "", "parseNextItem", "buffer", "Lio/mpos/shared/tlv/ByteBuffer;", "parseNextTag", "Lio/mpos/shared/tlv/items/TlvTag;", "assembleItem", "length", "", "tag", "parseItemLength", "parseAsTlvHexBuffer", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nTlvParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlvParser.kt\nio/mpos/shared/tlv/items/TlvParser\n+ 2 CommonResult.kt\nio/mpos/shared/CommonResultKt\n*L\n1#1,134:1\n18#2,4:135\n18#2,4:139\n18#2,4:143\n18#2,4:147\n*S KotlinDebug\n*F\n+ 1 TlvParser.kt\nio/mpos/shared/tlv/items/TlvParser\n*L\n45#1:135,4\n53#1:139,4\n54#1:143,4\n81#1:147,4\n*E\n"})
public final class TlvParser {
    @NotNull
    public final CommonResult<List<TlvItem>, TlvError> parse(@NotNull HexString hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"");
        return this.parse(HexStringTransformExtensionsKt.toBytes(hexString));
    }

    @NotNull
    public final CommonResult<List<TlvItem>, TlvError> parse(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"");
        List list = new ArrayList();
        ByteBuffer byteBuffer = new ByteBuffer(bytes);
        byteBuffer.skipHeadZeros();
        if (bytes.length == 0) {
            return new CommonResult.Success<List>(list);
        }
        do {
            CommonResult<TlvItem, TlvError> commonResult;
            CommonResult<TlvItem, TlvError> commonResult2;
            if (!((commonResult2 = (commonResult = this.parseNextItem(byteBuffer))) instanceof CommonResult.Success)) {
                if (commonResult2 instanceof CommonResult.Error) {
                    CommonResult.Error error = (CommonResult.Error)commonResult;
                    return error;
                }
                throw new NoWhenBranchMatchedException();
            }
            TlvItem tlvItem = (TlvItem)((CommonResult.Success)commonResult).getValue();
            list.add(tlvItem);
        } while (!byteBuffer.isEmpty());
        return new CommonResult.Success<List>(list);
    }

    private final CommonResult<TlvItem, TlvError> parseNextItem(ByteBuffer buffer) {
        CommonResult<TlvTag, TlvError> commonResult = this.parseNextTag(buffer);
        CommonResult<TlvTag, TlvError> commonResult2 = commonResult;
        if (!(commonResult2 instanceof CommonResult.Success)) {
            if (commonResult2 instanceof CommonResult.Error) {
                CommonResult.Error error = (CommonResult.Error)commonResult;
                return error;
            }
            throw new NoWhenBranchMatchedException();
        }
        TlvTag tlvTag = (TlvTag)((CommonResult.Success)commonResult).getValue();
        CommonResult<Integer, TlvError> commonResult3 = this.parseItemLength(buffer);
        CommonResult<Integer, TlvError> commonResult4 = commonResult3;
        if (!(commonResult4 instanceof CommonResult.Success)) {
            if (commonResult4 instanceof CommonResult.Error) {
                CommonResult.Error error = (CommonResult.Error)commonResult3;
                return error;
            }
            throw new NoWhenBranchMatchedException();
        }
        int n2 = ((Number)((CommonResult.Success)commonResult3).getValue()).intValue();
        return this.assembleItem(buffer, n2, tlvTag);
    }

    private final CommonResult<TlvTag, TlvError> parseNextTag(ByteBuffer buffer) {
        Byte by2 = buffer.next();
        if (by2 == null) {
            return new CommonResult.Error<TlvError>(new TlvError("Byte buffer is empty"));
        }
        byte by3 = by2;
        List list = new ArrayList();
        list.add(by3);
        if ((by3 & 0x1F) == 31) {
            byte by4;
            do {
                Byte by5 = buffer.next();
                if (by5 == null) {
                    return new CommonResult.Error<TlvError>(new TlvError("Byte buffer is empty, missing subsequent byte"));
                }
                by4 = by5;
                list.add(by4);
            } while ((by4 & 0x80) == 128);
        }
        return new CommonResult.Success<TlvTag>(new TlvTag(ByteArrayTransformExtensionsKt.toHexString(CollectionsKt.toByteArray((Collection)list))));
    }

    private final CommonResult<TlvItem, TlvError> assembleItem(ByteBuffer buffer, int length, TlvTag tag) {
        CommonResult commonResult;
        byte[] byArray = buffer.next(length);
        if (byArray == null) {
            return new CommonResult.Error<TlvError>(new TlvError("There are not enough bytes in buffer"));
        }
        byte[] byArray2 = byArray;
        switch (WhenMappings.$EnumSwitchMapping$0[tag.getType().ordinal()]) {
            case 1: {
                commonResult = new CommonResult.Error<TlvError>(new TlvError("Unknown type of tag, cannot assemble the item"));
                break;
            }
            case 2: {
                commonResult = new CommonResult.Success<TlvPrimitiveItem>(new TlvPrimitiveItem(tag, ByteArrayTransformExtensionsKt.toHexString(byArray2)));
                break;
            }
            case 3: {
                CommonResult<List<TlvItem>, TlvError> commonResult2;
                CommonResult<List<TlvItem>, TlvError> commonResult3 = commonResult2 = this.parse(byArray2);
                if (!(commonResult3 instanceof CommonResult.Success)) {
                    if (commonResult3 instanceof CommonResult.Error) {
                        CommonResult.Error error = (CommonResult.Error)commonResult2;
                        return error;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                List list = (List)((CommonResult.Success)commonResult2).getValue();
                commonResult = new CommonResult.Success<TlvConstructedItem>(new TlvConstructedItem(tag, (List<? extends TlvItem>)list));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return commonResult;
    }

    private final CommonResult<Integer, TlvError> parseItemLength(ByteBuffer buffer) {
        Byte by2 = buffer.next();
        if (by2 == null) {
            return new CommonResult.Error<TlvError>(new TlvError("TLV Item should have a length byte[s]"));
        }
        byte by3 = by2;
        if ((by3 & 0x80) == 0) {
            return new CommonResult.Success<Integer>(Integer.valueOf(by3));
        }
        if ((by3 & 0x7F) > 4) {
            return new CommonResult.Error<TlvError>(new TlvError("Length byte exceed 4 bytes valueFrom"));
        }
        int n2 = by3 & 0x7F;
        if (!buffer.hasMore(n2)) {
            return new CommonResult.Error<TlvError>(new TlvError("Wrong length byte valueFrom"));
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Byte by4 = buffer.next();
            Intrinsics.checkNotNull((Object)by4);
            n3 = n3 << 8 | by4;
        }
        return new CommonResult.Success<Integer>(n3);
    }

    @NotNull
    public final CommonResult<List<TlvItem>, TlvError> parseAsTlvHexBuffer(@NotNull HexString hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"");
        if (hexString.getLength() < 2) {
            return new CommonResult.Error<TlvError>(new TlvError("HexString is too short to parse as a Tlv hex buffer: " + hexString));
        }
        Pair<HexString, HexString> pair = hexString.splitFromStart(2);
        HexString hexString2 = (HexString)pair.component1();
        HexString hexString3 = (HexString)pair.component2();
        int n2 = ByteArrayTransformExtensionsKt.toInt(HexStringTransformExtensionsKt.toBytes(hexString2));
        if (hexString3.getLength() != n2) {
            TlvError tlvError = new TlvError("Length field does not match the measured length: " + n2 + " != " + hexString3.getLength() + ", for hex string: " + hexString);
            return new CommonResult.Error<TlvError>(tlvError);
        }
        return this.parse(HexStringTransformExtensionsKt.toBytes(hexString3));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TagType.values().length];
            try {
                nArray[TagType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TagType.PRIMITIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TagType.CONSTRUCTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

