/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv.items;

import io.mpos.shared.PrimitiveTypesTransformExtensionsKt;
import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringKt;
import io.mpos.shared.hexstring.HexStringTransformExtensionsKt;
import io.mpos.shared.tlv.items.TlvConstructedItem;
import io.mpos.shared.tlv.items.TlvItem;
import io.mpos.shared.tlv.items.TlvPrimitiveItem;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\u0010"}, d2={"Lio/mpos/shared/tlv/items/TlvSerializer;", "", "<init>", "()V", "serializedLength", "", "length", "", "serialize", "items", "", "Lio/mpos/shared/tlv/items/TlvItem;", "item", "serializeToTlvHexBuffer", "Lio/mpos/shared/hexstring/HexString;", "Companion", "mpos.core"})
public final class TlvSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_LENGTH_FOR_7_BITS = 127;

    private final byte[] serializedLength(int length) {
        if (length <= 127) {
            byte[] byArray = new byte[]{(byte)length};
            return byArray;
        }
        byte[] byArray = PrimitiveTypesTransformExtensionsKt.toVariableLengthByteArray(length);
        byte[] byArray2 = new byte[]{(byte)(0x80 | byArray.length)};
        byte[] byArray3 = byArray2;
        return ArraysKt.plus((byte[])byArray3, (byte[])byArray);
    }

    @NotNull
    public final byte[] serialize(@NotNull Iterable<? extends TlvItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"");
        byte[] byArray = new byte[]{};
        for (TlvItem tlvItem : items) {
            byArray = ArraysKt.plus((byte[])byArray, (byte[])this.serialize(tlvItem));
        }
        return byArray;
    }

    @NotNull
    public final byte[] serialize(@NotNull TlvItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"");
        byte[] byArray = new byte[]{};
        TlvItem tlvItem = item;
        if (tlvItem instanceof TlvPrimitiveItem) {
            byte[] byArray2 = HexStringTransformExtensionsKt.toBytes(((TlvPrimitiveItem)item).getValue());
            byArray = ArraysKt.plus((byte[])byArray, (byte[])HexStringTransformExtensionsKt.toBytes(((TlvPrimitiveItem)item).getTag().getValue()));
            byArray = ArraysKt.plus((byte[])byArray, (byte[])this.serializedLength(byArray2.length));
            byArray = ArraysKt.plus((byte[])byArray, (byte[])byArray2);
        } else if (tlvItem instanceof TlvConstructedItem) {
            byte[] byArray3 = new byte[]{};
            for (TlvItem tlvItem2 : ((TlvConstructedItem)item).getSubitems()) {
                byArray3 = ArraysKt.plus((byte[])byArray3, (byte[])this.serialize(tlvItem2));
            }
            byArray = ArraysKt.plus((byte[])byArray, (byte[])HexStringTransformExtensionsKt.toBytes(((TlvConstructedItem)item).getTag().getValue()));
            byArray = ArraysKt.plus((byte[])byArray, (byte[])this.serializedLength(byArray3.length));
            byArray = ArraysKt.plus((byte[])byArray, (byte[])byArray3);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }

    @NotNull
    public final HexString serializeToTlvHexBuffer(@NotNull Iterable<? extends TlvItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"");
        HexString hexString = ByteArrayTransformExtensionsKt.toHexString(this.serialize(items));
        HexString hexString2 = ByteArrayTransformExtensionsKt.toHexString(PrimitiveTypesTransformExtensionsKt.toByteArray(hexString.getLength(), 2));
        return HexStringKt.hex("" + hexString2 + hexString);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/mpos/shared/tlv/items/TlvSerializer$Companion;", "", "<init>", "()V", "MAX_LENGTH_FOR_7_BITS", "", "mpos.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

