/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv.references;

import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringKt;
import io.mpos.shared.hexstring.HexStringTransformExtensionsKt;
import io.mpos.shared.tlv.references.TlvMapper;
import io.mpos.time.DateFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/mpos/shared/tlv/references/DateMapper;", "Lio/mpos/shared/tlv/references/TlvMapper;", "Ljava/util/Date;", "<init>", "()V", "dateFormatter", "Lio/mpos/time/DateFormatter;", "toValue", "rawData", "Lio/mpos/shared/hexstring/HexString;", "fromValue", "value", "mpos.core"})
public final class DateMapper
implements TlvMapper<Date> {
    @NotNull
    public static final DateMapper INSTANCE = new DateMapper();
    @NotNull
    private static final DateFormatter dateFormatter = new DateFormatter("yyMMdd");

    private DateMapper() {
    }

    @Override
    @Nullable
    public Date toValue(@NotNull HexString rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"");
        return dateFormatter.dateFromString(rawData.toString());
    }

    @Override
    @NotNull
    public HexString fromValue(@NotNull Date value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        HexString hexString = HexStringTransformExtensionsKt.toHexString(dateFormatter.stringFromDate(value));
        if (hexString == null) {
            hexString = HexStringKt.hex("000000");
        }
        return hexString;
    }

    @Override
    public byte getPadding() {
        return TlvMapper.DefaultImpls.getPadding(this);
    }
}

