/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider.processparameters.steps.tipping;

import io.mpos.network.impl.schema.TransactionMetadataKey;
import io.mpos.shared.transactionprovider.processparameters.steps.tipping.AmountOrPercentage;
import io.mpos.shared.transactions.TransactionAmount;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0001\u001a\u0019\u0010\b\u001a\u00020\u0001*\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\n*\u00020\u0001\u001a\u0018\u0010\r\u001a\u00020\u0001*\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a8\u0006\u0010"}, d2={"getMaxTipAmount", "Ljava/math/BigDecimal;", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$BasicTippingParameters;", "transactionAmount", "Lio/mpos/shared/transactions/TransactionAmount;", "getMaxTipAmountForDisplay", "getDefaultInputAmount", "taxAmount", "limitScale", "scale", "", "(Ljava/math/BigDecimal;Ljava/lang/Integer;)Ljava/math/BigDecimal;", "getFractionDigits", "calculateTotalTax", "", "", "mpos.core"})
public final class TippingUtilsKt {
    @Nullable
    public static final BigDecimal getMaxTipAmount(@NotNull TippingParameters.BasicTippingParameters $this$getMaxTipAmount, @NotNull TransactionAmount transactionAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxTipAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        AmountOrPercentage amountOrPercentage = $this$getMaxTipAmount.getMaxTip();
        return amountOrPercentage != null ? amountOrPercentage.getAmount(transactionAmount) : null;
    }

    @Nullable
    public static final BigDecimal getMaxTipAmountForDisplay(@NotNull TippingParameters.BasicTippingParameters $this$getMaxTipAmountForDisplay, @NotNull TransactionAmount transactionAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxTipAmountForDisplay, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        BigDecimal bigDecimal = TippingUtilsKt.getMaxTipAmount($this$getMaxTipAmountForDisplay, transactionAmount);
        return bigDecimal != null ? TippingUtilsKt.limitScale(bigDecimal, $this$getMaxTipAmountForDisplay.getFractionDigits()) : null;
    }

    @Nullable
    public static final BigDecimal getDefaultInputAmount(@NotNull TippingParameters.BasicTippingParameters $this$getDefaultInputAmount, @NotNull TransactionAmount transactionAmount, @NotNull BigDecimal taxAmount) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultInputAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)taxAmount, (String)"");
        BigDecimal bigDecimal2 = transactionAmount.getAmount().subtract(taxAmount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        TransactionAmount transactionAmount2 = new TransactionAmount(bigDecimal2, transactionAmount.getCurrency());
        TippingParameters.BasicTippingParameters basicTippingParameters = $this$getDefaultInputAmount;
        if (basicTippingParameters instanceof TippingParameters.BasicTippingParameters.Normal) {
            AmountOrPercentage amountOrPercentage = ((TippingParameters.BasicTippingParameters.Normal)$this$getDefaultInputAmount).getSuggestedTip();
            bigDecimal = amountOrPercentage != null ? amountOrPercentage.getAmount(transactionAmount2) : null;
        } else if (basicTippingParameters instanceof TippingParameters.BasicTippingParameters.Total) {
            Object object = ((TippingParameters.BasicTippingParameters.Total)$this$getDefaultInputAmount).getSuggestedTip();
            if (object != null && (object = object.getAmount(transactionAmount2)) != null) {
                BigDecimal bigDecimal3 = ((BigDecimal)object).add(transactionAmount.getAmount());
                bigDecimal = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"");
            } else {
                bigDecimal = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BigDecimal bigDecimal4 = bigDecimal;
        return bigDecimal4 != null ? TippingUtilsKt.limitScale(bigDecimal4, $this$getDefaultInputAmount.getFractionDigits()) : null;
    }

    public static /* synthetic */ BigDecimal getDefaultInputAmount$default(TippingParameters.BasicTippingParameters basicTippingParameters, TransactionAmount transactionAmount, BigDecimal bigDecimal, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bigDecimal = BigDecimal.ZERO;
        }
        return TippingUtilsKt.getDefaultInputAmount(basicTippingParameters, transactionAmount, bigDecimal);
    }

    @NotNull
    public static final BigDecimal limitScale(@NotNull BigDecimal $this$limitScale, @Nullable Integer scale) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$limitScale, (String)"");
        if (scale != null && $this$limitScale.scale() > scale) {
            BigDecimal bigDecimal2 = $this$limitScale.setScale((int)scale, RoundingMode.DOWN);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        } else {
            bigDecimal = $this$limitScale;
        }
        return bigDecimal;
    }

    public static final int getFractionDigits(@NotNull BigDecimal $this$getFractionDigits) {
        Intrinsics.checkNotNullParameter((Object)$this$getFractionDigits, (String)"");
        return $this$getFractionDigits.stripTrailingZeros().scale();
    }

    @NotNull
    public static final BigDecimal calculateTotalTax(@Nullable Map<String, String> $this$calculateTotalTax) {
        if ($this$calculateTotalTax == null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(0L);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"");
            return bigDecimal;
        }
        Object object = $this$calculateTotalTax.get(TransactionMetadataKey.TAX_AMOUNT.getKey());
        BigDecimal bigDecimal = object != null ? new BigDecimal((String)object) : BigDecimal.ZERO;
        Object object2 = $this$calculateTotalTax.get(TransactionMetadataKey.LOCAL_TAX_AMOUNT.getKey());
        object = object2 != null ? new BigDecimal((String)object2) : BigDecimal.ZERO;
        Object object3 = $this$calculateTotalTax.get(TransactionMetadataKey.NATIONAL_TAX_AMOUNT.getKey());
        object2 = object3 != null ? new BigDecimal((String)object3) : BigDecimal.ZERO;
        Intrinsics.checkNotNull((Object)bigDecimal);
        Intrinsics.checkNotNull((Object)object);
        BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)object);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        Intrinsics.checkNotNull((Object)object2);
        BigDecimal bigDecimal3 = bigDecimal2.add((BigDecimal)object2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"");
        object3 = bigDecimal3;
        return object3;
    }
}

