/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.transactions.Country;
import io.mpos.shared.transactions.CountryWrapper$CountryData$;
import io.mpos.transactions.Currency;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/mpos/shared/transactions/CountryWrapper;", "", "country", "Lio/mpos/shared/transactions/Country;", "<init>", "(Lio/mpos/shared/transactions/Country;)V", "countryMetadata", "Lio/mpos/shared/transactions/CountryWrapper$CountryData;", "getIsoCode", "", "getIsoNumber", "", "getCurrency", "Lio/mpos/transactions/Currency;", "getName", "Companion", "CountryData", "mpos.core"})
public final class CountryWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Country country;
    @NotNull
    private final CountryData countryMetadata;
    @NotNull
    private static final String COUNTRY_ASSET_REFERENCE = "io.payworks.mpos.resources/countries.json";
    private static Map<Country, CountryData> AVAILABLE_COUNTRY_METADATA;
    @NotNull
    private static final Lazy<Map<Country, CountryData>> metaData$delegate;

    public CountryWrapper(@Nullable Country country) {
        Country country2 = country;
        if (country2 == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "Trying to create country metadata without valid reference"));
        }
        this.country = country2;
        CountryData countryData = (CountryData)CountryWrapper.Companion.getMetaData().get((Object)country);
        if (countryData == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "No country information available for " + country.name()));
        }
        this.countryMetadata = countryData;
    }

    @NotNull
    public final String getIsoCode() {
        return this.country.name();
    }

    public final int getIsoNumber() {
        return this.countryMetadata.getIsoNumber();
    }

    @Nullable
    public final Currency getCurrency() {
        return this.countryMetadata.getCurrency();
    }

    @Nullable
    public final String getName() {
        return this.countryMetadata.getName();
    }

    private static final Map metaData_delegate$lambda$0() {
        AssetsHandler assetsHandler = AssetsHandler.getInstance();
        if (assetsHandler == null) {
            throw new NullPointerException("AssetsHandler.init needs to be called first");
        }
        AssetsHandler assetsHandler2 = assetsHandler;
        AVAILABLE_COUNTRY_METADATA = assetsHandler2.mapJSONAssetGeneric(COUNTRY_ASSET_REFERENCE, Country.class, CountryData.class);
        Map<Country, CountryData> map = AVAILABLE_COUNTRY_METADATA;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            map = null;
        }
        return map;
    }

    @JvmStatic
    @NotNull
    public static final Currency currencyForCountry(@Nullable Country country) {
        return Companion.currencyForCountry(country);
    }

    @JvmStatic
    @NotNull
    public static final String alpha2IsoCodeForIsoNumber(int isoNumber) {
        return Companion.alpha2IsoCodeForIsoNumber(isoNumber);
    }

    @JvmStatic
    @NotNull
    public static final Currency currencyForCountryIsoNumber(int isoNumber) {
        return Companion.currencyForCountryIsoNumber(isoNumber);
    }

    static {
        metaData$delegate = LazyKt.lazy(CountryWrapper::metaData_delegate$lambda$0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/mpos/shared/transactions/CountryWrapper$Companion;", "", "<init>", "()V", "COUNTRY_ASSET_REFERENCE", "", "AVAILABLE_COUNTRY_METADATA", "", "Lio/mpos/shared/transactions/Country;", "Lio/mpos/shared/transactions/CountryWrapper$CountryData;", "metaData", "getMetaData", "()Ljava/util/Map;", "metaData$delegate", "Lkotlin/Lazy;", "currencyForCountry", "Lio/mpos/transactions/Currency;", "country", "alpha2IsoCodeForIsoNumber", "isoNumber", "", "currencyForCountryIsoNumber", "mpos.core"})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized Map<Country, CountryData> getMetaData() throws MposRuntimeException {
            Lazy lazy = metaData$delegate;
            return (Map)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Currency currencyForCountry(@Nullable Country country) {
            CountryWrapper countryWrapper = new CountryWrapper(country);
            Currency currency = countryWrapper.getCurrency();
            if (currency == null) {
                return Currency.UNKNOWN;
            }
            return currency;
        }

        @JvmStatic
        @NotNull
        public final String alpha2IsoCodeForIsoNumber(int isoNumber) {
            for (Map.Entry<Country, CountryData> entry : this.getMetaData().entrySet()) {
                Country country = entry.getKey();
                CountryData countryData = entry.getValue();
                if (countryData.getIsoNumber() != isoNumber) continue;
                String string = country.name();
                return string.length() == 2 ? string : "";
            }
            return "";
        }

        @JvmStatic
        @NotNull
        public final Currency currencyForCountryIsoNumber(int isoNumber) {
            Iterator<Map.Entry<Country, CountryData>> iterator = this.getMetaData().entrySet().iterator();
            while (iterator.hasNext()) {
                CountryData countryData = iterator.next().getValue();
                if (countryData.getIsoNumber() != isoNumber) continue;
                Currency currency = countryData.getCurrency();
                if (currency == null) {
                    currency = Currency.UNKNOWN;
                }
                return currency;
            }
            return Currency.UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B7\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0002\u0010\rJ%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lio/mpos/shared/transactions/CountryWrapper$CountryData;", "", "<init>", "()V", "seen0", "", "currency", "Lio/mpos/transactions/Currency;", "isoNumber", "name", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILio/mpos/transactions/Currency;ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCurrency", "()Lio/mpos/transactions/Currency;", "getIsoNumber", "()I", "setIsoNumber", "(I)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$mpos_core", "$serializer", "Companion", "mpos.core"})
    public static final class CountryData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Currency currency;
        private int isoNumber;
        @Nullable
        private String name;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public CountryData() {
        }

        @Nullable
        public final Currency getCurrency() {
            return this.currency;
        }

        public final int getIsoNumber() {
            return this.isoNumber;
        }

        public final void setIsoNumber(int n2) {
            this.isoNumber = n2;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$mpos_core(CountryData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.currency != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], (Object)self.currency);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.isoNumber != 0) {
                output.encodeIntElement(serialDesc, 1, self.isoNumber);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.name != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.name);
            }
        }

        public /* synthetic */ CountryData(int seen0, Currency currency, int isoNumber, String name, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)CountryData$$serializer.INSTANCE.getDescriptor());
            }
            this.currency = (seen0 & 1) == 0 ? null : currency;
            this.isoNumber = (seen0 & 2) == 0 ? 0 : isoNumber;
            this.name = (seen0 & 4) == 0 ? null : name;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{EnumsKt.createSimpleEnumSerializer((String)"io.mpos.transactions.Currency", (Enum[])((Enum[])Currency.values())), null, null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lio/mpos/shared/transactions/CountryWrapper$CountryData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lio/mpos/shared/transactions/CountryWrapper$CountryData;", "mpos.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<CountryData> serializer() {
                return (KSerializer)CountryData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

