/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.provider.CardHelper;
import io.mpos.transactions.CardDetails;

public class DefaultCardDetails
implements CardDetails {
    private String cardholderName;
    private String fingerprint;
    private String maskedCardNumber;
    private PaymentDetailsScheme scheme;
    private String track1;
    private String track2;
    private String track3;
    private String cardNumber;
    private String countryCodeNumeric;
    private int expiryMonth;
    private int expiryYear;

    public DefaultCardDetails() {
    }

    public DefaultCardDetails(MagstripeInformation magstripeInformation) {
        this.track1 = magstripeInformation.getUnencryptedTrack1();
        this.track2 = magstripeInformation.getUnencryptedTrack2();
        this.track3 = magstripeInformation.getUnencryptedTrack3();
        this.maskedCardNumber = magstripeInformation.getMaskedAccountNumber();
        String string = magstripeInformation.getUnencryptedTrack2();
        if (string != null) {
            this.cardNumber = CardHelper.parseAccountNumberFromTrack2(string);
        } else {
            string = magstripeInformation.getMaskedTrack2();
        }
        String string2 = CardHelper.parseExpiryDateFromTrack2(string);
        String string3 = CardHelper.expiryYearFromExpiryDate(string2);
        String string4 = CardHelper.expiryMonthFromExpiryDate(string2);
        if (string3 != null) {
            this.expiryYear = Integer.parseInt(string3);
        }
        if (string4 != null) {
            this.expiryMonth = Integer.parseInt(string4);
        }
    }

    public String getCardHolderName() {
        return this.cardholderName;
    }

    public int getExpiryMonth() {
        return this.expiryMonth;
    }

    public int getExpiryYear() {
        return this.expiryYear;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getMaskedCardNumber() {
        return this.maskedCardNumber;
    }

    public PaymentDetailsScheme getScheme() {
        return this.scheme;
    }

    public String getTrack1() {
        return this.track1;
    }

    public String getTrack2() {
        return this.track2;
    }

    public String getTrack3() {
        return this.track3;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getCountryCodeNumeric() {
        return this.countryCodeNumeric;
    }

    public void setTrack1(String track1) {
        this.track1 = track1;
    }

    public void setTrack2(String track2) {
        this.track2 = track2;
    }

    public void setTrack3(String track3) {
        this.track3 = track3;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardholderName = cardHolderName;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setMaskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    public void setScheme(PaymentDetailsScheme scheme) {
        this.scheme = scheme;
    }

    public void setCountryCodeNumeric(String countryCodeNumeric) {
        this.countryCodeNumeric = countryCodeNumeric;
    }

    public void setExpiryMonth(int expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public void setExpiryYear(int expiryYear) {
        this.expiryYear = expiryYear;
    }

    public void mergeWithCardDetails(CardDetails cardDetails) {
        this.cardholderName = cardDetails.getCardHolderName();
        this.fingerprint = cardDetails.getFingerprint();
        this.maskedCardNumber = cardDetails.getMaskedCardNumber();
        this.scheme = cardDetails.getScheme();
        this.countryCodeNumeric = cardDetails.getCountryCodeNumeric();
        this.expiryMonth = cardDetails.getExpiryMonth();
        this.expiryYear = cardDetails.getExpiryYear();
    }

    public String toString() {
        return "DefaultCardDetails{cardholderName='" + this.cardholderName + "', fingerprint='" + this.fingerprint + "', maskedCardNumber='" + this.maskedCardNumber + "', scheme=" + this.scheme + ", track1='" + this.track1 + "', track2='" + this.track2 + "', track3='" + this.track3 + "', cardNumber='" + this.cardNumber + "', countryCode=" + this.countryCodeNumeric + ", expirationMonth=" + this.expiryMonth + ", expirationYear=" + this.expiryYear + "}";
    }
}

