/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.accessories.AccessoryDetails;
import io.mpos.core.common.obfuscated.ei;
import io.mpos.core.common.obfuscated.ey;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.paymentdetails.InteracAccountType;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.provider.Provider;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.providercomponent.TransactionStateChangedBusEvent;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPaymentDetailsFactory;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultCardDetails;
import io.mpos.shared.transactions.DefaultDccDetails;
import io.mpos.shared.transactions.DefaultEbtDetails;
import io.mpos.shared.transactions.DefaultGiftCardDetails;
import io.mpos.shared.transactions.DefaultIncrementalAuthorizationDetails;
import io.mpos.shared.transactions.DefaultInstallmentDetails;
import io.mpos.shared.transactions.DefaultMerchantDetails;
import io.mpos.shared.transactions.DefaultProcessingDetails;
import io.mpos.shared.transactions.DefaultReceiptDetails;
import io.mpos.shared.transactions.DefaultRefundDetails;
import io.mpos.shared.transactions.DefaultShopperDetails;
import io.mpos.shared.transactions.DefaultTaxDetails;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.transactions.DefaultTransactionVerificationResults;
import io.mpos.shared.transactions.TransactionFlags;
import io.mpos.shared.transactions.receipts.ReceiptDetails;
import io.mpos.shared.workflows.WorkflowInteraction;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.emv.TagAuthorisationResponseCode;
import io.mpos.specs.helper.EnDecodeHelper;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import io.mpos.transactions.CardDetails;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DccDetails;
import io.mpos.transactions.DefaultTransactionDetails;
import io.mpos.transactions.EbtDetails;
import io.mpos.transactions.GiftCardDetails;
import io.mpos.transactions.IncrementalAuthorizationDetails;
import io.mpos.transactions.InstallmentDetails;
import io.mpos.transactions.MerchantDetails;
import io.mpos.transactions.ProcessingDetails;
import io.mpos.transactions.RefundDetails;
import io.mpos.transactions.ShopperDetails;
import io.mpos.transactions.TaxDetails;
import io.mpos.transactions.TransactionDetails;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionVerificationResult;
import io.mpos.transactions.TransactionVerificationResults;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.parameters.WorkflowConfiguration;
import io.mpos.transactions.receipts.ClearingDetails;
import io.mpos.transactions.receipts.Receipt;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTransaction
implements BaseTransaction {
    private static final String TAG = "Transaction";
    private static final byte[] HONOR_WITH_IDENTIFICATION_CODE = EnDecodeHelper.toHex("30:38");
    private BigDecimal mAmount;
    private Currency mCurrency;
    private String mSubject;
    private TransactionType mType;
    private TransactionMode mMode;
    private TransactionType mInternalTypeOverride;
    @Nullable
    private InteracAccountType mInteracAccountType;
    @Nullable
    private Locale mSelectedLanguage;
    private boolean mAutoCapture;
    private TransactionState mState;
    private TransactionStatus mStatus;
    private DefaultTransactionStatusDetails mStatusDetails;
    private MposError mError;
    private String mSessionIdentifier;
    private String mIdentifier;
    private String mGroupIdentifier;
    private String mReferencedTransactionIdentifier;
    private String mCustomIdentifier;
    private long mCreatedTimestamp;
    private boolean mCaptured;
    private TransactionDetails mDetails;
    private PaymentDetails mPaymentDetails;
    private ReceiptDetails mReceiptDetails;
    private ProcessingDetails mProcessingDetails;
    private RefundDetails mRefundDetails;
    private ClearingDetails mClearingDetails;
    private CardDetails mCardDetails;
    private ShopperDetails mShopperDetails;
    private DccDetails mDccDetails;
    private TransactionVerificationResults mTransactionVerificationResults;
    @NotNull
    private GiftCardDetails mGiftCardDetails;
    private EbtDetails mEbtDetails;
    private IncrementalAuthorizationDetails incrementalAuthorizationDetails;
    private Receipt mMerchantReceipt;
    private Receipt mCustomerReceipt;
    private Provider mProvider;
    private AccessoryDetails mAccessoryDetails;
    private String mConfigurationToken;
    private WorkflowInteraction mWorkflowInteraction;
    private ey mWorkflowAbort;
    private TransactionWorkflowType mTransactionWorkflowType;
    private WorkflowConfiguration mWorkflowConfiguration;
    private String mSdkUniqueIdentifier;
    private TransactionFlags mFlags;
    private AbstractPaymentAccessory mAccessory;
    private DefaultTransaction mPreviousTransaction;
    private boolean mUnableToGoOnline = false;
    private TimeZone createdTimeZone;
    private boolean overwriteTypeToRefund = false;
    private TippingParameters tippingParameters;
    private MerchantDetails mMerchantDetails;
    private TaxDetails mTaxDetails;
    private InstallmentDetails mInstallmentDetails;

    public DefaultTransaction(BigDecimal amount, Currency currency, TransactionType type) {
        this.mAmount = amount;
        this.mCurrency = currency;
        this.mStatus = TransactionStatus.INITIALIZED;
        this.mMode = TransactionMode.ONLINE;
        this.mStatusDetails = new DefaultTransactionStatusDetails();
        this.mType = type;
        this.mInternalTypeOverride = TransactionType.UNKNOWN;
        this.mAutoCapture = true;
        this.mIdentifier = null;
        this.mCustomIdentifier = null;
        this.mCreatedTimestamp = 0L;
        this.mDetails = new DefaultTransactionDetails();
        this.mReceiptDetails = new DefaultReceiptDetails();
        this.mProcessingDetails = new DefaultProcessingDetails();
        this.mPaymentDetails = new DefaultPaymentDetailsFactory().createPaymentDetails(PaymentDetailsScheme.UNKNOWN);
        this.mRefundDetails = new DefaultRefundDetails();
        this.mClearingDetails = new ei();
        this.mCardDetails = new DefaultCardDetails();
        this.mShopperDetails = new DefaultShopperDetails();
        this.mDccDetails = new DefaultDccDetails();
        this.mGiftCardDetails = new DefaultGiftCardDetails();
        this.mEbtDetails = new DefaultEbtDetails();
        this.mAccessoryDetails = new DefaultAccessoryDetails(null, null, null, null);
        this.mTransactionVerificationResults = new DefaultTransactionVerificationResults(TransactionVerificationResult.UNKNOWN, TransactionVerificationResult.UNKNOWN, TransactionVerificationResult.UNKNOWN);
        this.incrementalAuthorizationDetails = new DefaultIncrementalAuthorizationDetails();
        this.mError = null;
        this.mSdkUniqueIdentifier = Helper.createRandomUUID();
        this.mFlags = new TransactionFlags();
        this.mTransactionWorkflowType = TransactionWorkflowType.UNKNOWN;
        this.mMerchantDetails = new DefaultMerchantDetails();
        this.mTaxDetails = new DefaultTaxDetails();
        this.mInstallmentDetails = new DefaultInstallmentDetails();
    }

    public void mergeWithTransaction(BaseTransaction transaction) {
        if (((DefaultTransaction)transaction).getConfigurationToken() != null) {
            this.mConfigurationToken = ((DefaultTransaction)transaction).getConfigurationToken();
        }
        if (transaction.getMode() != null) {
            this.mMode = transaction.getMode();
        }
        if (transaction.getSessionIdentifier() != null) {
            this.mSessionIdentifier = transaction.getSessionIdentifier();
        }
        if (transaction.getIdentifier() != null) {
            this.mIdentifier = transaction.getIdentifier();
        }
        if (transaction.getAmount() != null && !transaction.getAmount().equals(new BigDecimal("0.0"))) {
            this.mAmount = transaction.getAmount();
        }
        if (transaction.getGroupIdentifier() != null) {
            this.mGroupIdentifier = transaction.getGroupIdentifier();
        }
        if (transaction.getReferencedTransactionIdentifier() != null) {
            this.mReferencedTransactionIdentifier = transaction.getReferencedTransactionIdentifier();
        }
        if (transaction.getCurrency() != null) {
            this.mCurrency = transaction.getCurrency();
        }
        if (transaction.getCreatedTimestamp() > 0L) {
            this.mCreatedTimestamp = transaction.getCreatedTimestamp();
        }
        this.mCaptured = transaction.isCaptured();
        if (transaction.getStatus() != null) {
            this.mStatus = transaction.getStatus();
        }
        if (transaction.getType() != null) {
            this.mType = transaction.getType();
        }
        this.mAutoCapture = ((DefaultTransaction)transaction).isAutoCapture();
        if (transaction.getCustomIdentifier() != null) {
            this.mCustomIdentifier = transaction.getCustomIdentifier();
        }
        if (transaction.getSubject() != null) {
            this.mSubject = transaction.getSubject();
        }
        if (transaction.getPaymentDetails() != null) {
            ((DefaultPaymentDetails)this.mPaymentDetails).mergeWithPaymentDetails(transaction.getPaymentDetails());
        }
        if (transaction.getProcessingDetails() != null) {
            ((DefaultProcessingDetails)this.mProcessingDetails).mergeWithProcessingDetails(transaction.getProcessingDetails(), this.mSessionIdentifier != null);
        }
        if (transaction.getClearingDetails() != null) {
            ((ei)this.mClearingDetails).a(transaction.getClearingDetails());
        }
        if (transaction.getCardDetails() != null) {
            ((DefaultCardDetails)this.mCardDetails).mergeWithCardDetails(transaction.getCardDetails());
        }
        if (transaction.getShopperDetails() != null) {
            ((DefaultShopperDetails)this.mShopperDetails).mergeWithShopperDetails(transaction.getShopperDetails());
        }
        if (transaction.getDccDetails() != null) {
            ((DefaultDccDetails)this.mDccDetails).mergeWithDccDetails(transaction.getDccDetails());
        }
        if (transaction.getGiftCardDetails() != null) {
            ((DefaultGiftCardDetails)this.mGiftCardDetails).mergeWithGiftCardDetails(transaction.getGiftCardDetails());
        }
        if (transaction.getEbtDetails() != null) {
            ((DefaultEbtDetails)this.mEbtDetails).mergeWithEbtDetails(transaction.getEbtDetails());
        }
        if (((DefaultTransaction)transaction).getReceiptDetails() != null) {
            ((DefaultReceiptDetails)this.mReceiptDetails).mergeWithReceiptDetails(((DefaultTransaction)transaction).getReceiptDetails());
        }
        if (transaction.getStatusDetails() != null) {
            this.mStatusDetails.mergeWithStatusDetails(transaction.getStatusDetails());
        }
        if (transaction.getRefundDetails() != null) {
            ((DefaultRefundDetails)this.mRefundDetails).mergeWithRefundDetails(transaction.getRefundDetails());
        }
        if (((DefaultTransaction)transaction).getPreviousTransaction() != null) {
            this.mPreviousTransaction = ((DefaultTransaction)transaction).getPreviousTransaction();
        }
        if (transaction.getMerchantReceipt() != null) {
            this.mMerchantReceipt = transaction.getMerchantReceipt();
        }
        if (transaction.getCustomerReceipt() != null) {
            this.mCustomerReceipt = transaction.getCustomerReceipt();
        }
        if (transaction.getDetails() != null) {
            ((DefaultTransactionDetails)this.mDetails).mergeWithTransactionDetails(transaction.getDetails());
        }
        if (transaction.getAccessoryDetails() != null) {
            ((DefaultAccessoryDetails)this.mAccessoryDetails).mergeWithAccessoryDetails((DefaultAccessoryDetails)transaction.getAccessoryDetails());
        }
        if (transaction.getVerificationResults() != null) {
            this.mTransactionVerificationResults = transaction.getVerificationResults();
        }
        if (transaction.getIncrementalAuthorizationDetails() != null) {
            ((DefaultIncrementalAuthorizationDetails)this.incrementalAuthorizationDetails).mergeWithIncrementalAuthorizationDetails(transaction.getIncrementalAuthorizationDetails());
        }
        if (transaction.getMerchantDetails() != null) {
            ((DefaultMerchantDetails)this.mMerchantDetails).mergeWithMerchantDetails(transaction.getMerchantDetails());
        }
        if (transaction.getTaxDetails() != null) {
            ((DefaultTaxDetails)this.mTaxDetails).mergeWithTaxDetails(transaction.getTaxDetails());
        }
        if (transaction.getInstallmentDetails() != null) {
            ((DefaultInstallmentDetails)this.mInstallmentDetails).mergeWithInstallmentDetails(transaction.getInstallmentDetails());
        }
    }

    public boolean isCustomerIdentificationRequired() {
        if (this.getPaymentDetails().getSource() != PaymentDetailsSource.ICC) {
            return false;
        }
        if (this.getPaymentDetails().getScheme() != PaymentDetailsScheme.MASTERCARD) {
            return false;
        }
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)this.getPaymentDetails());
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagAuthorisationResponseCode.TAG_BYTES, paymentDetailsIccWrapper.getDataArpc());
        if (primitiveTlv == null || !primitiveTlv.hasThisTag(TagAuthorisationResponseCode.TAG_BYTES)) {
            return false;
        }
        TagAuthorisationResponseCode tagAuthorisationResponseCode = TagAuthorisationResponseCode.wrap(primitiveTlv);
        byte[] byArray = tagAuthorisationResponseCode.getValue();
        String cfr_ignored_0 = "comparing: actualArc=" + EnDecodeHelper.fromHex(byArray) + " with honorArc=" + EnDecodeHelper.fromHex(HONOR_WITH_IDENTIFICATION_CODE);
        boolean bl2 = EnDecodeHelper.fromHex(byArray).equals(EnDecodeHelper.fromHex(HONOR_WITH_IDENTIFICATION_CODE));
        return bl2;
    }

    @Override
    public BigDecimal getAmount() {
        return this.mAmount;
    }

    @Override
    public Currency getCurrency() {
        return this.mCurrency;
    }

    @Override
    @Nullable
    public String getSubject() {
        return this.mSubject;
    }

    @Override
    public TransactionType getType() {
        return this.mType;
    }

    public void setType(TransactionType type) {
        this.mType = type;
    }

    @Override
    public TransactionMode getMode() {
        return this.mMode;
    }

    public void setMode(TransactionMode mode) {
        this.mMode = mode;
    }

    public TransactionType getInternalTypeOverride() {
        return this.mInternalTypeOverride;
    }

    @Override
    public boolean isCaptured() {
        return this.mCaptured;
    }

    @Override
    public TransactionDetails getDetails() {
        return this.mDetails;
    }

    @Override
    public PaymentDetails getPaymentDetails() {
        return this.mPaymentDetails;
    }

    @Override
    public RefundDetails getRefundDetails() {
        return this.mRefundDetails;
    }

    @Override
    public ClearingDetails getClearingDetails() {
        return this.mClearingDetails;
    }

    @Override
    public CardDetails getCardDetails() {
        return this.mCardDetails;
    }

    @Override
    public ShopperDetails getShopperDetails() {
        return this.mShopperDetails;
    }

    @Override
    public DccDetails getDccDetails() {
        return this.mDccDetails;
    }

    @Override
    public GiftCardDetails getGiftCardDetails() {
        return this.mGiftCardDetails;
    }

    @Override
    public EbtDetails getEbtDetails() {
        return this.mEbtDetails;
    }

    @Override
    public TransactionState getState() {
        return this.mState;
    }

    public void setState(TransactionState state) {
        this.mState = state;
    }

    @Override
    public TransactionStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public DefaultTransactionStatusDetails getStatusDetails() {
        return this.mStatusDetails;
    }

    @Override
    public MposError getError() {
        if (this.mError == null && this.mStatusDetails != null) {
            this.mError = new DefaultMposError(ErrorType.TRANSACTION_ERROR, this.mStatusDetails.getDeveloperDescription());
        }
        return this.mError;
    }

    public void setError(MposError error) {
        this.mError = error;
    }

    @Override
    public String getSessionIdentifier() {
        return this.mSessionIdentifier;
    }

    @Override
    public String getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public String getGroupIdentifier() {
        return this.mGroupIdentifier;
    }

    @Override
    public String getReferencedTransactionIdentifier() {
        return this.mReferencedTransactionIdentifier;
    }

    @Override
    @Nullable
    public String getCustomIdentifier() {
        return this.mCustomIdentifier;
    }

    @Override
    public long getCreatedTimestamp() {
        return this.mCreatedTimestamp;
    }

    @Override
    public ReceiptDetails getReceiptDetails() {
        return this.mReceiptDetails;
    }

    @Override
    public ProcessingDetails getProcessingDetails() {
        return this.mProcessingDetails;
    }

    @Override
    public boolean canBeAborted() {
        return this.getWorkflowAbort() != null && this.getWorkflowAbort().canBeAborted();
    }

    @Override
    public Receipt getMerchantReceipt() {
        return this.mMerchantReceipt;
    }

    @Override
    public Receipt getCustomerReceipt() {
        return this.mCustomerReceipt;
    }

    @Override
    public IncrementalAuthorizationDetails getIncrementalAuthorizationDetails() {
        return this.incrementalAuthorizationDetails;
    }

    public Provider getProvider() {
        return this.mProvider;
    }

    public void setSubject(String subject) {
        this.mSubject = subject;
    }

    public void setCustomIdentifier(String customIdentifier) {
        this.mCustomIdentifier = customIdentifier;
    }

    public boolean isAutoCapture() {
        return this.mAutoCapture;
    }

    public void setAutoCapture(boolean autoCapture) {
        this.mAutoCapture = autoCapture;
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this.mGroupIdentifier = groupIdentifier;
    }

    public void setIdentifier(String identifier) {
        this.mIdentifier = identifier;
    }

    public void setAmount(BigDecimal amount) {
        this.mAmount = amount;
    }

    public void setCurrency(Currency mCurrency) {
        this.mCurrency = mCurrency;
    }

    public void setStatus(TransactionStatus newStatus) {
        this.mStatus = newStatus;
    }

    public void setSessionIdentifier(String sessionIdentifier) {
        this.mSessionIdentifier = sessionIdentifier;
    }

    public void setCaptured(boolean captured) {
        this.mCaptured = captured;
    }

    public void setDetails(TransactionDetails details) {
        this.mDetails = details;
    }

    public void setPaymentDetails(PaymentDetails paymentDetails) {
        this.mPaymentDetails = paymentDetails;
    }

    public void setProcessingDetails(ProcessingDetails processingDetails) {
        this.mProcessingDetails = processingDetails;
    }

    public void setRefundDetails(RefundDetails refundDetails) {
        this.mRefundDetails = refundDetails;
    }

    public void setClearingDetails(ClearingDetails clearingDetails) {
        this.mClearingDetails = clearingDetails;
    }

    public void setCardDetails(CardDetails cardDetails) {
        this.mCardDetails = cardDetails;
    }

    public void setShopperDetails(ShopperDetails shopperDetails) {
        this.mShopperDetails = shopperDetails;
    }

    public void setDccDetails(DccDetails dccDetails) {
        this.mDccDetails = dccDetails;
    }

    public void setGiftCardDetails(@NotNull GiftCardDetails giftCardDetails) {
        this.mGiftCardDetails = giftCardDetails;
    }

    public void setEbtDetails(EbtDetails ebtDetails) {
        this.mEbtDetails = ebtDetails;
    }

    public void setAccessory(AbstractPaymentAccessory accessory) {
        this.mAccessory = accessory;
        if (accessory != null) {
            this.mAccessoryDetails = new DefaultAccessoryDetails(accessory.getAccessoryDetails());
        }
    }

    public void setProvider(Provider provider) {
        this.mProvider = provider;
    }

    public void setReceiptDetails(ReceiptDetails receiptDetails) {
        this.mReceiptDetails = receiptDetails;
    }

    public void setStatusDetails(DefaultTransactionStatusDetails stateDetails) {
        this.mStatusDetails = stateDetails;
    }

    public void setMerchantReceipt(Receipt merchantReceipt) {
        this.mMerchantReceipt = merchantReceipt;
    }

    public void setMerchantDetails(MerchantDetails merchantDetails) {
        this.mMerchantDetails = merchantDetails;
    }

    public void setTaxDetails(TaxDetails taxDetails) {
        this.mTaxDetails = taxDetails;
    }

    public void setInstallmentDetails(InstallmentDetails installmentDetails) {
        this.mInstallmentDetails = installmentDetails;
    }

    public void setCustomerReceipt(Receipt customerReceipt) {
        this.mCustomerReceipt = customerReceipt;
    }

    public void setInternalTypeOverride(TransactionType type) {
        this.mInternalTypeOverride = type;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.mCreatedTimestamp = createdTimestamp;
    }

    public void setReferencedTransactionIdentifier(String referencedTransactionIdentifier) {
        this.mReferencedTransactionIdentifier = referencedTransactionIdentifier;
    }

    public boolean isUnableToGoOnline() {
        return this.mUnableToGoOnline;
    }

    public void setUnableToGoOnline(boolean unableToGoOnline) {
        this.mUnableToGoOnline = unableToGoOnline;
    }

    public void setAccessoryDetails(AccessoryDetails accessoryDetails) {
        this.mAccessoryDetails = accessoryDetails;
    }

    @Override
    public AccessoryDetails getAccessoryDetails() {
        return this.mAccessoryDetails;
    }

    public String getConfigurationToken() {
        return this.mConfigurationToken;
    }

    public void setConfigurationToken(String configurationToken) {
        this.mConfigurationToken = configurationToken;
    }

    public boolean isOverwriteTypeToRefund() {
        return this.overwriteTypeToRefund;
    }

    public void setOverwriteTypeToRefund(boolean overwriteTypeToRefund) {
        this.overwriteTypeToRefund = overwriteTypeToRefund;
    }

    public void setIncrementalAuthorizationDetails(IncrementalAuthorizationDetails incrementalAuthorizationDetails) {
        this.incrementalAuthorizationDetails = incrementalAuthorizationDetails;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof DefaultTransaction)) {
            return false;
        }
        DefaultTransaction defaultTransaction = (DefaultTransaction)o2;
        return !(this.mIdentifier != null ? !this.mIdentifier.equals(defaultTransaction.mIdentifier) : defaultTransaction.mIdentifier != null);
    }

    public AbstractPaymentAccessory getAccessory() {
        return this.mAccessory;
    }

    public ey getWorkflowAbort() {
        return this.mWorkflowAbort;
    }

    public void setWorkflowAbort(ey workflowAbort) {
        this.mWorkflowAbort = workflowAbort;
    }

    private TransactionFlags getFlags() {
        return this.mFlags;
    }

    public DefaultTransaction getPreviousTransaction() {
        return this.mPreviousTransaction;
    }

    public void setPreviousTransaction(DefaultTransaction transaction) {
        this.mPreviousTransaction = transaction;
    }

    public WorkflowInteraction getWorkflowInteraction() {
        return this.mWorkflowInteraction;
    }

    public void setWorkflowInteraction(WorkflowInteraction workflowInteraction) {
        this.mWorkflowInteraction = workflowInteraction;
    }

    public void propagateStateChange(TransactionState state) {
        if (state != this.getState()) {
            this.setState(state);
            BusProvider.getInstance().post((Object)new TransactionStateChangedBusEvent(this, state, this.canBeAborted()));
        }
    }

    @Override
    public TransactionVerificationResults getVerificationResults() {
        return this.mTransactionVerificationResults;
    }

    public void setVerificationResults(TransactionVerificationResults transactionVerificationResults) {
        this.mTransactionVerificationResults = transactionVerificationResults;
    }

    public boolean isTransactionLookedUp() {
        return this.mCreatedTimestamp > 0L;
    }

    @Override
    public TimeZone getCreatedTimeZone() {
        return this.createdTimeZone;
    }

    public void setCreatedTimeZone(TimeZone createdTimeZone) {
        this.createdTimeZone = createdTimeZone;
    }

    @Override
    public TippingParameters getTippingParameters() {
        return this.tippingParameters;
    }

    @Override
    public MerchantDetails getMerchantDetails() {
        return this.mMerchantDetails;
    }

    @Override
    public TaxDetails getTaxDetails() {
        return this.mTaxDetails;
    }

    @Override
    public InstallmentDetails getInstallmentDetails() {
        return this.mInstallmentDetails;
    }

    @Override
    public void setTippingParameters(TippingParameters tippingParameters) {
        this.tippingParameters = tippingParameters;
    }

    public String toString() {
        return "DefaultTransaction{mAmount=" + this.mAmount + ", mCurrency=" + this.mCurrency + ", mSubject='" + this.mSubject + "', mType=" + this.mType + ", mMode=" + this.mMode + ", mInternalTypeOverride=" + this.mInternalTypeOverride + ", mAutoCapture=" + this.mAutoCapture + ", mState=" + this.mState + ", mStatus=" + this.mStatus + ", mStatusDetails=" + this.mStatusDetails + ", mError=" + this.mError + ", mSessionIdentifier='" + this.mSessionIdentifier + "', mIdentifier='" + this.mIdentifier + "', mGroupIdentifier='" + this.mGroupIdentifier + "', mReferencedTransactionIdentifier='" + this.mReferencedTransactionIdentifier + "', mCustomIdentifier='" + this.mCustomIdentifier + "', mCreatedTimestamp=" + this.mCreatedTimestamp + ", mCaptured=" + this.mCaptured + ", mDetails=" + this.mDetails + ", mPaymentDetails=" + this.mPaymentDetails + ", mReceiptDetails=" + this.mReceiptDetails + ", mProcessingDetails=" + this.mProcessingDetails + ", mRefundDetails=" + this.mRefundDetails + ", mClearingDetails=" + this.mClearingDetails + ", mCardDetails=" + this.mCardDetails + ", mShopperDetails=" + this.mShopperDetails + ", mDccDetails=" + this.mDccDetails + ", mGiftCardDetails=" + this.mGiftCardDetails + ", mMerchantDetails=" + this.mMerchantDetails + ", mTaxDetails=" + this.mTaxDetails + ", mInstallmentDetails=" + this.mInstallmentDetails + ", mTransactionVerificationResults=" + this.mTransactionVerificationResults + ", mMerchantReceipt=" + this.mMerchantReceipt + ", mCustomerReceipt=" + this.mCustomerReceipt + ", mProvider=" + this.mProvider + ", mAccessoryDetails=" + this.mAccessoryDetails + ", mConfigurationToken='" + this.mConfigurationToken + "', mWorkflowInteraction=" + this.mWorkflowInteraction + ", mWorkflowAbort=" + this.mWorkflowAbort + ", mTransactionWorkflowType=" + this.mTransactionWorkflowType + ", mWorkflowConfiguration=" + this.mWorkflowConfiguration + ", mSdkUniqueIdentifier='" + this.mSdkUniqueIdentifier + "', mFlags=" + this.mFlags + ", mAccessory=" + this.mAccessory + ", mPreviousTransaction=" + this.mPreviousTransaction + ", mUnableToGoOnline=" + this.mUnableToGoOnline + ", createdTimeZone=" + this.createdTimeZone + ", incrementalAuthorizationDetails=" + this.incrementalAuthorizationDetails + ", mEbtDetails=" + this.mEbtDetails + "}";
    }

    public TransactionWorkflowType getWorkflow() {
        return this.mTransactionWorkflowType;
    }

    public static TransactionWorkflowType getWorkflowOrNull(BaseTransaction transaction) {
        return transaction instanceof DefaultTransaction ? ((DefaultTransaction)transaction).getWorkflow() : null;
    }

    public void setWorkflow(TransactionWorkflowType transactionWorkflowType) {
        this.mTransactionWorkflowType = transactionWorkflowType;
    }

    public boolean isOnlineAuthorized() {
        return this.getApprovalType() != TransactionFlags.ApprovalType.OFFLINE;
    }

    public void setApprovalType(TransactionFlags.ApprovalType approvalType) {
        this.getFlags().setApprovalType(approvalType);
    }

    public TransactionFlags.ApprovalType getApprovalType() {
        return this.getFlags().getApprovalType();
    }

    public void setTransactionGeneration(TransactionFlags.TransactionGeneration transactionGeneration) {
        this.getFlags().setTransactionGeneration(transactionGeneration);
    }

    public TransactionFlags.TransactionGeneration getTransactionGeneration() {
        return this.getFlags().getTransactionGeneration();
    }

    public WorkflowConfiguration getWorkflowConfiguration() {
        return this.mWorkflowConfiguration;
    }

    public void setWorkflowConfiguration(WorkflowConfiguration workflowConfiguration) {
        this.mWorkflowConfiguration = workflowConfiguration;
    }

    public boolean isVerification() {
        return TransactionType.VERIFICATION.equals((Object)this.getType());
    }

    public int hashCode() {
        return this.mIdentifier != null ? this.mIdentifier.hashCode() : 0;
    }

    @Nullable
    public InteracAccountType getInteracAccountType() {
        return this.mInteracAccountType;
    }

    public void setInteracAccountType(@Nullable InteracAccountType mInteracAccountType) {
        this.mInteracAccountType = mInteracAccountType;
    }

    @Nullable
    public Locale getSelectedLanguage() {
        return this.mSelectedLanguage;
    }

    public void setSelectedLanguage(@Nullable Locale mSelectedLanguage) {
        this.mSelectedLanguage = mSelectedLanguage;
    }
}

