/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.validator;

import io.mpos.shared.validator.ValidationError;
import io.mpos.shared.validator.ValidationResult;
import io.mpos.shared.validator.Validator;
import io.mpos.shared.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.List;

public class ValidationExecutor {
    private static final String TAG = "ValidationExecutor";
    private ValidatorContext context = new ValidatorContext();
    private ValidationResult result = new ValidationResult();
    private List<Validator> validators = new ArrayList<Validator>();
    private boolean failFast = false;

    private ValidationExecutor() {
    }

    public static ValidationExecutor create() {
        return new ValidationExecutor();
    }

    public ValidationExecutor with(Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public ValidationExecutor failFast() {
        this.failFast = true;
        return this;
    }

    public ValidationResult validate() {
        if (this.validators.isEmpty()) {
            return this.result;
        }
        this.context.setResult(this.result);
        try {
            for (Validator validator : this.validators) {
                if (validator.validate(this.context)) continue;
                this.result.setSuccess(false);
                if (!this.failFast) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.result.setSuccess(false);
            this.result.addError(ValidationError.create("Exception occurred during validation", 0));
        }
        return this.result;
    }
}

