/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.workflows;

import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.core.common.obfuscated.ex;
import io.mpos.core.common.obfuscated.fZ;
import io.mpos.core.common.obfuscated.ff;
import io.mpos.core.common.obfuscated.gZ;
import io.mpos.core.common.obfuscated.ha;
import io.mpos.core.common.obfuscated.hb;
import io.mpos.core.common.obfuscated.hd;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.platform.AbstractImageHelper;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.shared.accessories.PaymentAccessoryRequirement;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessCancelUpgradeFailureListener;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProcessingOptionsContainer;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.actionsupport.TransactionActionSupport;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultTransactionWorkflow
extends hd {
    private final String TAG = "DefaultTransactionWorkflow";
    private final Provider<ex> workflowProvider;

    @Inject
    public DefaultTransactionWorkflow(TransactionProcessor transactionProcessor, Configuration configuration, Locale locale, ff fragmentFactory, AbstractImageHelper abstractImageHelper, Provider<ex> workflowProvider, Profiler profiler) {
        super(transactionProcessor, configuration, locale, fragmentFactory, abstractImageHelper, profiler);
        this.workflowProvider = workflowProvider;
    }

    @Override
    public void start(DefaultTransaction transaction, TransactionListener listener) {
        this.setTransaction(transaction);
        this.setTransactionListener(listener);
        this.internalStart();
    }

    private void internalStart() {
        boolean bl2;
        ProcessingOptionsContainer processingOptionsContainer;
        boolean bl3 = this.transaction.getAccessory().getPaymentAccessoryFeatures().contains((Object)PaymentAccessoryFeatures.REFUND);
        if (this.transaction.getType() == TransactionType.REFUND && !bl3) {
            this.returnTransactionFailure(new DefaultMposError(ErrorType.ACCESSORY_ERROR, "This accessory does not support card present refunds."));
        }
        boolean bl4 = (processingOptionsContainer = this.configuration.getProcessingOptionsContainer()).isSourceAllowed(PaymentDetailsSource.NFC_ICC) || processingOptionsContainer.isSourceAllowed(PaymentDetailsSource.NFC_MAGSTRIPE);
        boolean bl5 = this.transaction.getMode() == TransactionMode.ONLINE;
        boolean bl6 = this.transaction.getAccessory().getPaymentAccessoryFeatures().contains((Object)PaymentAccessoryFeatures.NFC);
        boolean bl7 = bl2 = this.transaction.getPaymentDetails().getSource() == PaymentDetailsSource.MANUAL;
        if (bl2) {
            DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
            defaultPaymentDetails.setSource(PaymentDetailsSource.MANUAL);
            this.step2_startTransactionBasedOnCard(defaultPaymentDetails);
            return;
        }
        if (bl4 && bl6 && bl5) {
            boolean bl8 = DefaultProvider.getProviderLocalConfiguration().isShowNFCUpgradeScreen();
            if (bl8 && this.isManualNfcActivationRequired()) {
                this.step1_detectCardWithState(ha.d);
            } else {
                this.step2_startNFCTransaction();
            }
        } else {
            this.step1_detectCardWithState(bl5 ? ha.b : ha.c);
        }
    }

    private void step1_detectCardWithState(ha state) {
        Log.i("DefaultTransactionWorkflow", "starting resolve card workflow with state: " + state);
        if (state == ha.b || state == ha.d || state == ha.c || state == ha.e) {
            this.resetPaymentDetailsSource();
        }
        gZ gZ2 = new gZ(this.transactionProcessor, this.configuration, this.locale, this.transaction, this.fragmentFactory, this.getProfiler());
        gZ2.a(state);
        this.updateAbortInteractionWorkflows(gZ2, null);
        gZ2.a(new GenericOperationSuccessCancelUpgradeFailureListener<DefaultTransaction, DefaultPaymentDetails>(){

            @Override
            public void onOperationSuccess(DefaultTransaction operator, DefaultPaymentDetails details) {
                DefaultTransactionWorkflow.this.step2_startTransactionBasedOnCard(details);
            }

            @Override
            public void onOperationCancel(DefaultTransaction operation) {
                DefaultTransactionWorkflow.this.returnTransactionAbort();
            }

            @Override
            public void onOperationFailure(DefaultTransaction operator, MposError error) {
                DefaultTransactionWorkflow.this.returnTransactionFailure(error);
            }

            @Override
            public void onOperationUpgrade(DefaultTransaction operation, hb upgrade) {
                if (upgrade == hb.a) {
                    DefaultTransactionWorkflow.this.step2_startNFCTransaction();
                } else if (upgrade == hb.b) {
                    DefaultTransactionWorkflow.this.step2_startNFCTransactionCvmLimitZero();
                } else {
                    Log.e("DefaultTransactionWorkflow", "got upgrade from detect card without target");
                }
            }
        });
    }

    private void step2_startNFCTransaction() {
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setSource(PaymentDetailsSource.NFC_ICC);
        this.step2_startTransactionBasedOnCard(defaultPaymentDetails);
    }

    private void step2_startNFCTransactionCvmLimitZero() {
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setSource(PaymentDetailsSource.NFC_ICC);
        defaultPaymentDetails.setForceZeroCvmLimit(true);
        this.step2_startTransactionBasedOnCard(defaultPaymentDetails);
    }

    private void step2_startTransactionBasedOnCard(DefaultPaymentDetails details) {
        Log.i("DefaultTransactionWorkflow", "starting payment workflow after card detection");
        ((DefaultPaymentDetails)this.getTransaction().getPaymentDetails()).applyOtherPaymentDetails(details);
        ex ex2 = (ex)this.workflowProvider.get();
        if (ex2 == null) {
            this.transaction.setStatus(TransactionStatus.ERROR);
            this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR);
            this.returnTransactionFailure(new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "no appropriate payment workflow found."));
            return;
        }
        this.updateAbortInteractionWorkflows(ex2, ex2);
        ex2.start(new fZ(){

            @Override
            public void onTransactionApproved(BaseTransaction transaction) {
                DefaultTransactionWorkflow.this.returnTransactionApproval();
            }

            @Override
            public void onTransactionDeclined(BaseTransaction transaction) {
                if (transaction.getStatus() == TransactionStatus.ERROR) {
                    DefaultMposError defaultMposError = new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Processing gateway was not able to go online for online authorization");
                    DefaultTransactionWorkflow.this.returnTransactionFailure(defaultMposError);
                } else {
                    DefaultTransactionWorkflow.this.returnTransactionDecline();
                }
            }

            @Override
            public void onTransactionAborted(BaseTransaction transaction) {
                DefaultTransactionWorkflow.this.returnTransactionAbort();
            }

            @Override
            public void onTransactionFailure(BaseTransaction transaction, MposError error) {
                String cfr_ignored_0 = "internal payment workflow returned failure " + error;
                DefaultTransactionWorkflow.this.returnTransactionFailure(error);
            }

            @Override
            public void onTransactionActionRequired(BaseTransaction transaction, TransactionAction action, TransactionActionSupport supportData) {
                DefaultTransactionWorkflow.this.returnTransactionActionRequired(action, supportData);
            }

            @Override
            public void onTransactionFallback(BaseTransaction transaction, ha state) {
                DefaultTransactionWorkflow.this.step1_detectCardWithState(state);
            }

            @Override
            public void onTransactionAlternativeCardPresented(PaymentDetails details) {
                DefaultTransactionWorkflow.this.step2_startTransactionBasedOnCard((DefaultPaymentDetails)details);
            }

            @Override
            public void onTransactionStartOver(BaseTransaction transaction) {
                DefaultTransactionWorkflow.this.startOverWithEvaluation();
            }
        });
    }

    private boolean isManualNfcActivationRequired() {
        AbstractPaymentAccessory abstractPaymentAccessory = this.getTransaction().getAccessory();
        ProcessingOptionsContainer processingOptionsContainer = this.configuration.getProcessingOptionsContainer();
        boolean bl2 = abstractPaymentAccessory.getPaymentAccessoryRequirements().contains((Object)PaymentAccessoryRequirement.MANUAL_NFC_ACTIVATION);
        String cfr_ignored_0 = "Accessory supports manual activation: " + bl2;
        boolean bl3 = processingOptionsContainer.getAccessoryBehaviors().contains((Object)ProcessingOptions.Behavior.NFC_ENABLE_REQUIRES_INTERACTION);
        String cfr_ignored_1 = "Backend forces manual activation: " + bl3;
        boolean bl4 = bl2 && bl3;
        String cfr_ignored_2 = "Therefore manual activation required: " + bl4;
        return bl4;
    }

    private void startOverWithEvaluation() {
        AbstractPaymentAccessory abstractPaymentAccessory = this.getTransaction().getAccessory();
        ProcessingOptionsContainer processingOptionsContainer = this.configuration.getProcessingOptionsContainer();
        PaymentDetailsSource paymentDetailsSource = this.getTransaction().getPaymentDetails().getSource();
        boolean bl2 = paymentDetailsSource == PaymentDetailsSource.NFC_ICC || paymentDetailsSource == PaymentDetailsSource.NFC_MAGSTRIPE;
        String cfr_ignored_0 = "Coming from NFC workflow: " + bl2;
        if (!bl2) {
            this.internalStart();
            return;
        }
        this.resetPaymentDetailsSource();
        boolean bl3 = abstractPaymentAccessory.getPaymentAccessoryRequirements().contains((Object)PaymentAccessoryRequirement.CONTACTLESS_ONLY_WORKAROUND);
        String cfr_ignored_1 = "Accessory contactless only certified: " + bl3;
        if (!bl3) {
            this.internalStart();
            return;
        }
        boolean bl4 = processingOptionsContainer.getAccessoryBehaviors().contains((Object)ProcessingOptions.Behavior.NFC_DISABLE_USE_OF_INTERFACE_SWITCH_INSTEAD_OF_TRY_OTHER_CARD);
        String cfr_ignored_2 = "Backend forces try other card instead of insert/swipe: " + bl4;
        if (bl4) {
            this.internalStart();
        } else {
            this.step1_detectCardWithState(ha.b);
        }
    }

    private void resetPaymentDetailsSource() {
        ((DefaultPaymentDetails)this.getTransaction().getPaymentDetails()).setSource(PaymentDetailsSource.UNKNOWN);
    }

    public static interface TransactionPaymentWorkflowProvider {
        public ex provide(TransactionProcessor var1, Configuration var2, Locale var3, DefaultTransaction var4, ff var5, AbstractImageHelper var6);
    }
}

