/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.workflows.util;

import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.localization.LocalizationPromptParameters;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.transactions.DefaultTransaction;
import java.util.Set;

public class ConsumerChoiceHelper {
    private ConsumerChoiceHelper() {
    }

    public static boolean isConsumerChoiceEnabled(Set<ProcessingOptions.Behavior> behaviors, DefaultTransaction transaction) {
        return behaviors.contains((Object)ProcessingOptions.Behavior.PREFERRED_AID_SELECTION) && transaction.getAccessory().getPaymentAccessoryFeatures().contains((Object)PaymentAccessoryFeatures.YELLOW_KEY_ON_NFC);
    }

    public static String getConsumerChoiceFooterText(DefaultTransaction transaction) {
        LocalizationPromptParameters localizationPromptParameters = new LocalizationPromptParameters.Builder(LocalizationPrompt.PAYMENT_OPTIONS).initFromPaymentAccessory(transaction.getAccessory()).build();
        return LocalizationServer.getInstance().getLocalizationArray(localizationPromptParameters)[0];
    }
}

