/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv;

import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

public class ConstructedTlv
extends TlvObject {
    protected ArrayList<TlvObject> items = new ArrayList();

    public ConstructedTlv() {
    }

    public ConstructedTlv(byte[] tagBytes) {
        if (tagBytes == null) {
            throw new IllegalArgumentException("The tagBytes must not be null.");
        }
        if (tagBytes.length < 1) {
            throw new IllegalArgumentException("The tagBytes must have length >= 1.");
        }
        this.tagBytes = tagBytes;
    }

    public ConstructedTlv(byte cla, int tag) {
        if (cla > 3) {
            throw new IllegalArgumentException("CLA must be 0x00, 0x01, 0x02 or 0x03.");
        }
        this.tagBytes = super.buildTagBytes(cla, tag);
    }

    @Override
    public byte[] serialize() {
        if (this.cacheSerialization != null) {
            return this.cacheSerialization;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLen());
        for (TlvObject object2 : this.items) {
            byteBuffer.put(object2.serialize());
        }
        Object object3 = byteBuffer.array();
        byte[] byArray = super.buildLenBytes(((Object)object3).length);
        int n2 = this.tagBytes.length + byArray.length + ((Object)object3).length;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        byteBuffer2.put(this.tagBytes);
        byteBuffer2.put(byArray);
        byteBuffer2.put((byte[])object3);
        this.cacheSerialization = byteBuffer2.array();
        return this.cacheSerialization;
    }

    static TlvObject deserialize(byte[] tagBytes, int len, ByteBuffer buffer) {
        ConstructedTlv constructedTlv = new ConstructedTlv(tagBytes);
        int n2 = buffer.position();
        while (buffer.position() < n2 + len) {
            TlvObject tlvObject = TlvObject.deserialize(buffer);
            if (tlvObject == null) continue;
            constructedTlv.addItem(tlvObject);
        }
        return constructedTlv;
    }

    public void addItem(TlvObject item) {
        this.cacheSerialization = null;
        if (item != null) {
            this.items.add(item);
        }
    }

    public void addItems(TlvObject ... items) {
        this.cacheSerialization = null;
        for (TlvObject tlvObject : items) {
            if (tlvObject == null) continue;
            this.items.add(tlvObject);
        }
    }

    public void addItems(Collection<TlvObject> collection) {
        this.cacheSerialization = null;
        this.items.addAll(collection);
    }

    @Deprecated
    public ArrayList<TlvObject> getFlatCopyOfItems() {
        return (ArrayList)this.items.clone();
    }

    public ArrayList<TlvObject> getItems() {
        return this.items;
    }

    @Override
    protected int getLen() {
        int n2 = 0;
        for (TlvObject tlvObject : this.items) {
            n2 += tlvObject.serialize().length;
        }
        return n2;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        ConstructedTlv constructedTlv = (ConstructedTlv)o2;
        return !(this.items != null ? !this.items.equals(constructedTlv.items) : constructedTlv.items != null);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.items != null ? this.items.hashCode() : 0);
        return n2;
    }

    @Override
    public String toString() {
        String string = "none";
        if (this.items != null && this.items.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (TlvObject tlvObject : this.items) {
                if (tlvObject == null) continue;
                stringBuilder.append(tlvObject.toString());
                stringBuilder.append(", ");
            }
            string = stringBuilder.toString();
        }
        return "ConstructedTlv{tagBytes=" + ByteHelper.toHexString(this.getTagBytes()) + (String)(this.cacheSerialization != null ? ", cacheSerialization=" + ByteHelper.toHexString(this.cacheSerialization) : "") + ", items=[" + string + "\n]}";
    }
}

